/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MultiDimensionalStore
implements ITermProvider {
    private final Term mArray;
    private final ArrayIndex mIndex;
    private final Term mValue;

    public MultiDimensionalStore(Term term, ArrayIndex arrayIndex, Term term2) {
        if (arrayIndex.isEmpty()) {
            throw new AssertionError((Object)"Zero dimensions are not supported");
        }
        assert (MultiDimensionalSort.areDimensionsConsistent(term, arrayIndex, term2));
        this.mArray = term;
        this.mIndex = arrayIndex;
        this.mValue = term2;
    }

    private static boolean isStore(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getName().equals("store");
        }
        return false;
    }

    static boolean isCompatibleSelect(Term term, Term term2, List<Term> list) {
        if (list.isEmpty()) {
            return term == term2;
        }
        MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of(term);
        if (multiDimensionalSelect == null) {
            return false;
        }
        return multiDimensionalSelect.getArray() == term2 && list.equals(multiDimensionalSelect.getIndex());
    }

    public Term getArray() {
        return this.mArray;
    }

    public ArrayIndex getIndex() {
        return this.mIndex;
    }

    public Term getValue() {
        return this.mValue;
    }

    public int getDimension() {
        return this.getIndex().size();
    }

    @Override
    public Term toTerm(Script script) {
        return SmtUtils.multiDimensionalStore(script, this.getArray(), this.getIndex(), this.getValue());
    }

    public static MultiDimensionalStore of(Term term) {
        return MultiDimensionalStore.of(term, Integer.MAX_VALUE);
    }

    private static MultiDimensionalStore of(Term term, int n) {
        Term term2;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Term term3 = term;
        if (MultiDimensionalStore.isStore(term)) {
            term2 = ((ApplicationTerm)term).getParameters()[0];
            arrayList.add(((ApplicationTerm)term).getParameters()[1]);
            term3 = ((ApplicationTerm)term).getParameters()[2];
            int n2 = 1;
            while (n2 < n && MultiDimensionalStore.isStore(term3) && MultiDimensionalStore.isCompatibleSelect(((ApplicationTerm)term3).getParameters()[0], term2, arrayList)) {
                arrayList.add(((ApplicationTerm)term3).getParameters()[1]);
                term3 = ((ApplicationTerm)term3).getParameters()[2];
                ++n2;
            }
        } else {
            return null;
        }
        return new MultiDimensionalStore(term2, new ArrayIndex(arrayList), term3);
    }

    public MultiDimensionalStore getOutermost(Script script, int n) {
        if (n <= 0) {
            throw new AssertionError((Object)"Must extract at least one dimension");
        }
        if (n >= this.getDimension()) {
            throw new AssertionError((Object)"Must not extract all dimensions");
        }
        ArrayIndex arrayIndex = this.mIndex.getFirst(n);
        ArrayIndex arrayIndex2 = this.mIndex.getLast(this.mIndex.size() - n);
        MultiDimensionalSelect multiDimensionalSelect = new MultiDimensionalSelect(this.mArray, arrayIndex);
        MultiDimensionalStore multiDimensionalStore = new MultiDimensionalStore(multiDimensionalSelect.toTerm(script), arrayIndex2, this.mValue);
        return new MultiDimensionalStore(this.mArray, arrayIndex, multiDimensionalStore.toTerm(script));
    }

    public String toString() {
        return String.format("(store %s %s %s)", this.mArray, this.mIndex, this.mValue);
    }

    public int hashCode() {
        return Objects.hash(this.mArray, this.mIndex, this.mValue);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalStore multiDimensionalStore = (MultiDimensionalStore)object;
        if (this.mArray == null ? multiDimensionalStore.mArray != null : !this.mArray.equals(multiDimensionalStore.mArray)) {
            return false;
        }
        if (this.mIndex == null ? multiDimensionalStore.mIndex != null : !this.mIndex.equals(multiDimensionalStore.mIndex)) {
            return false;
        }
        return !(this.mValue == null ? multiDimensionalStore.mValue != null : !this.mValue.equals(multiDimensionalStore.mValue));
    }

    public static List<MultiDimensionalStore> extractArrayStoresShallow(Term term) {
        ArrayList<MultiDimensionalStore> arrayList = new ArrayList<MultiDimensionalStore>();
        Set<ApplicationTerm> set = SmtUtils.extractApplicationTerms("store", term, true);
        for (Term term2 : set) {
            MultiDimensionalStore multiDimensionalStore = MultiDimensionalStore.of(term2);
            if (multiDimensionalStore.getIndex().size() == 0) {
                throw new AssertionError((Object)"store must not have dimension 0");
            }
            arrayList.add(multiDimensionalStore);
        }
        return arrayList;
    }

    public static List<MultiDimensionalStore> extractArrayStoresDeep(Term term) {
        LinkedList<MultiDimensionalStore> linkedList = new LinkedList<MultiDimensionalStore>();
        List<MultiDimensionalStore> list = MultiDimensionalStore.extractArrayStoresShallow(term);
        while (!list.isEmpty()) {
            linkedList.addAll(0, list);
            List<MultiDimensionalStore> list2 = list;
            list = new ArrayList<MultiDimensionalStore>();
            for (MultiDimensionalStore multiDimensionalStore : list2) {
                list.addAll(MultiDimensionalStore.extractArrayStoresShallow(multiDimensionalStore.getArray()));
                list.addAll(MultiDimensionalStore.extractArrayStoresShallow(multiDimensionalStore.getValue()));
                ArrayIndex arrayIndex = multiDimensionalStore.getIndex();
                for (Term term2 : arrayIndex) {
                    list.addAll(MultiDimensionalStore.extractArrayStoresShallow(term2));
                }
            }
        }
        return linkedList;
    }
}

