/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.Interval;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.NonrelationalState;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.StateBasedDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.TermToInterval;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class IntervalDomain
extends StateBasedDomain<NonrelationalState<Interval>> {
    public IntervalDomain(ILogger iLogger, SymbolicTools symbolicTools, int n, Supplier<IProgressAwareTimer> supplier) {
        super(symbolicTools, n, iLogger, supplier, new IntervalStateProvider(supplier, iLogger, symbolicTools.getScript()));
    }

    private static class CompareNumberOfFreeVariablesInRhs
    implements Comparator<SolvedBinaryRelation> {
        private final Map<SolvedBinaryRelation, Integer> mNumberOfFreeVarsInRhs;

        CompareNumberOfFreeVariablesInRhs(Collection<SolvedBinaryRelation> collection) {
            this.mNumberOfFreeVarsInRhs = collection.stream().collect(Collectors.toMap(solvedBinaryRelation -> solvedBinaryRelation, solvedBinaryRelation -> solvedBinaryRelation.getRightHandSide().getFreeVars().length));
        }

        @Override
        public int compare(SolvedBinaryRelation solvedBinaryRelation, SolvedBinaryRelation solvedBinaryRelation2) {
            return this.mNumberOfFreeVarsInRhs.get(solvedBinaryRelation).compareTo(this.mNumberOfFreeVarsInRhs.get(solvedBinaryRelation2));
        }
    }

    private static class IntervalStateProvider
    implements StateBasedDomain.IStateProvider<NonrelationalState<Interval>> {
        private final Supplier<IProgressAwareTimer> mTimeout;
        private final ILogger mLogger;
        private final Script mScript;

        public IntervalStateProvider(Supplier<IProgressAwareTimer> supplier, ILogger iLogger, Script script) {
            this.mTimeout = supplier;
            this.mLogger = iLogger;
            this.mScript = script;
        }

        @Override
        public NonrelationalState<Interval> toState(Term[] termArray) {
            IProgressAwareTimer iProgressAwareTimer = this.mTimeout.get();
            List<SolvedBinaryRelation> list = this.solveForAllSubjects(termArray);
            HashMap<Term, Interval> hashMap = new HashMap<Term, Interval>();
            boolean bl = true;
            long l = 1L + list.stream().map(SolvedBinaryRelation::getLeftHandSide).distinct().count();
            int n = 1;
            while (bl && (long)n <= l) {
                if (!iProgressAwareTimer.continueProcessing()) {
                    this.mLogger.warn((Object)"Term to interval evaluator loop timed out before fixpoint was reached. Continuing with non-optimal over-approximation.");
                    break;
                }
                bl = false;
                for (SolvedBinaryRelation solvedBinaryRelation : list) {
                    Optional<Interval> optional = IntervalStateProvider.updatedLhsInterval(hashMap, solvedBinaryRelation);
                    if (!optional.isPresent()) continue;
                    if (optional.get().isBottom()) {
                        return new NonrelationalState<Interval>(hashMap);
                    }
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                this.mLogger.warn("Interval conversion did not stabilize in %d iterations. Over-approximation may be very coarse.", new Object[]{l});
                this.mLogger.debug("Relations used to update are %s.", new Object[]{list});
                this.mLogger.debug("Interval values after last iteration are %s.", new Object[]{hashMap});
            }
            return new NonrelationalState<Interval>(hashMap);
        }

        @Override
        public NonrelationalState<Interval> getTopState() {
            return new NonrelationalState<Interval>();
        }

        @Override
        public Term preprocessTerm(Term term) {
            return term;
        }

        private List<SolvedBinaryRelation> solveForAllSubjects(Term[] termArray) {
            ArrayList<SolvedBinaryRelation> arrayList = new ArrayList<SolvedBinaryRelation>();
            Term[] termArray2 = termArray;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray2[n2];
                PolynomialRelation polynomialRelation = PolynomialRelation.of((Script)this.mScript, (Term)term);
                if (polynomialRelation != null) {
                    TermVariable[] termVariableArray = term.getFreeVars();
                    int n3 = termVariableArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TermVariable termVariable = termVariableArray[n4];
                        SolvedBinaryRelation solvedBinaryRelation = polynomialRelation.solveForSubject(this.mScript, (Term)termVariable);
                        if (solvedBinaryRelation != null) {
                            arrayList.add(solvedBinaryRelation);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            Collections.sort(arrayList, new CompareNumberOfFreeVariablesInRhs(arrayList));
            return arrayList;
        }

        private static Optional<Interval> updatedLhsInterval(Map<Term, Interval> map, SolvedBinaryRelation solvedBinaryRelation) {
            Interval interval;
            assert (solvedBinaryRelation.getLeftHandSide() instanceof TermVariable);
            TermVariable termVariable = (TermVariable)solvedBinaryRelation.getLeftHandSide();
            Interval interval2 = map.getOrDefault(termVariable, Interval.TOP);
            if (interval2.equals(interval = IntervalStateProvider.updatedLhsForRelation(interval2, solvedBinaryRelation.getRelationSymbol(), TermToInterval.evaluate(solvedBinaryRelation.getRightHandSide(), map)))) {
                return Optional.empty();
            }
            map.put((Term)termVariable, interval);
            return Optional.of(interval);
        }

        private static Interval updatedLhsForRelation(Interval interval, RelationSymbol relationSymbol, Interval interval2) {
            switch (relationSymbol) {
                case DISTINCT: {
                    return interval.satisfyDistinct(interval2).getLhs();
                }
                case EQ: {
                    return interval.satisfyEqual(interval2).getLhs();
                }
                case GEQ: 
                case GREATER: {
                    return interval.satisfyGreaterOrEqual(interval2).getLhs();
                }
                case LEQ: 
                case LESS: {
                    return interval.satisfyLessOrEqual(interval2).getLhs();
                }
            }
            throw new AssertionError((Object)("Missing case for " + String.valueOf(relationSymbol)));
        }
    }
}

