/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransformerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class RewriteDisequality
extends TransformerPreprocessor {
    public static final String DESCRIPTION = "Replaces a != b with (a > b \\/ a < b)";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula modifiableTransFormula, ModifiableTransFormula modifiableTransFormula2) {
        Term term = modifiableTransFormula.getFormula();
        Term term2 = modifiableTransFormula2.getFormula();
        return Script.LBool.SAT != Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{term, term2}));
    }

    @Override
    protected TermTransformer getTransformer(ManagedScript managedScript) {
        return new RewriteDisequalityTransformer(managedScript.getScript());
    }

    public static final class RewriteDisequalityTransformer
    extends TermTransformer {
        private static final Set<String> SUPPORTED_SORTS = new HashSet<String>(Arrays.asList("Int", "Real"));
        private final Script mScript;

        public RewriteDisequalityTransformer(Script script) {
            assert (script != null);
            this.mScript = script;
        }

        protected void convert(Term term) {
            ApplicationTerm applicationTerm;
            Object object;
            if (!(term instanceof ApplicationTerm)) {
                super.convert(term);
                return;
            }
            ApplicationTerm applicationTerm2 = (ApplicationTerm)term;
            String string = applicationTerm2.getFunction().getName();
            Term[] termArray = null;
            if ("not".equals(string)) {
                object = applicationTerm2.getParameters()[0];
                assert (applicationTerm2.getParameters().length == 1) : "not with more than one parameter not supported";
                if (object instanceof ApplicationTerm && "=".equals((applicationTerm = (ApplicationTerm)object).getFunction().getName())) {
                    termArray = applicationTerm.getParameters();
                }
            } else if ("distinct".equals(string)) {
                termArray = applicationTerm2.getParameters();
            }
            if (termArray == null) {
                super.convert(term);
                return;
            }
            object = termArray[0].getSort().getName();
            if (!SUPPORTED_SORTS.contains(object)) {
                this.setResult(term);
                return;
            }
            assert (termArray.length == 2) : "distinct / equals with more than two parameters not yet supported";
            applicationTerm = this.mScript.term("<", termArray);
            Term term2 = this.mScript.term(">", termArray);
            this.setResult(this.mScript.term("or", new Term[]{applicationTerm, term2}));
        }

        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            this.setResult(SmtUtils.convertApplicationTerm((ApplicationTerm)applicationTerm, (Term[])termArray, (Script)this.mScript));
        }
    }
}

