/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class IfThenElseExpression
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(IfThenElseExpression.class);
    Expression condition;
    Expression thenPart;
    Expression elsePart;

    public IfThenElseExpression(Expression expression, Expression expression2, Expression expression3) {
        this.condition = expression;
        this.thenPart = expression2;
        this.elsePart = expression3;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid IfThenElseExpression: " + String.valueOf(this);
    }

    public IfThenElseExpression(ACSLType aCSLType, Expression expression, Expression expression2, Expression expression3) {
        super(aCSLType);
        this.condition = expression;
        this.thenPart = expression2;
        this.elsePart = expression3;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid IfThenElseExpression: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IfThenElseExpression").append('[');
        stringBuffer.append(this.condition);
        stringBuffer.append(',').append(this.thenPart);
        stringBuffer.append(',').append(this.elsePart);
        return stringBuffer.append(']').toString();
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getThenPart() {
        return this.thenPart;
    }

    public Expression getElsePart() {
        return this.elsePart;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.condition);
        list.add(this.thenPart);
        list.add(this.elsePart);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.condition != null) {
                this.condition.accept(aCSLVisitor);
            }
            if (this.thenPart != null) {
                this.thenPart.accept(aCSLVisitor);
            }
            if (this.elsePart != null) {
                this.elsePart.accept(aCSLVisitor);
            }
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.condition != null) {
            expression2 = this.condition.accept(aCSLTransformer);
        }
        Expression expression3 = null;
        if (this.thenPart != null) {
            expression3 = this.thenPart.accept(aCSLTransformer);
        }
        Expression expression4 = null;
        if (this.elsePart != null) {
            expression4 = this.elsePart.accept(aCSLTransformer);
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        if (this.condition != expression2 || this.thenPart != expression3 || this.elsePart != expression4 || this.type != aCSLType) {
            return new IfThenElseExpression(aCSLType, expression2, expression3, expression4);
        }
        return this;
    }
}

