/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval;

import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.AbsIntBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.generic.LiteralCollection;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalPostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalLiteralWideningOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalNonAbstractabilityDeciderPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalPostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalSimpleWideningOperator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import java.util.function.Predicate;

public class IntervalDomain
implements IAbstractDomain<IntervalDomainState, IcfgEdge> {
    private final ILogger mLogger;
    private final LiteralCollection mLiteralCollection;
    private final IUltimateServiceProvider mServices;
    private final BoogieIcfgContainer mRootAnnotation;
    private final BoogieSymbolTable mSymbolTable;
    private final SubtermPropertyChecker mAbstractablePropertyChecker;
    private IAbstractStateBinaryOperator<IntervalDomainState> mWideningOperator;
    private NonrelationalPostOperator<IntervalDomainState, IntervalDomainValue> mPostOperator;
    private final CfgSmtToolkit mCfgSmtToolkit;
    private final IBoogieSymbolTableVariableProvider mBpl2SmtSymbolTable;

    public IntervalDomain(ILogger iLogger, BoogieSymbolTable boogieSymbolTable, LiteralCollection literalCollection, IUltimateServiceProvider iUltimateServiceProvider, BoogieIcfgContainer boogieIcfgContainer, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider) {
        this.mLogger = iLogger;
        this.mLiteralCollection = literalCollection;
        this.mServices = iUltimateServiceProvider;
        this.mCfgSmtToolkit = boogieIcfgContainer.getCfgSmtToolkit();
        this.mRootAnnotation = boogieIcfgContainer;
        this.mSymbolTable = boogieSymbolTable;
        this.mBpl2SmtSymbolTable = iBoogieSymbolTableVariableProvider;
        this.mAbstractablePropertyChecker = new SubtermPropertyChecker((Predicate)new IntervalNonAbstractabilityDeciderPredicate());
    }

    public IntervalDomainState createTopState() {
        return new IntervalDomainState(this.mLogger, false);
    }

    public IntervalDomainState createBottomState() {
        return new IntervalDomainState(this.mLogger, true);
    }

    public IAbstractStateBinaryOperator<IntervalDomainState> getWideningOperator() {
        if (this.mWideningOperator == null) {
            IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
            String string = iPreferenceProvider.getString("Interval Widening operator");
            if (string.equals(IntervalDomainPreferences.VALUE_WIDENING_OPERATOR_SIMPLE)) {
                this.mWideningOperator = new IntervalSimpleWideningOperator();
            } else if (string.equals(IntervalDomainPreferences.VALUE_WIDENING_OPERATOR_LITERALS)) {
                IntervalLiteralWideningOperator intervalLiteralWideningOperator = new IntervalLiteralWideningOperator(this.mLiteralCollection);
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Using the following literals during widening: " + String.valueOf(this.mLiteralCollection)));
                }
                this.mWideningOperator = intervalLiteralWideningOperator;
            } else {
                throw new UnsupportedOperationException("The widening operator " + string + " is not implemented.");
            }
        }
        return this.mWideningOperator;
    }

    public NonrelationalPostOperator<IntervalDomainState, IntervalDomainValue> getPostOperator() {
        if (this.mPostOperator == null) {
            IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
            int n = iPreferenceProvider.getInt("Parallel states before merging");
            int n2 = iPreferenceProvider.getInt("Maximum recursion depth of evaluation operations");
            IntervalDomainEvaluator intervalDomainEvaluator = new IntervalDomainEvaluator(this.mLogger, this.mSymbolTable, this.mBpl2SmtSymbolTable, n, n2);
            this.mPostOperator = new IntervalPostOperator(this.mLogger, this.mSymbolTable, this.mBpl2SmtSymbolTable, n, this.mRootAnnotation.getBoogie2SMT(), this.mCfgSmtToolkit, intervalDomainEvaluator);
        }
        return this.mPostOperator;
    }

    public boolean isAbstractable(Term term) {
        return !this.mAbstractablePropertyChecker.isSatisfiedBySomeSubterm(term);
    }

    public void beforeFixpointComputation(Object ... objectArray) {
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof AbsIntBenchmark) {
                AbsIntBenchmark absIntBenchmark = (AbsIntBenchmark)object;
                this.getPostOperator().setAbsIntBenchmark(absIntBenchmark);
            }
            ++n2;
        }
    }
}

