/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntIterator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import java.util.HashSet;
import java.util.Iterator;

public class IntSetHashSet
implements IntSet {
    private final HashSet<Integer> mSet = new HashSet();

    @Override
    public IntIterator iterator() {
        return new HashSetIterator(this);
    }

    @Override
    public IntSet clone() {
        IntSetHashSet intSetHashSet = new IntSetHashSet();
        intSetHashSet.mSet.addAll(this.mSet);
        return intSetHashSet;
    }

    @Override
    public void andNot(IntSet intSet) {
        assert (intSet instanceof IntSetHashSet) : "OPERAND should be HashSet";
        IntSetHashSet intSetHashSet = (IntSetHashSet)intSet;
        this.mSet.removeAll(intSetHashSet.mSet);
    }

    @Override
    public void and(IntSet intSet) {
        assert (intSet instanceof IntSetHashSet) : "OPERAND should be HashSet";
        IntSetHashSet intSetHashSet = (IntSetHashSet)intSet;
        this.mSet.retainAll(intSetHashSet.mSet);
    }

    @Override
    public void or(IntSet intSet) {
        assert (intSet instanceof IntSetHashSet) : "OPERAND should be HashSet";
        IntSetHashSet intSetHashSet = (IntSetHashSet)intSet;
        this.mSet.addAll(intSetHashSet.mSet);
    }

    @Override
    public boolean get(int n) {
        return this.mSet.contains(n);
    }

    @Override
    public void set(int n) {
        this.mSet.add(n);
    }

    @Override
    public void clear(int n) {
        this.mSet.remove(n);
    }

    @Override
    public void clear() {
        this.mSet.clear();
    }

    @Override
    public String toString() {
        return this.mSet.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.mSet.isEmpty();
    }

    @Override
    public int cardinality() {
        return this.mSet.size();
    }

    @Override
    public boolean subsetOf(IntSet intSet) {
        assert (intSet instanceof IntSetHashSet) : "OPERAND should be HashSet";
        IntSetHashSet intSetHashSet = (IntSetHashSet)intSet;
        return intSetHashSet.mSet.containsAll(this.mSet);
    }

    @Override
    public boolean contentEq(IntSet intSet) {
        assert (intSet instanceof IntSetHashSet) : "OPERAND should be HashSet";
        IntSetHashSet intSetHashSet = (IntSetHashSet)intSet;
        return this.mSet.equals(intSetHashSet.mSet);
    }

    @Override
    public Object get() {
        return this.mSet;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IntSetHashSet intSetHashSet = (IntSetHashSet)object;
        return this.contentEq(intSetHashSet);
    }

    @Override
    public int hashCode() {
        return this.mSet.hashCode();
    }

    @Override
    public Iterable<Integer> iterable() {
        return this.mSet;
    }

    public static class HashSetIterator
    implements IntIterator {
        private final Iterator<Integer> mSetIter;

        public HashSetIterator(IntSetHashSet intSetHashSet) {
            this.mSetIter = intSetHashSet.mSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mSetIter.hasNext();
        }

        @Override
        public int next() {
            return this.mSetIter.next();
        }
    }
}

