/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public interface IDeadEndStore<S, R> {
    public boolean isDeadEndState(R var1);

    public void addDeadEndState(R var1);

    public void copyDeadEndInformation(S var1, S var2);

    public static final class ProductDeadEndStore<S, R>
    implements IDeadEndStore<S, R> {
        private final Function<R, S> mState2Original;
        private final Function<R, ?> mState2ExtraInfo;
        private final HashRelation<S, Object> mDeadEndRelation = new HashRelation();

        public ProductDeadEndStore(Function<R, S> function, Function<R, ?> function2) {
            this.mState2Original = function;
            this.mState2ExtraInfo = function2;
        }

        @Override
        public boolean isDeadEndState(R r) {
            return this.mDeadEndRelation.containsPair(this.mState2Original.apply(r), this.mState2ExtraInfo.apply(r));
        }

        @Override
        public void addDeadEndState(R r) {
            this.mDeadEndRelation.addPair(this.mState2Original.apply(r), this.mState2ExtraInfo.apply(r));
        }

        @Override
        public void copyDeadEndInformation(S s, S s2) {
            this.mDeadEndRelation.addAllPairs(s2, (Collection)this.mDeadEndRelation.getImage(s));
        }
    }

    public static final class SimpleDeadEndStore<S>
    implements IDeadEndStore<S, S> {
        private final Set<S> mDeadEndSet = new HashSet<S>();

        @Override
        public boolean isDeadEndState(S s) {
            return this.mDeadEndSet.contains(s);
        }

        @Override
        public void addDeadEndState(S s) {
            this.mDeadEndSet.add(s);
        }

        @Override
        public void copyDeadEndInformation(S s, S s2) {
            if (this.isDeadEndState(s)) {
                this.addDeadEndState(s2);
            }
        }
    }
}

