/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Ordinal
implements Comparable<Ordinal> {
    public static final Ordinal ZERO = new Ordinal(BigInteger.ZERO);
    public static final Ordinal ONE = new Ordinal(BigInteger.ONE);
    public static final Ordinal OMEGA = new Ordinal(ONE);
    private final List<Component> mcomponents;

    public static Ordinal fromInteger(BigInteger bigInteger) {
        if (!bigInteger.abs().equals(bigInteger)) {
            throw new IllegalArgumentException("There are no negative ordinals.");
        }
        if (bigInteger.equals(BigInteger.ZERO)) {
            return ZERO;
        }
        if (bigInteger.equals(BigInteger.ONE)) {
            return ONE;
        }
        return new Ordinal(bigInteger);
    }

    private Ordinal(BigInteger bigInteger) {
        assert (bigInteger.abs().equals(bigInteger));
        this.mcomponents = bigInteger.equals(BigInteger.ZERO) ? Collections.emptyList() : Collections.singletonList(new Component(bigInteger, ZERO));
    }

    private Ordinal(Ordinal ordinal) {
        this.mcomponents = Collections.singletonList(new Component(BigInteger.ONE, ordinal));
    }

    private Ordinal(List<Component> list) {
        this.mcomponents = Collections.unmodifiableList(list);
    }

    public boolean equals(Object object) {
        if (object instanceof Ordinal) {
            Ordinal ordinal = (Ordinal)object;
            return this.compareTo(ordinal) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Ordinal ordinal) {
        if (ordinal.isZero()) {
            if (this.isZero()) {
                return 0;
            }
            return 1;
        }
        if (this.isZero()) {
            return -1;
        }
        int n = 0;
        while (n < this.mcomponents.size()) {
            Component component = this.mcomponents.get(n);
            if (n >= ordinal.mcomponents.size()) {
                return 1;
            }
            Component component2 = ordinal.mcomponents.get(n);
            int n2 = component.exponent.compareTo(component2.exponent);
            if (n2 != 0) {
                return n2;
            }
            n2 = component.base.compareTo(component2.base);
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        if (this.mcomponents.size() < ordinal.mcomponents.size()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.mcomponents.hashCode();
    }

    public boolean isZero() {
        return this.mcomponents.isEmpty();
    }

    public boolean isFinite() {
        return this.isZero() || this.mcomponents.size() == 1 && this.mcomponents.get((int)0).exponent.isZero();
    }

    public BigInteger toInteger() {
        if (!this.isFinite()) {
            return null;
        }
        if (this.isZero()) {
            return BigInteger.ZERO;
        }
        return this.mcomponents.get((int)(this.mcomponents.size() - 1)).base;
    }

    public boolean isLimit() {
        if (this.mcomponents.isEmpty()) {
            return false;
        }
        Component component = this.mcomponents.get(this.mcomponents.size() - 1);
        return !component.exponent.isZero();
    }

    public Ordinal add(Ordinal ordinal) {
        if (this.isFinite() && ordinal.isFinite()) {
            return new Ordinal(this.toInteger().add(ordinal.toInteger()));
        }
        if (this.compareTo(ordinal) < 0) {
            return ordinal;
        }
        if (ordinal.isZero()) {
            return this;
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Ordinal ordinal2 = ordinal.mcomponents.get((int)0).exponent;
        Component component = null;
        for (Component component2 : this.mcomponents) {
            if (component2.exponent.compareTo(ordinal2) > 0) {
                arrayList.add(component2);
                continue;
            }
            component = component2;
            break;
        }
        if (component != null && component.exponent.compareTo(ordinal2) == 0) {
            arrayList.add(new Component(component.base.add(ordinal.mcomponents.get((int)0).base), ordinal2));
            int n = 1;
            while (n < ordinal.mcomponents.size()) {
                arrayList.add(ordinal.mcomponents.get(n));
                ++n;
            }
        } else {
            arrayList.addAll(ordinal.mcomponents);
        }
        return new Ordinal(arrayList);
    }

    public Ordinal mult(Ordinal ordinal) {
        if (this.isZero()) {
            return ZERO;
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Component component = this.mcomponents.get(0);
        BigInteger bigInteger = null;
        for (Component component2 : ordinal.mcomponents) {
            if (component2.exponent.isZero()) {
                bigInteger = component2.base;
                break;
            }
            arrayList.add(new Component(component2.base, component.exponent.add(component2.exponent)));
        }
        if (bigInteger != null) {
            arrayList.add(new Component(component.base.multiply(bigInteger), component.exponent));
            int n = 1;
            while (n < this.mcomponents.size()) {
                arrayList.add(this.mcomponents.get(n));
                ++n;
            }
        }
        return new Ordinal(arrayList);
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Component component : this.mcomponents) {
            if (!bl) {
                stringBuilder.append(" + ");
            }
            stringBuilder.append(component);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static void testcases() {
        assert (!ONE.isZero());
        assert (ONE.isFinite());
        assert (!ZERO.equals(ONE));
        assert (OMEGA.isLimit());
        assert (!OMEGA.isFinite());
        assert (!OMEGA.isZero());
        assert (OMEGA.add(ZERO).equals(OMEGA));
        assert (!OMEGA.add(ONE).equals(OMEGA));
        assert (ONE.add(OMEGA).equals(OMEGA));
        assert (OMEGA.mult(ONE).equals(OMEGA));
        assert (!OMEGA.mult(OMEGA).equals(OMEGA));
    }

    private static class Component {
        final BigInteger base;
        final Ordinal exponent;

        Component(BigInteger bigInteger, Ordinal ordinal) {
            assert (bigInteger.compareTo(BigInteger.ZERO) > 0);
            this.base = bigInteger;
            this.exponent = ordinal;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.exponent.equals(ONE)) {
                stringBuilder.append("w");
            } else if (!this.exponent.isZero()) {
                String string = this.exponent.toString();
                stringBuilder.append("w^");
                if (string.contains(" ")) {
                    stringBuilder.append("(");
                    stringBuilder.append(string);
                    stringBuilder.append(")");
                } else {
                    stringBuilder.append(string);
                }
            }
            if (this.exponent.isZero()) {
                stringBuilder.append(this.base);
            } else if (!this.base.equals(BigInteger.ONE)) {
                stringBuilder.append(" * ");
                stringBuilder.append(this.base);
            }
            return stringBuilder.toString();
        }
    }
}

