/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomatonCache;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.ConcurrentProduct;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IConcurrentProductStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedIteratorNoopConstruction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Quin;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;

public class NestedWordAutomaton<LETTER, STATE>
extends NestedWordAutomatonCache<LETTER, STATE>
implements INestedWordAutomaton<LETTER, STATE> {
    private static final String LETTER2 = "Letter ";
    private static final String NOT_IN_AUTOMATON = " not in automaton";
    private static final String STATE2 = "State ";
    private static final String UNKNOWN = " unknown";
    private final Map<STATE, Map<LETTER, Set<STATE>>> mInternalIn = new HashMap<STATE, Map<LETTER, Set<STATE>>>();
    private final Map<STATE, Map<LETTER, Set<STATE>>> mCallIn = new HashMap<STATE, Map<LETTER, Set<STATE>>>();
    private final Map<STATE, Map<LETTER, Map<STATE, Set<STATE>>>> mReturnSummary = new HashMap<STATE, Map<LETTER, Map<STATE, Set<STATE>>>>();
    private final Map<STATE, Map<LETTER, Map<STATE, Set<STATE>>>> mReturnIn = new HashMap<STATE, Map<LETTER, Map<STATE, Set<STATE>>>>();

    public NestedWordAutomaton(AutomataLibraryServices automataLibraryServices, VpAlphabet<LETTER> vpAlphabet, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory) {
        super(automataLibraryServices, vpAlphabet, iEmptyStackStateFactory);
    }

    @Override
    public Set<LETTER> lettersInternalIncoming(STATE STATE) {
        if (!this.contains(STATE)) {
            throw new IllegalArgumentException(STATE2 + String.valueOf(STATE) + UNKNOWN);
        }
        Map<LETTER, Set<STATE>> map = this.mInternalIn.get(STATE);
        return map == null ? Collections.emptySet() : map.keySet();
    }

    @Override
    public Set<LETTER> lettersCallIncoming(STATE STATE) {
        if (!this.contains(STATE)) {
            throw new IllegalArgumentException(STATE2 + String.valueOf(STATE) + UNKNOWN);
        }
        Map<LETTER, Set<STATE>> map = this.mCallIn.get(STATE);
        return map == null ? Collections.emptySet() : map.keySet();
    }

    @Override
    public Set<LETTER> lettersReturnIncoming(STATE STATE) {
        if (!this.contains(STATE)) {
            throw new IllegalArgumentException(STATE2 + String.valueOf(STATE) + UNKNOWN);
        }
        Map<LETTER, Map<STATE, Set<STATE>>> map = this.mReturnIn.get(STATE);
        return map == null ? Collections.emptySet() : map.keySet();
    }

    @Override
    public Set<LETTER> lettersSummary(STATE STATE) {
        if (!this.contains(STATE)) {
            throw new IllegalArgumentException(STATE2 + String.valueOf(STATE) + UNKNOWN);
        }
        Map<LETTER, Map<STATE, Set<STATE>>> map = this.mReturnSummary.get(STATE);
        return map == null ? Collections.emptySet() : map.keySet();
    }

    private Set<STATE> predInternal(STATE STATE, LETTER LETTER) {
        assert (this.contains(STATE));
        Map<LETTER, Set<STATE>> map = this.mInternalIn.get(STATE);
        if (map == null) {
            return Collections.emptySet();
        }
        Set<STATE> set = map.get(LETTER);
        return set == null ? Collections.emptySet() : set;
    }

    private Set<STATE> predCall(STATE STATE, LETTER LETTER) {
        assert (this.contains(STATE));
        Map<LETTER, Set<STATE>> map = this.mCallIn.get(STATE);
        if (map == null) {
            return Collections.emptySet();
        }
        Set<STATE> set = map.get(LETTER);
        return set == null ? Collections.emptySet() : set;
    }

    public Set<STATE> hierarchicalPredecessorsOutgoing(STATE STATE) {
        assert (this.contains(STATE));
        NestedMap3 nestedMap3 = this.mReturnOut.get(STATE);
        if (nestedMap3 == null) {
            return Collections.emptySet();
        }
        return nestedMap3.keySet();
    }

    @Override
    public Set<STATE> hierarchicalPredecessorsOutgoing(STATE STATE, LETTER LETTER) {
        assert (this.contains(STATE));
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Quin quin : this.mReturnOut.entries(STATE)) {
            if (!quin.getThird().equals(LETTER)) continue;
            hashSet.add(quin.getSecond());
        }
        return hashSet;
    }

    private Set<STATE> predReturnLin(STATE STATE, LETTER LETTER, STATE STATE2) {
        assert (this.contains(STATE));
        assert (this.contains(STATE2));
        Map<LETTER, Map<STATE, Set<STATE>>> map = this.mReturnIn.get(STATE);
        if (map == null) {
            return Collections.emptySet();
        }
        Map<STATE, Set<STATE>> map2 = map.get(LETTER);
        if (map2 == null) {
            return Collections.emptySet();
        }
        Set<STATE> set = map2.get(STATE2);
        return set == null ? Collections.emptySet() : set;
    }

    private Set<STATE> predReturnHier(STATE STATE, LETTER LETTER) {
        assert (this.contains(STATE));
        Map<LETTER, Map<STATE, Set<STATE>>> map = this.mReturnIn.get(STATE);
        if (map == null) {
            return Collections.emptySet();
        }
        Map<STATE, Set<STATE>> map2 = map.get(LETTER);
        if (map2 == null) {
            return Collections.emptySet();
        }
        return map2.keySet();
    }

    @Override
    public Iterable<SummaryReturnTransition<LETTER, STATE>> summarySuccessors(STATE STATE, LETTER LETTER) {
        HashSet<SummaryReturnTransition<LETTER, STATE>> hashSet = new HashSet<SummaryReturnTransition<LETTER, STATE>>();
        Map<LETTER, Map<STATE, Set<STATE>>> map = this.mReturnSummary.get(STATE);
        if (map == null) {
            return hashSet;
        }
        Map<STATE, Set<STATE>> map2 = map.get(LETTER);
        if (map2 == null) {
            return hashSet;
        }
        for (Map.Entry<STATE, Set<STATE>> entry : map2.entrySet()) {
            STATE STATE2 = entry.getKey();
            Set<STATE> set = entry.getValue();
            if (set == null) continue;
            for (STATE STATE3 : set) {
                SummaryReturnTransition<LETTER, STATE> summaryReturnTransition = new SummaryReturnTransition<LETTER, STATE>(STATE2, LETTER, STATE3);
                hashSet.add(summaryReturnTransition);
            }
        }
        return hashSet;
    }

    @Override
    public Iterable<SummaryReturnTransition<LETTER, STATE>> summarySuccessors(STATE STATE) {
        return () -> new NestedIteratorNoopConstruction(this.lettersSummary(STATE).iterator(), object2 -> this.summarySuccessors(STATE, object2).iterator());
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(final STATE STATE, final LETTER LETTER) {
        return () -> new Iterator<IncomingInternalTransition<LETTER, STATE>>(){
            private final Iterator<STATE> mIterator = this.initialize();

            private Iterator<STATE> initialize() {
                Map map = NestedWordAutomaton.this.mInternalIn.get(STATE);
                if (map != null && map.get(LETTER) != null) {
                    return map.get(LETTER).iterator();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.mIterator != null && this.mIterator.hasNext();
            }

            @Override
            public IncomingInternalTransition<LETTER, STATE> next() {
                if (this.mIterator == null) {
                    throw new NoSuchElementException();
                }
                Object STATE2 = this.mIterator.next();
                return new IncomingInternalTransition(STATE2, LETTER);
            }
        };
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE) {
        return () -> new NestedIteratorNoopConstruction(this.lettersInternalIncoming(STATE).iterator(), object2 -> this.internalPredecessors(STATE, object2).iterator());
    }

    @Override
    public Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors(final STATE STATE, final LETTER LETTER) {
        return () -> new Iterator<IncomingCallTransition<LETTER, STATE>>(){
            private final Iterator<STATE> mIterator = this.initialize();

            private Iterator<STATE> initialize() {
                Map map = NestedWordAutomaton.this.mCallIn.get(STATE);
                if (map != null && map.get(LETTER) != null) {
                    return map.get(LETTER).iterator();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.mIterator != null && this.mIterator.hasNext();
            }

            @Override
            public IncomingCallTransition<LETTER, STATE> next() {
                if (this.mIterator == null) {
                    throw new NoSuchElementException();
                }
                Object STATE2 = this.mIterator.next();
                return new IncomingCallTransition(STATE2, LETTER);
            }
        };
    }

    @Override
    public Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors(STATE STATE) {
        return () -> new NestedIteratorNoopConstruction(this.lettersCallIncoming(STATE).iterator(), object2 -> this.callPredecessors(STATE, object2).iterator());
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(final STATE STATE, final STATE STATE2, final LETTER LETTER) {
        return () -> new Iterator<IncomingReturnTransition<LETTER, STATE>>(){
            private final Iterator<STATE> mIterator = this.initialize();

            private Iterator<STATE> initialize() {
                Map map;
                Map map2 = NestedWordAutomaton.this.mReturnIn.get(STATE);
                if (map2 != null && (map = map2.get(LETTER)) != null && map.get(STATE2) != null) {
                    return map.get(STATE2).iterator();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.mIterator != null && this.mIterator.hasNext();
            }

            @Override
            public IncomingReturnTransition<LETTER, STATE> next() {
                if (this.mIterator == null) {
                    throw new NoSuchElementException();
                }
                Object STATE3 = this.mIterator.next();
                return new IncomingReturnTransition<Object, Object>(STATE3, STATE2, LETTER);
            }
        };
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE, LETTER LETTER) {
        return () -> new NestedIteratorNoopConstruction(this.predReturnHier(STATE, LETTER).iterator(), object3 -> this.returnPredecessors(STATE, object3, LETTER).iterator());
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE) {
        return () -> new NestedIteratorNoopConstruction(this.lettersReturnIncoming(STATE).iterator(), object2 -> this.returnPredecessors(STATE, object2).iterator());
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, LETTER LETTER) {
        return () -> new NestedIteratorNoopConstruction(this.hierarchicalPredecessorsOutgoing((Object)STATE, (Object)LETTER).iterator(), object3 -> this.returnSuccessors(STATE, object3, LETTER).iterator());
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE) {
        return () -> new NestedIteratorNoopConstruction(this.hierarchicalPredecessorsOutgoing(STATE).iterator(), object2 -> this.returnSuccessorsGivenHier(STATE, object2).iterator());
    }

    private boolean checkTransitionsReturnedConsistent() {
        boolean bl = true;
        for (Object STATE : this.getStates()) {
            for (IncomingInternalTransition incomingInternalTransition : this.internalPredecessors(STATE)) {
                assert (bl &= this.containsInternalTransition(incomingInternalTransition.getPred(), incomingInternalTransition.getLetter(), STATE));
            }
            for (OutgoingInternalTransition outgoingInternalTransition : this.internalSuccessors(STATE)) {
                assert (bl &= this.containsInternalTransition(STATE, outgoingInternalTransition.getLetter(), outgoingInternalTransition.getSucc()));
            }
            for (IncomingCallTransition incomingCallTransition : this.callPredecessors(STATE)) {
                assert (bl &= this.containsCallTransition(incomingCallTransition.getPred(), incomingCallTransition.getLetter(), STATE));
            }
            for (OutgoingCallTransition outgoingCallTransition : this.callSuccessors(STATE)) {
                assert (bl &= this.containsCallTransition(STATE, outgoingCallTransition.getLetter(), outgoingCallTransition.getSucc()));
            }
            for (IncomingReturnTransition incomingReturnTransition : this.returnPredecessors(STATE)) {
                assert (bl &= this.containsReturnTransition(incomingReturnTransition.getLinPred(), incomingReturnTransition.getHierPred(), incomingReturnTransition.getLetter(), STATE));
            }
            for (OutgoingReturnTransition outgoingReturnTransition : this.returnSuccessors(STATE)) {
                assert (bl &= this.containsReturnTransition(STATE, outgoingReturnTransition.getHierPred(), outgoingReturnTransition.getLetter(), outgoingReturnTransition.getSucc()));
            }
        }
        return bl;
    }

    @Deprecated
    public void makeStateNonIntial(STATE STATE) {
        this.mSetOfStates.makeStateNonInitial(STATE);
    }

    public void removeState(STATE STATE) {
        Object object4;
        for (OutgoingCallTransition outgoingCallTransition : this.callSuccessors(STATE)) {
            this.removeCallIn(STATE, outgoingCallTransition.getLetter(), outgoingCallTransition.getSucc());
        }
        this.removeAllCallOut(STATE);
        for (LETTER LETTER : this.lettersCallIncoming(STATE)) {
            for (Object object2 : this.predCall(STATE, LETTER)) {
                this.removeCallOut(object2, LETTER, STATE);
            }
        }
        this.mCallIn.remove(STATE);
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.returnSuccessors(STATE)) {
            this.removeReturnIn(STATE, outgoingReturnTransition.getHierPred(), outgoingReturnTransition.getLetter(), outgoingReturnTransition.getSucc());
            this.removeReturnSummary(STATE, outgoingReturnTransition.getHierPred(), outgoingReturnTransition.getLetter(), outgoingReturnTransition.getSucc());
        }
        this.removeAllReturnOut(STATE);
        Map<LETTER, Map<STATE, Set<STATE>>> map = this.mReturnSummary.get(STATE);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                object4 = entry.getKey();
                Object object3 = (Map)entry.getValue();
                if (object3 == null) continue;
                for (Map.Entry entry2 : object3.entrySet()) {
                    Object k = entry2.getKey();
                    Set set = (Set)entry2.getValue();
                    if (set == null) continue;
                    for (Object e : set) {
                        this.removeReturnIn(k, STATE, object4, e);
                        this.removeReturnOut(k, STATE, object4, e);
                    }
                }
            }
        }
        this.mReturnSummary.remove(STATE);
        for (Object e : this.lettersReturnIncoming(STATE)) {
            object4 = this.mReturnIn.get(STATE).get(e);
            for (Object object3 : object4.keySet()) {
                for (Object e2 : this.predReturnLin(STATE, e, object3)) {
                    this.removeReturnOut(e2, object3, e, STATE);
                    this.removeReturnSummary(e2, object3, e, STATE);
                }
            }
        }
        this.mReturnIn.remove(STATE);
        for (Object e : this.lettersInternalIncoming(STATE)) {
            for (Object object4 : this.predInternal(STATE, e)) {
                this.removeInternalOut(object4, e, STATE);
            }
        }
        this.mInternalIn.remove(STATE);
        for (OutgoingInternalTransition outgoingInternalTransition : this.internalSuccessors(STATE)) {
            this.removeInternalIn(STATE, outgoingInternalTransition.getLetter(), outgoingInternalTransition.getSucc());
        }
        this.removeAllInternalOut(STATE);
        this.mSetOfStates.removeState(STATE);
        assert (this.checkTransitionsReturnedConsistent());
        assert (this.sizeInformation().length() > 0);
    }

    private void removeInternalIn(STATE STATE, LETTER LETTER, STATE STATE2) {
        Map<LETTER, Set<STATE>> map = this.mInternalIn.get(STATE2);
        Set<STATE> set = map.get(LETTER);
        assert (set.contains(STATE));
        set.remove(STATE);
        if (set.isEmpty()) {
            map.remove(LETTER);
            if (map.isEmpty()) {
                this.mInternalIn.remove(STATE2);
            }
        }
    }

    private void removeCallIn(STATE STATE, LETTER LETTER, STATE STATE2) {
        Map<LETTER, Set<STATE>> map = this.mCallIn.get(STATE2);
        Set<STATE> set = map.get(LETTER);
        assert (set.contains(STATE));
        set.remove(STATE);
        if (set.isEmpty()) {
            map.remove(LETTER);
            if (map.isEmpty()) {
                this.mCallIn.remove(STATE2);
            }
        }
    }

    private void removeReturnIn(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        Map<LETTER, Map<STATE, Set<STATE>>> map = this.mReturnIn.get(STATE3);
        Map<STATE, Set<STATE>> map2 = map.get(LETTER);
        Set<STATE> set = map2.get(STATE2);
        assert (set.contains(STATE));
        set.remove(STATE);
        if (set.isEmpty()) {
            map2.remove(STATE2);
            if (map2.isEmpty()) {
                map.remove(LETTER);
                if (map.isEmpty()) {
                    this.mReturnIn.remove(STATE3);
                }
            }
        }
    }

    private void removeReturnSummary(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        Map<LETTER, Map<STATE, Set<STATE>>> map = this.mReturnSummary.get(STATE2);
        Map<STATE, Set<STATE>> map2 = map.get(LETTER);
        Set<STATE> set = map2.get(STATE);
        assert (set.contains(STATE3));
        set.remove(STATE3);
        if (set.isEmpty()) {
            map2.remove(STATE);
            if (map2.isEmpty()) {
                map.remove(LETTER);
                if (map.isEmpty()) {
                    this.mReturnSummary.remove(STATE2);
                }
            }
        }
    }

    private int numberIncomingInternalTransitions(STATE STATE) {
        return NestedWordAutomaton.numberOfElementsInIterable(this.internalPredecessors(STATE));
    }

    private int numberIncomingCallTransitions(STATE STATE) {
        return NestedWordAutomaton.numberOfElementsInIterable(this.callPredecessors(STATE));
    }

    private int numberIncomingReturnTransitions(STATE STATE) {
        return NestedWordAutomaton.numberOfElementsInIterable(this.returnPredecessors(STATE));
    }

    private static int numberOfElementsInIterable(Iterable<?> iterable) {
        int n = 0;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String sizeInformation() {
        void var13_20;
        void var18_31;
        Map.Entry<STATE, Map<LETTER, Map<STATE, Set<STATE>>>> entry7;
        int n;
        Object object;
        int n2;
        int n3;
        double d;
        int n4;
        Set set = this.mInternalOut.keySet();
        if (set == null) {
            n4 = 0;
            d = 0.0;
        } else {
            n4 = set.size();
            n3 = set.stream().collect(Collectors.summingInt(this::numberOfOutgoingInternalTransitions));
            d = n4 == 0 ? 0.0 : (double)n3 / (double)n4;
        }
        n3 = this.mInternalOut.size();
        int n5 = 0;
        int n6 = 0;
        for (Map.Entry<STATE, Map<LETTER, Set<STATE>>> entry2 : this.mInternalIn.entrySet()) {
            Map<LETTER, Set<STATE>> map = entry2.getValue();
            n2 = 0;
            ++n5;
            for (Map.Entry<LETTER, Set<STATE>> entry3 : map.entrySet()) {
                object = entry3.getValue();
                n2 += object.size();
            }
            assert (n2 == this.numberIncomingInternalTransitions(entry2.getKey()));
            n6 += n2;
        }
        Set set2 = this.mCallOut.keySet();
        int n7 = set2 == null ? 0 : set2.size();
        int n8 = this.mCallOut.size();
        n2 = 0;
        int n9 = 0;
        for (Map.Entry<STATE, Map<LETTER, Set<STATE>>> entry2 : this.mCallIn.entrySet()) {
            ++n2;
            n = 0;
            Map<LETTER, Set<STATE>> map = entry2.getValue();
            for (Map.Entry<LETTER, Set<STATE>> entry3 : map.entrySet()) {
                Set<STATE> set3 = entry3.getValue();
                n += set3.size();
            }
            assert (n == this.numberIncomingCallTransitions(entry2.getKey()));
            n9 += n;
        }
        object = this.mReturnOut.keySet();
        if (object == null) {
            boolean bl = false;
        } else {
            int n10 = object.size();
        }
        n = this.mReturnOut.size();
        int n11 = 0;
        int n12 = 0;
        for (Map.Entry<STATE, Map<LETTER, Map<STATE, Set<STATE>>>> entry4 : this.mReturnIn.entrySet()) {
            entry7 = entry4.getValue();
            ++n11;
            int n13 = 0;
            for (Map.Entry<LETTER, Map<STATE, Set<STATE>>> entry5 : entry7.entrySet()) {
                Map<STATE, Set<STATE>> map = entry5.getValue();
                for (Map.Entry entry6 : map.entrySet()) {
                    Set set4 = (Set)entry6.getValue();
                    n13 += set4.size();
                }
            }
            assert (n13 == this.numberIncomingReturnTransitions(entry4.getKey()));
            n12 += n13;
        }
        boolean bl = false;
        int n14 = 0;
        for (Map.Entry<STATE, Map<LETTER, Map<STATE, Set<STATE>>>> entry7 : this.mReturnSummary.entrySet()) {
            Map<LETTER, Map<STATE, Set<STATE>>> map = entry7.getValue();
            ++var18_31;
            for (Map.Entry entry8 : map.entrySet()) {
                Map map2 = (Map)entry8.getValue();
                for (Map.Entry entry9 : map2.entrySet()) {
                    Set set5 = (Set)entry9.getValue();
                    n14 += set5.size();
                }
            }
        }
        entry7 = new StringBuilder();
        ((StringBuilder)((Object)entry7)).append(" has ").append(this.getStates().size()).append(" states, " + n4).append(" states have (on average " + d + ") internal successors, (").append(n3).append("), ").append(n5).append(" states have internal predecessors, (").append(n6).append("), ").append(n7).append(" states have call successors, (").append(n8).append("), ").append(n2).append(" states have call predecessors, (").append(n9).append("), ").append((int)var13_20).append(" states have return successors, (").append(n).append("), ").append(n11).append(" states have call predecessors, (").append(n12).append("), " + (int)var18_31).append(" states have call successors, (").append(n14).append(")");
        return ((StringBuilder)((Object)entry7)).toString();
    }

    @Override
    public void addInternalTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        Set<STATE> set;
        super.addInternalTransition(STATE, LETTER, STATE2);
        Map<LETTER, Set<STATE>> map = this.mInternalIn.get(STATE2);
        if (map == null) {
            map = new HashMap<LETTER, Set<STATE>>();
            this.mInternalIn.put(STATE2, map);
        }
        if ((set = map.get(LETTER)) == null) {
            set = new HashSet<STATE>();
            map.put(LETTER, set);
        }
        set.add(STATE);
    }

    @Override
    public void addCallTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        Set<STATE> set;
        super.addCallTransition(STATE, LETTER, STATE2);
        Map<LETTER, Set<STATE>> map = this.mCallIn.get(STATE2);
        if (map == null) {
            map = new HashMap<LETTER, Set<STATE>>();
            this.mCallIn.put(STATE2, map);
        }
        if ((set = map.get(LETTER)) == null) {
            set = new HashSet<STATE>();
            map.put(LETTER, set);
        }
        set.add(STATE);
    }

    @Override
    public void addReturnTransition(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        Set<STATE> set;
        Map<STATE, Set<STATE>> map;
        Set<STATE> set2;
        Map<STATE, Set<STATE>> map2;
        super.addReturnTransition(STATE, STATE2, LETTER, STATE3);
        Map<LETTER, Map<STATE, Set<STATE>>> map3 = this.mReturnIn.get(STATE3);
        if (map3 == null) {
            map3 = new HashMap<LETTER, Map<STATE, Set<STATE>>>();
            this.mReturnIn.put(STATE3, map3);
        }
        if ((map2 = map3.get(LETTER)) == null) {
            map2 = new HashMap<STATE, Set<STATE>>();
            map3.put(LETTER, map2);
        }
        if ((set2 = map2.get(STATE2)) == null) {
            set2 = new HashSet<STATE>();
            map2.put(STATE2, set2);
        }
        set2.add(STATE);
        Map<LETTER, Map<STATE, Set<STATE>>> map4 = this.mReturnSummary.get(STATE2);
        if (map4 == null) {
            map4 = new HashMap<LETTER, Map<STATE, Set<STATE>>>();
            this.mReturnSummary.put(STATE2, map4);
        }
        if ((map = map4.get(LETTER)) == null) {
            map = new HashMap<STATE, Set<STATE>>();
            map4.put(LETTER, map);
        }
        if ((set = map.get(STATE)) == null) {
            set = new HashSet<STATE>();
            map.put(STATE, set);
        }
        set.add(STATE3);
    }

    @Deprecated
    public NestedRun<LETTER, STATE> getAcceptingNestedRun() throws AutomataOperationCanceledException {
        return new IsEmpty(this.mServices, this).getNestedRun();
    }

    public INestedWordAutomaton<LETTER, STATE> concurrentProduct(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        return new ConcurrentProduct<LETTER, STATE>(this.mServices, (IConcurrentProductStateFactory)this.mStateFactory, this, iNestedWordAutomaton, false).getResult();
    }

    public INestedWordAutomaton<LETTER, STATE> concurrentPrefixProduct(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        return new ConcurrentProduct<LETTER, STATE>(this.mServices, (IConcurrentProductStateFactory)this.mStateFactory, this, iNestedWordAutomaton, true).getResult();
    }

    public int numberOfIncomingInternalTransitions(STATE STATE) {
        int n = 0;
        for (LETTER LETTER : this.lettersInternalIncoming(STATE)) {
            n += this.predInternal(STATE, LETTER).size();
        }
        return n;
    }

    @Override
    public String toString() {
        return AutomatonDefinitionPrinter.toString(this.mServices, "nwa", this);
    }

    public void addTransitions(NestedWord<LETTER> nestedWord, List<STATE> list) {
        assert (nestedWord.length() + 1 == list.size());
        int n = 0;
        while (n < nestedWord.length()) {
            Object LETTER = nestedWord.getSymbol(n);
            STATE STATE = list.get(n);
            STATE STATE2 = list.get(n + 1);
            if (nestedWord.isCallPosition(n)) {
                this.addCallTransition(STATE, LETTER, STATE2);
            } else if (nestedWord.isReturnPosition(n)) {
                assert (!nestedWord.isPendingReturn(n));
                int n2 = nestedWord.getCallPosition(n);
                STATE STATE3 = list.get(n2);
                this.addReturnTransition(STATE, STATE3, LETTER, STATE2);
            } else {
                assert (nestedWord.isInternalPosition(n));
                this.addInternalTransition(STATE, LETTER, STATE2);
            }
            ++n;
        }
    }

    @Override
    public void addInternalTransitions(STATE STATE, LETTER LETTER, Collection<STATE> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addCallTransitions(STATE STATE, LETTER LETTER, Collection<STATE> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addReturnTransitions(STATE STATE, STATE STATE2, LETTER LETTER, Collection<STATE> collection) {
        throw new UnsupportedOperationException();
    }
}

