/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomatonFilteredStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveDeadEnds;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveNonLiveStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;

public class IsFinite<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final boolean mResult;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;

    public IsFinite(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton;
        this.mResult = this.computeIsFinite();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Language of automaton is a " + (this.mResult ? "finite" : "infinite") + " set."));
        }
    }

    private boolean computeIsFinite() throws AutomataOperationCanceledException {
        Object object = new RemoveDeadEnds<LETTER, STATE>(this.mServices, this.mOperand).getResult();
        NestedWordAutomatonReachableStates nestedWordAutomatonReachableStates = new NestedWordAutomatonReachableStates(this.mServices, object);
        NestedWordAutomatonFilteredStates nestedWordAutomatonFilteredStates = new NestedWordAutomatonFilteredStates(this.mServices, nestedWordAutomatonReachableStates, nestedWordAutomatonReachableStates.getInitialStates(), nestedWordAutomatonReachableStates.getStates(), nestedWordAutomatonReachableStates.getStates());
        Object object2 = new RemoveNonLiveStates(this.mServices, nestedWordAutomatonFilteredStates).getResult();
        boolean bl = new IsEmpty(this.mServices, object2).getResult();
        return bl;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }
}

