/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.ArrayDomainToolkit;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.EquivalenceFinder;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.Segmentation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.SegmentationMap;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalTermUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.TemporaryBoogieVar;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ArrayDomainState<STATE extends IAbstractState<STATE>>
implements IAbstractState<ArrayDomainState<STATE>> {
    private final STATE mSubState;
    private final SegmentationMap mSegmentationMap;
    private final ArrayDomainToolkit<STATE> mToolkit;
    private final ImmutableSet<IProgramVarOrConst> mVariables;
    private Term mCachedTerm;
    private EquivalenceFinder mEquivalenceFinder;
    private final Map<Segmentation, Segmentation> mSimplifiedSegmentations;

    private ArrayDomainState(STATE STATE, SegmentationMap segmentationMap, ImmutableSet<IProgramVarOrConst> immutableSet, ArrayDomainToolkit<STATE> arrayDomainToolkit) {
        this.mSubState = STATE;
        this.mSegmentationMap = segmentationMap;
        this.mToolkit = arrayDomainToolkit;
        this.mVariables = immutableSet;
        this.mSimplifiedSegmentations = new HashMap<Segmentation, Segmentation>();
        assert (this.checkSegmentationMap());
    }

    private boolean checkSegmentationMap() {
        if (this.isBottom() || this.mSegmentationMap.getAllRepresentatives().isEmpty()) {
            return true;
        }
        for (IProgramVarOrConst iProgramVarOrConst : this.mVariables) {
            Sort sort = iProgramVarOrConst.getSort();
            if (!sort.isArraySort()) continue;
            Sort sort2 = TypeUtils.getValueSort(sort);
            Segmentation segmentation = this.getSegmentation(iProgramVarOrConst);
            assert (segmentation != null) : String.valueOf(iProgramVarOrConst) + " not in segmentation map of state" + String.valueOf(this);
            for (IProgramVar iProgramVar : segmentation.getValues()) {
                Sort sort3 = iProgramVar.getSort();
                assert (sort2.equals(sort3)) : "The value " + String.valueOf(iProgramVar) + " has not the sort corresponding to its array variable " + String.valueOf(iProgramVarOrConst);
                if (sort3.isArraySort()) {
                    assert (this.getSegmentation((IProgramVarOrConst)iProgramVar) != null) : String.valueOf(iProgramVar) + " not in segmentation map of state" + String.valueOf(this);
                    continue;
                }
                assert (this.mSubState.containsVariable((IProgramVarOrConst)iProgramVar)) : String.valueOf(iProgramVar) + " not in substate of state" + String.valueOf(this);
            }
        }
        return true;
    }

    public ArrayDomainState(STATE STATE, ImmutableSet<IProgramVarOrConst> immutableSet, ArrayDomainToolkit<STATE> arrayDomainToolkit) {
        this(STATE, new SegmentationMap(), immutableSet, arrayDomainToolkit);
    }

    public ArrayDomainState<STATE> addVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.addVariables(Collections.singleton(iProgramVarOrConst));
    }

    public ArrayDomainState<STATE> removeVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.removeVariables(Collections.singleton(iProgramVarOrConst));
    }

    public ArrayDomainState<STATE> addVariables(Collection<IProgramVarOrConst> collection) {
        IProgramVarOrConst iProgramVarOrConst2;
        SegmentationMap segmentationMap = this.getSegmentationMap();
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mVariables);
        ArrayList<IProgramVarOrConst> arrayList = new ArrayList<IProgramVarOrConst>();
        for (IProgramVarOrConst iProgramVarOrConst2 : collection) {
            hashSet.add(iProgramVarOrConst2);
            IProgramVarOrConst iProgramVarOrConst3 = iProgramVarOrConst2;
            while (iProgramVarOrConst3.getSort().isArraySort()) {
                Pair<IProgramVar, Segmentation> pair = this.mToolkit.createTopSegmentation(iProgramVarOrConst3.getSort());
                segmentationMap.add(iProgramVarOrConst3, (Segmentation)pair.getSecond());
                iProgramVarOrConst3 = (IProgramVarOrConst)pair.getFirst();
            }
            arrayList.add(iProgramVarOrConst3);
        }
        iProgramVarOrConst2 = this.mSubState.addVariables(arrayList);
        return new ArrayDomainState<IProgramVarOrConst>(iProgramVarOrConst2, segmentationMap, (ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet), this.mToolkit);
    }

    public ArrayDomainState<STATE> addAuxVars(Collection<IProgramVarOrConst> collection) {
        IProgramVarOrConst iProgramVarOrConst;
        SegmentationMap segmentationMap = this.getSegmentationMap();
        ArrayList<IProgramVarOrConst> arrayList = new ArrayList<IProgramVarOrConst>();
        Iterator<IProgramVarOrConst> iterator = collection.iterator();
        while (iterator.hasNext()) {
            IProgramVarOrConst iProgramVarOrConst2 = iProgramVarOrConst = iterator.next();
            while (iProgramVarOrConst2.getSort().isArraySort()) {
                Pair<IProgramVar, Segmentation> pair = this.mToolkit.createTopSegmentation(iProgramVarOrConst2.getSort());
                segmentationMap.add(iProgramVarOrConst2, (Segmentation)pair.getSecond());
                iProgramVarOrConst2 = (IProgramVarOrConst)pair.getFirst();
            }
            arrayList.add(iProgramVarOrConst2);
        }
        iProgramVarOrConst = this.mSubState.addVariables(arrayList);
        return this.updateState(iProgramVarOrConst, segmentationMap);
    }

    public ArrayDomainState<STATE> addAuxVar(IProgramVarOrConst iProgramVarOrConst) {
        return this.addAuxVars(Collections.singleton(iProgramVarOrConst));
    }

    public ArrayDomainState<STATE> removeVariables(Collection<IProgramVarOrConst> collection) {
        IProgramVarOrConst iProgramVarOrConst2;
        SegmentationMap segmentationMap = this.getSegmentationMap();
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mVariables);
        HashSet<IProgramVarOrConst> hashSet2 = new HashSet<IProgramVarOrConst>();
        for (IProgramVarOrConst iProgramVarOrConst2 : collection) {
            boolean bl = hashSet.remove(iProgramVarOrConst2);
            if (!bl) {
                throw new UnsupportedOperationException("Unknown variable " + String.valueOf(iProgramVarOrConst2));
            }
            if (iProgramVarOrConst2.getSort().isArraySort()) {
                segmentationMap.remove(iProgramVarOrConst2);
                continue;
            }
            hashSet2.add(iProgramVarOrConst2);
        }
        iProgramVarOrConst2 = this.mSubState.removeVariables(hashSet2);
        return new ArrayDomainState<IProgramVarOrConst>(iProgramVarOrConst2, segmentationMap, (ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet), this.mToolkit).removeUnusedAuxVars();
    }

    private ArrayDomainState<STATE> removeAuxVars(Collection<IProgramVar> collection) {
        LinkedList<IProgramVar> linkedList = new LinkedList<IProgramVar>(collection);
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        SegmentationMap segmentationMap = this.getSegmentationMap();
        while (!linkedList.isEmpty()) {
            IProgramVar iProgramVar = linkedList.removeFirst();
            if (iProgramVar.getSort().isArraySort()) {
                Segmentation segmentation = this.getSegmentation((IProgramVarOrConst)iProgramVar);
                linkedList.addAll(segmentation.getValues());
                segmentationMap.remove((IProgramVarOrConst)iProgramVar);
                continue;
            }
            arrayList.add(iProgramVar);
        }
        return this.updateState(this.mSubState.removeVariables(arrayList), segmentationMap);
    }

    public ArrayDomainState<STATE> renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> map) {
        SegmentationMap segmentationMap = this.getSegmentationMap();
        HashMap<IProgramVarOrConst, IProgramVarOrConst> hashMap = new HashMap<IProgramVarOrConst, IProgramVarOrConst>();
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mVariables);
        for (Map.Entry<IProgramVarOrConst, IProgramVarOrConst> iAbstractState2 : map.entrySet()) {
            IProgramVarOrConst iProgramVarOrConst = iAbstractState2.getKey();
            IProgramVarOrConst iProgramVarOrConst2 = iAbstractState2.getValue();
            hashSet.remove(iProgramVarOrConst);
            hashSet.add(iProgramVarOrConst2);
            if (iProgramVarOrConst.getSort().isArraySort()) {
                segmentationMap.renameArray(iProgramVarOrConst, iProgramVarOrConst2);
                continue;
            }
            hashMap.put(iProgramVarOrConst, iProgramVarOrConst2);
        }
        IAbstractState iAbstractState = this.mSubState.renameVariables(hashMap);
        return new ArrayDomainState<IAbstractState>(iAbstractState, segmentationMap, (ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet), this.mToolkit);
    }

    public boolean containsVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.mVariables.contains((Object)iProgramVarOrConst);
    }

    public ImmutableSet<IProgramVarOrConst> getVariables() {
        return this.mVariables;
    }

    public ArrayDomainState<STATE> patch(ArrayDomainState<STATE> arrayDomainState) {
        IAbstractState iAbstractState = this.mSubState.patch(arrayDomainState.mSubState);
        Set set = this.mVariables.stream().filter(iProgramVarOrConst -> iProgramVarOrConst.getSort().isArraySort()).collect(Collectors.toSet());
        Set set2 = arrayDomainState.mVariables.stream().filter(iProgramVarOrConst -> iProgramVarOrConst.getSort().isArraySort()).collect(Collectors.toSet());
        Set set3 = DataStructureUtils.intersection(set, set2);
        Set set4 = DataStructureUtils.union(this.mVariables, arrayDomainState.mVariables);
        ArrayDomainState<IAbstractState> arrayDomainState2 = new ArrayDomainState<IAbstractState>(iAbstractState, this.getSegmentationMap(), (ImmutableSet<IProgramVarOrConst>)ImmutableSet.of((Set)set4), this.mToolkit);
        arrayDomainState2.mSegmentationMap.removeAll(set3);
        arrayDomainState2.mSegmentationMap.putAll(arrayDomainState.mSegmentationMap);
        return arrayDomainState2.removeUnusedAuxVars();
    }

    public Pair<Segmentation, ArrayDomainState<STATE>> unionSegmentations(List<Segmentation> list, Sort sort) {
        Pair<Segmentation, ArrayDomainState<STATE>> pair = new Pair<Segmentation, ArrayDomainState<STATE>>((Object)list.get(0), (Object)this);
        int n = 1;
        while (n < list.size()) {
            pair = ((ArrayDomainState)pair.getSecond()).applyOperatorToSegmentations((Segmentation)pair.getFirst(), list.get(n), sort, IAbstractState::union);
            ++n;
        }
        return pair;
    }

    public Pair<Segmentation, ArrayDomainState<STATE>> intersectSegmentations(Segmentation segmentation, Segmentation segmentation2, Sort sort) {
        return this.applyOperatorToSegmentations(segmentation, segmentation2, sort, IAbstractState::intersect);
    }

    private Pair<Segmentation, ArrayDomainState<STATE>> applyOperatorToSegmentations(Segmentation segmentation, Segmentation segmentation2, Sort sort, BinaryOperator<STATE> binaryOperator) {
        Object object;
        UnificationResult unificationResult = this.unify(this, segmentation, segmentation2);
        ArrayDomainState arrayDomainState = unificationResult.getFirstState();
        ArrayDomainState arrayDomainState2 = unificationResult.getSecondState();
        EqSegmentationConversionResult eqSegmentationConversionResult = arrayDomainState.convertEqClassSegmentation(arrayDomainState2, unificationResult.getSegmentation(), sort);
        Map<IProgramVar, Segmentation> map = eqSegmentationConversionResult.getNewSegmentations();
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>(eqSegmentationConversionResult.getNewVariables());
        HashSet<IProgramVarOrConst> hashSet2 = new HashSet<IProgramVarOrConst>(eqSegmentationConversionResult.getRemoveVariablesFirstState());
        HashSet<IProgramVarOrConst> hashSet3 = new HashSet<IProgramVarOrConst>(eqSegmentationConversionResult.getRemoveVariablesSecondState());
        ArrayList<Term> arrayList = new ArrayList<Term>(eqSegmentationConversionResult.getConstraints());
        for (Map.Entry<IProgramVar, EqClassSegmentation> iAbstractState2 : unificationResult.getAuxVarSegmentations().entrySet()) {
            object = iAbstractState2.getKey();
            EqSegmentationConversionResult eqSegmentationConversionResult2 = arrayDomainState.convertEqClassSegmentation(arrayDomainState2, iAbstractState2.getValue(), object.getSort());
            map.put((IProgramVar)object, eqSegmentationConversionResult2.getSegmentation());
            map.putAll(eqSegmentationConversionResult2.getNewSegmentations());
            arrayList.addAll(eqSegmentationConversionResult2.getConstraints());
            hashSet.addAll(eqSegmentationConversionResult2.getNewVariables());
            hashSet.addAll(eqSegmentationConversionResult2.getRemoveVariablesFirstState());
            hashSet.addAll(eqSegmentationConversionResult2.getRemoveVariablesSecondState());
        }
        IAbstractState iAbstractState = (IAbstractState)binaryOperator.apply(arrayDomainState.getSubState().removeVariables(hashSet2), arrayDomainState2.getSubState().removeVariables(hashSet3));
        IAbstractState iAbstractState3 = this.mToolkit.handleAssumptionBySubdomain(iAbstractState.addVariables(hashSet), SmtUtils.and((Script)this.mToolkit.getScript(), arrayList));
        object = arrayDomainState.getSegmentationMap();
        for (Map.Entry<IProgramVar, Segmentation> entry : map.entrySet()) {
            ((SegmentationMap)object).put((IProgramVarOrConst)entry.getKey(), entry.getValue());
        }
        return new Pair((Object)eqSegmentationConversionResult.getSegmentation(), arrayDomainState.updateState(iAbstractState3, (SegmentationMap)object));
    }

    private EqSegmentationConversionResult convertEqClassSegmentation(ArrayDomainState<STATE> arrayDomainState, EqClassSegmentation eqClassSegmentation, Sort sort) {
        Sort sort2 = TypeUtils.getIndexSort(sort);
        Sort sort3 = TypeUtils.getValueSort(sort);
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        arrayList.add(this.mToolkit.getMinBound());
        ArrayList<IProgramVar> arrayList2 = new ArrayList<IProgramVar>();
        ArrayList<IProgramVarOrConst> arrayList3 = new ArrayList<IProgramVarOrConst>();
        ArrayList<Term> arrayList4 = new ArrayList<Term>();
        Script script = this.mToolkit.getScript();
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        HashSet<IProgramVarOrConst> hashSet2 = new HashSet<IProgramVarOrConst>();
        HashMap<IProgramVar, Segmentation> hashMap = new HashMap<IProgramVar, Segmentation>();
        for (Set<Term> collection2 : eqClassSegmentation.getBounds()) {
            TemporaryBoogieVar n = this.mToolkit.createBoundVar(sort2);
            arrayList3.add((IProgramVarOrConst)n);
            arrayList.add(n);
            if (collection2.isEmpty()) continue;
            arrayList4.add(SmtUtils.binaryEquality((Script)script, (Term)n.getTermVariable(), (Term)collection2.iterator().next()));
        }
        List<IProgramVar> list = eqClassSegmentation.getFirstValues();
        List<IProgramVar> list2 = eqClassSegmentation.getSecondValues();
        int n = 0;
        while (n < list.size()) {
            IProgramVar iProgramVar = list.get(n);
            IProgramVar iProgramVar2 = (IProgramVar)list2.get(n);
            if (iProgramVar != null && iProgramVar2 != null) {
                if (!iProgramVar.equals(iProgramVar2)) {
                    throw new InvalidParameterException("Unification should have returned the same value here.");
                }
                arrayList2.add(iProgramVar);
            } else if (iProgramVar != null) {
                var19_21 = this.mToolkit.createValueVar(sort3);
                var20_22 = new LinkedList<TemporaryBoogieVar>();
                var21_23 = new LinkedList<IProgramVar>();
                var20_22.add(var19_21);
                var21_23.add(iProgramVar);
                arrayList2.add(var19_21);
                while (!var20_22.isEmpty()) {
                    var22_24 = (IProgramVar)var20_22.remove();
                    var23_25 = (IProgramVar)var21_23.remove();
                    if (var22_24.getSort().isArraySort()) {
                        var24_26 = new HashMap<IProgramVarOrConst, IProgramVarOrConst>();
                        var25_27 = this.getSegmentation((IProgramVarOrConst)var23_25);
                        for (IProgramVar iProgramVar3 : var25_27.getBounds()) {
                            var28_30 = this.mToolkit.createBoundVar(iProgramVar3.getSort());
                            var21_23.add(iProgramVar3);
                            var20_22.add(var28_30);
                            var24_26.put((IProgramVarOrConst)iProgramVar3, (IProgramVarOrConst)var28_30);
                        }
                        for (IProgramVar iProgramVar3 : var25_27.getValues()) {
                            var28_30 = this.mToolkit.createValueVar(iProgramVar3.getSort());
                            var21_23.add(iProgramVar3);
                            var20_22.add(var28_30);
                            var24_26.put((IProgramVarOrConst)iProgramVar3, (IProgramVarOrConst)var28_30);
                        }
                        hashMap.put(var22_24, this.createFreshSegmentationCopy(var25_27, var24_26));
                        continue;
                    }
                    arrayList4.add(this.project(var22_24, var23_25, this.getSubTerm()));
                    arrayList3.add((IProgramVarOrConst)var22_24);
                    hashSet.add((IProgramVarOrConst)var23_25);
                }
            } else if (iProgramVar2 != null) {
                var19_21 = this.mToolkit.createValueVar(sort3);
                var20_22 = new LinkedList();
                var21_23 = new LinkedList();
                var20_22.add(var19_21);
                var21_23.add(iProgramVar2);
                arrayList2.add(var19_21);
                while (!var20_22.isEmpty()) {
                    var22_24 = (IProgramVar)var20_22.remove();
                    var23_25 = (IProgramVar)var21_23.remove();
                    if (var22_24.getSort().isArraySort()) {
                        var24_26 = new HashMap();
                        var25_27 = arrayDomainState.getSegmentation((IProgramVarOrConst)var23_25);
                        for (IProgramVar iProgramVar3 : var25_27.getBounds()) {
                            var28_30 = this.mToolkit.createBoundVar(iProgramVar3.getSort());
                            var21_23.add(iProgramVar3);
                            var20_22.add(var28_30);
                            var24_26.put((IProgramVarOrConst)iProgramVar3, (IProgramVarOrConst)var28_30);
                        }
                        for (IProgramVar iProgramVar3 : var25_27.getValues()) {
                            var28_30 = this.mToolkit.createValueVar(iProgramVar3.getSort());
                            var21_23.add(iProgramVar3);
                            var20_22.add(var28_30);
                            var24_26.put((IProgramVarOrConst)iProgramVar3, (IProgramVarOrConst)var28_30);
                        }
                        hashMap.put(var22_24, this.createFreshSegmentationCopy(var25_27, var24_26));
                        continue;
                    }
                    arrayList4.add(this.project(var22_24, var23_25, arrayDomainState.getSubTerm()));
                    arrayList3.add((IProgramVarOrConst)var22_24);
                    hashSet2.add((IProgramVarOrConst)var23_25);
                }
            } else {
                var19_21 = this.mToolkit.createValueVar(sort3);
                arrayList3.add((IProgramVarOrConst)var19_21);
                arrayList2.add(var19_21);
            }
            ++n;
        }
        arrayList.add(this.mToolkit.getMaxBound());
        return new EqSegmentationConversionResult(new Segmentation(arrayList, arrayList2), hashMap, arrayList4, arrayList3, hashSet, hashSet2);
    }

    public ArrayDomainState<STATE> intersect(ArrayDomainState<STATE> arrayDomainState) {
        if (this.isBottom()) {
            return this;
        }
        if (arrayDomainState.isBottom()) {
            return arrayDomainState;
        }
        ArrayDomainState<STATE> arrayDomainState2 = arrayDomainState.renameSegmentations(this);
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>(this.mSegmentationMap.getAuxVars());
        HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>(arrayDomainState2.mSegmentationMap.getAuxVars());
        IAbstractState iAbstractState = this.mSubState.addVariables((Collection)DataStructureUtils.difference(hashSet2, hashSet));
        IAbstractState iAbstractState2 = arrayDomainState2.mSubState.addVariables((Collection)DataStructureUtils.difference(hashSet, hashSet2));
        ArrayDomainState arrayDomainState3 = new ArrayDomainState(iAbstractState.intersect(iAbstractState2), this.mVariables, this.mToolkit);
        HashSet<IProgramVarOrConst> hashSet3 = new HashSet<IProgramVarOrConst>();
        for (IProgramVarOrConst iProgramVarOrConst : this.mSegmentationMap.getArrays()) {
            Object object2;
            IProgramVarOrConst iProgramVarOrConst2;
            if (hashSet3.contains(iProgramVarOrConst)) continue;
            HashSet hashSet4 = new HashSet();
            LinkedList<IProgramVarOrConst> linkedList = new LinkedList<IProgramVarOrConst>();
            linkedList.add(iProgramVarOrConst);
            while (!linkedList.isEmpty()) {
                iProgramVarOrConst2 = (IProgramVarOrConst)linkedList.removeFirst();
                if (hashSet3.contains(iProgramVarOrConst2)) continue;
                hashSet3.add(iProgramVarOrConst2);
                object2 = new HashSet<IProgramVarOrConst>(this.getEqualArrays(iProgramVarOrConst2));
                object2.addAll(arrayDomainState2.getEqualArrays(iProgramVarOrConst2));
                linkedList.addAll((Collection<IProgramVarOrConst>)object2);
                hashSet4.addAll(object2);
            }
            iProgramVarOrConst2 = new HashSet();
            for (Object object2 : hashSet4) {
                iProgramVarOrConst2.add(this.getSegmentation((IProgramVarOrConst)object2));
                iProgramVarOrConst2.add(arrayDomainState2.getSegmentation((IProgramVarOrConst)object2));
            }
            object2 = iProgramVarOrConst2.iterator();
            Segmentation segmentation = (Segmentation)object2.next();
            if (!object2.hasNext()) {
                arrayDomainState3.mSegmentationMap.add(iProgramVarOrConst, segmentation);
                continue;
            }
            Sort sort = iProgramVarOrConst.getSort();
            Object object3 = arrayDomainState3.intersectSegmentations(segmentation, (Segmentation)object2.next(), sort);
            Segmentation segmentation2 = (Segmentation)object3.getFirst();
            arrayDomainState3 = (ArrayDomainState)object3.getSecond();
            while (object2.hasNext()) {
                object3 = arrayDomainState3.intersectSegmentations(segmentation2, (Segmentation)object2.next(), sort);
                arrayDomainState3 = (ArrayDomainState)object3.getSecond();
                segmentation2 = (Segmentation)object3.getFirst();
            }
            arrayDomainState3.mSegmentationMap.addEquivalenceClass((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet4), segmentation2);
        }
        return arrayDomainState3.simplify();
    }

    private ArrayDomainState<STATE> renameSegmentations(ArrayDomainState<STATE> arrayDomainState) {
        IProgramVarOrConst iProgramVarOrConst2;
        SegmentationMap segmentationMap = this.getSegmentationMap();
        HashMap<IProgramVarOrConst, IProgramVarOrConst> hashMap = new HashMap<IProgramVarOrConst, IProgramVarOrConst>();
        HashSet<Segmentation> hashSet = new HashSet<Segmentation>();
        for (IProgramVarOrConst iProgramVarOrConst2 : this.mSegmentationMap.getArrays()) {
            Segmentation segmentation = this.getSegmentation(iProgramVarOrConst2);
            if (hashSet.contains(segmentation)) continue;
            hashSet.add(segmentation);
            segmentationMap.put(iProgramVarOrConst2, this.createFreshSegmentationCopy(segmentation, hashMap));
        }
        iProgramVarOrConst2 = this.mSubState.renameVariables(hashMap);
        return this.updateState(iProgramVarOrConst2, segmentationMap);
    }

    private Segmentation createFreshSegmentationCopy(Segmentation segmentation, Map<IProgramVarOrConst, IProgramVarOrConst> map) {
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        ArrayList<IProgramVar> arrayList2 = new ArrayList<IProgramVar>();
        arrayList.add(this.mToolkit.getMinBound());
        arrayList2.add(this.createFreshVar(segmentation.getValue(0), map, true));
        int n = 1;
        while (n < segmentation.size()) {
            arrayList.add(this.createFreshVar(segmentation.getBound(n), map, false));
            arrayList2.add(this.createFreshVar(segmentation.getValue(n), map, true));
            ++n;
        }
        arrayList.add(this.mToolkit.getMaxBound());
        return new Segmentation(arrayList, arrayList2);
    }

    private IProgramVar createFreshVar(IProgramVar iProgramVar, Map<IProgramVarOrConst, IProgramVarOrConst> map, boolean bl) {
        if (!map.containsKey(iProgramVar)) {
            Sort sort = iProgramVar.getSort();
            map.put((IProgramVarOrConst)iProgramVar, (IProgramVarOrConst)(bl ? this.mToolkit.createValueVar(sort) : this.mToolkit.createBoundVar(sort)));
        }
        return (IProgramVar)map.get(iProgramVar);
    }

    private UnificationResult unify(ArrayDomainState<STATE> arrayDomainState, Segmentation segmentation, Segmentation segmentation2) {
        Object object;
        ArrayDomainState arrayDomainState2;
        ArrayDomainState arrayDomainState3;
        Set set;
        Set set2;
        Collection<Object> collection;
        List list;
        assert (segmentation.getValue(0).getSort().equals(segmentation2.getValue(0).getSort())) : "The segmentations have different sorts.";
        Script script = this.mToolkit.getScript();
        Segmentation segmentation3 = this.simplifySegmentation(segmentation);
        Segmentation segmentation4 = arrayDomainState.simplifySegmentation(segmentation2);
        Set<TermVariable> set3 = ArrayDomainState.getTermVars(segmentation3.getBounds());
        Set<TermVariable> set4 = ArrayDomainState.getTermVars(segmentation4.getBounds());
        EquivalenceFinder equivalenceFinder = this.getEquivalenceFinder();
        EquivalenceFinder equivalenceFinder2 = arrayDomainState.getEquivalenceFinder();
        UnionFind<Term> unionFind = equivalenceFinder.getEquivalences(set3);
        UnionFind<Term> unionFind2 = equivalenceFinder2.getEquivalences(set4);
        Set set5 = this.mVariables.stream().map(IProgramVarOrConst::getTerm).collect(Collectors.toSet());
        Predicate<Term> predicate = term -> set5.containsAll(Arrays.asList(term.getFreeVars()));
        Set set6 = ArrayDomainState.unionSets(ArrayDomainState.getEqClasses(set3, unionFind));
        Set set7 = ArrayDomainState.unionSets(ArrayDomainState.getEqClasses(set4, unionFind2));
        Set set8 = set6.stream().filter(predicate).collect(Collectors.toSet());
        Set set9 = set7.stream().filter(predicate).collect(Collectors.toSet());
        Set set10 = DataStructureUtils.union(set6, set9);
        Set set11 = DataStructureUtils.union(set7, set8);
        UnionFind<Term> unionFind3 = equivalenceFinder.getEquivalences(set10);
        UnionFind<Term> unionFind4 = equivalenceFinder2.getEquivalences(set11);
        Triple<ArrayDomainState<STATE>, List<Set<Term>>, List<IProgramVar>> triple = this.transformSegmentation(unionFind3, segmentation3, predicate);
        Triple<ArrayDomainState<STATE>, List<Set<Term>>, List<IProgramVar>> triple2 = arrayDomainState.transformSegmentation(unionFind4, segmentation4, predicate);
        ArrayDomainState arrayDomainState4 = (ArrayDomainState)triple.getFirst();
        ArrayDomainState arrayDomainState5 = (ArrayDomainState)triple2.getFirst();
        List list2 = (List)triple.getSecond();
        List list3 = (List)triple2.getSecond();
        List list4 = (List)triple.getThird();
        List list5 = (List)triple2.getThird();
        Set set12 = ArrayDomainState.unionSets(list2);
        Set set13 = ArrayDomainState.unionSets(list3);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        SegmentationMap segmentationMap = arrayDomainState4.getSegmentationMap();
        SegmentationMap segmentationMap2 = arrayDomainState5.getSegmentationMap();
        ArrayList<Set<Term>> arrayList3 = new ArrayList<Set<Term>>();
        ArrayList<IProgramVar> arrayList4 = new ArrayList<IProgramVar>();
        ArrayList<IProgramVar> arrayList5 = new ArrayList<IProgramVar>();
        ArrayList<IProgramVar> arrayList6 = new ArrayList<IProgramVar>();
        ArrayList<IProgramVar> arrayList7 = new ArrayList<IProgramVar>();
        IProgramVar iProgramVar2 = (IProgramVar)list4.get(0);
        IProgramVar iProgramVar3 = (IProgramVar)list5.get(0);
        Sort sort = iProgramVar2.getSort();
        TemporaryBoogieVar temporaryBoogieVar = this.mToolkit.createValueVar(sort);
        arrayList4.add(temporaryBoogieVar);
        arrayList5.add(temporaryBoogieVar);
        this.addEquivalence(temporaryBoogieVar, iProgramVar2, arrayList, segmentationMap);
        this.addEquivalence(temporaryBoogieVar, iProgramVar3, arrayList2, segmentationMap2);
        int n = 1;
        int n2 = 1;
        while (n < list4.size() && n2 < list5.size()) {
            IProgramVar iProgramVar4 = (IProgramVar)list4.get(n);
            IProgramVar iProgramVar5 = (IProgramVar)list5.get(n2);
            list = (Set)list2.get(n);
            collection = (Set)list3.get(n2);
            set12.removeAll(list);
            set13.removeAll(collection);
            set2 = DataStructureUtils.difference(list, (Set)collection);
            set = DataStructureUtils.difference(collection, list);
            arrayDomainState3 = this.mToolkit.createValueVar(sort);
            if (set.isEmpty()) {
                arrayList3.add((Set<Term>)collection);
                arrayList5.add((IProgramVar)arrayDomainState3);
                arrayDomainState.addEquivalence((IProgramVar)arrayDomainState3, iProgramVar5, arrayList2, segmentationMap2);
                if (!DataStructureUtils.haveNonEmptyIntersection(list, set13)) {
                    arrayList4.add((IProgramVar)arrayDomainState3);
                    this.addEquivalence((IProgramVar)arrayDomainState3, iProgramVar4, arrayList, segmentationMap);
                    ++n;
                } else {
                    arrayList4.add(null);
                }
                ++n2;
                continue;
            }
            if (set2.isEmpty()) {
                arrayList3.add((Set<Term>)((Object)list));
                arrayList4.add((IProgramVar)arrayDomainState3);
                this.addEquivalence((IProgramVar)arrayDomainState3, iProgramVar4, arrayList, segmentationMap);
                if (!DataStructureUtils.haveNonEmptyIntersection(collection, set12)) {
                    arrayList5.add((IProgramVar)arrayDomainState3);
                    arrayDomainState.addEquivalence((IProgramVar)arrayDomainState3, iProgramVar5, arrayList2, segmentationMap2);
                    ++n2;
                } else {
                    arrayList5.add(null);
                }
                ++n;
                continue;
            }
            if (DataStructureUtils.haveNonEmptyIntersection(list, collection)) {
                arrayDomainState2 = DataStructureUtils.intersection(list, set13);
                object = DataStructureUtils.intersection(collection, set12);
                arrayList3.add(DataStructureUtils.intersection(list, collection));
                if (arrayDomainState2.isEmpty() && object.isEmpty()) {
                    arrayList4.add((IProgramVar)arrayDomainState3);
                    arrayList5.add((IProgramVar)arrayDomainState3);
                    this.addEquivalence((IProgramVar)arrayDomainState3, iProgramVar4, arrayList, segmentationMap);
                    arrayDomainState.addEquivalence((IProgramVar)arrayDomainState3, iProgramVar5, arrayList2, segmentationMap2);
                    ++n;
                    ++n2;
                    continue;
                }
                if (arrayDomainState2.isEmpty()) {
                    arrayList4.add((IProgramVar)arrayDomainState3);
                    arrayList5.add(null);
                    this.addEquivalence((IProgramVar)arrayDomainState3, iProgramVar4, arrayList, segmentationMap);
                    list3.set(n2, object);
                    ++n;
                    continue;
                }
                if (object.isEmpty()) {
                    arrayList4.add(null);
                    arrayList5.add((IProgramVar)arrayDomainState3);
                    arrayDomainState.addEquivalence((IProgramVar)arrayDomainState3, iProgramVar5, arrayList2, segmentationMap2);
                    list2.set(n, arrayDomainState2);
                    ++n2;
                    continue;
                }
                arrayList4.add(null);
                arrayList5.add(null);
                list3.set(n2, object);
                list2.set(n, arrayDomainState2);
                continue;
            }
            arrayDomainState2 = (IProgramVar)arrayList4.remove(arrayList4.size() - 1);
            object = (IProgramVar)arrayList5.remove(arrayList5.size() - 1);
            if (arrayDomainState2 != null) {
                arrayList6.add((IProgramVar)arrayDomainState2);
            }
            if (object != null) {
                arrayList7.add((IProgramVar)object);
            }
            if (arrayDomainState3.getSort().isArraySort()) {
                Pair<IProgramVar, Segmentation> pair = this.mToolkit.createTopSegmentation(arrayDomainState3.getSort());
                segmentationMap.add((IProgramVarOrConst)arrayDomainState3, (Segmentation)pair.getSecond());
                segmentationMap2.add((IProgramVarOrConst)arrayDomainState3, (Segmentation)pair.getSecond());
            } else {
                arrayList.add(SmtUtils.or((Script)script, this.connstructEquivalentConstraints((IProgramVarOrConst)arrayDomainState3, Arrays.asList(iProgramVar4, arrayDomainState2))));
                arrayList2.add(SmtUtils.or((Script)script, arrayDomainState.connstructEquivalentConstraints((IProgramVarOrConst)arrayDomainState3, Arrays.asList(iProgramVar5, object))));
            }
            arrayList4.add((IProgramVar)arrayDomainState3);
            arrayList5.add((IProgramVar)arrayDomainState3);
            ++n;
            ++n2;
        }
        int n3 = list4.size();
        int n4 = list5.size();
        while (n < n3) {
            list = this.mToolkit.createValueVar(sort);
            arrayList3.add((Set)list2.get(n));
            arrayList4.add((IProgramVar)list);
            arrayList5.add((IProgramVar)list);
            this.addEquivalence((IProgramVar)list, (IProgramVar)list4.get(n), (List<Term>)arrayList, segmentationMap);
            arrayDomainState.addEquivalence((IProgramVar)list, (IProgramVar)list5.get(n4 - 1), (List<Term>)arrayList2, segmentationMap2);
            ++n;
        }
        while (n2 < n4) {
            list = this.mToolkit.createValueVar(sort);
            arrayList3.add((Set)list3.get(n2));
            arrayList4.add((IProgramVar)list);
            arrayList5.add((IProgramVar)list);
            this.addEquivalence((IProgramVar)list, (IProgramVar)list4.get(n3 - 1), (List<Term>)arrayList, segmentationMap);
            arrayDomainState.addEquivalence((IProgramVar)list, (IProgramVar)list5.get(n2), (List<Term>)arrayList2, segmentationMap2);
            ++n2;
        }
        list = arrayList4.stream().filter(iProgramVar -> iProgramVar != null).collect(Collectors.toList());
        collection = arrayList5.stream().filter(iProgramVar -> iProgramVar != null).collect(Collectors.toList());
        list.addAll(arrayList6);
        collection.addAll(arrayList7);
        arrayList6.addAll(list4);
        arrayList6.removeAll(segmentation3.getValues());
        arrayList7.addAll(list5);
        arrayList7.removeAll(segmentation4.getValues());
        set2 = this.mToolkit.handleAssumptionBySubdomain(arrayDomainState4.mSubState.addVariables(list), SmtUtils.and((Script)script, arrayList));
        set = this.mToolkit.handleAssumptionBySubdomain(arrayDomainState5.mSubState.addVariables(collection), SmtUtils.and((Script)script, arrayList2));
        arrayDomainState3 = arrayDomainState4.updateState(set2, segmentationMap).removeAuxVars(arrayList6);
        arrayDomainState2 = arrayDomainState5.updateState(set, segmentationMap2).removeAuxVars(arrayList7);
        object = new HashMap();
        int n5 = 0;
        while (n5 < arrayList4.size()) {
            IProgramVar iProgramVar6 = (IProgramVar)arrayList4.get(n5);
            IProgramVar iProgramVar7 = (IProgramVar)arrayList5.get(n5);
            if ((iProgramVar6 != null || iProgramVar7 != null) && iProgramVar6 != null && iProgramVar7 != null && iProgramVar6.getSort().isArraySort()) {
                Segmentation segmentation5 = arrayDomainState3.getSegmentation((IProgramVarOrConst)iProgramVar6);
                Segmentation segmentation6 = arrayDomainState2.getSegmentation((IProgramVarOrConst)iProgramVar7);
                UnificationResult unificationResult = arrayDomainState3.unify(arrayDomainState2, segmentation5, segmentation6);
                arrayDomainState3 = unificationResult.getFirstState();
                arrayDomainState2 = unificationResult.getSecondState();
                object.put(iProgramVar6, unificationResult.getSegmentation());
                object.putAll(unificationResult.getAuxVarSegmentations());
            }
            ++n5;
        }
        return new UnificationResult(arrayDomainState3, arrayDomainState2, new EqClassSegmentation(arrayList3, arrayList4, arrayList5), (Map<IProgramVar, EqClassSegmentation>)object);
    }

    private void addEquivalence(IProgramVar iProgramVar, IProgramVar iProgramVar2, List<Term> list, SegmentationMap segmentationMap) {
        if (iProgramVar.getSort().isArraySort()) {
            segmentationMap.move((IProgramVarOrConst)iProgramVar, (IProgramVarOrConst)iProgramVar2);
        } else {
            list.add(this.mToolkit.connstructEquivalentConstraint((IProgramVarOrConst)iProgramVar, iProgramVar2, this.getSubTerm()));
        }
    }

    private static <T> Set<T> unionSets(Collection<Set<T>> collection) {
        return collection.stream().reduce(Collections.emptySet(), DataStructureUtils::union);
    }

    private ArrayDomainState<STATE> applyDisjunctiveOperator(ArrayDomainState<STATE> arrayDomainState, IAbstractStateBinaryOperator<STATE> iAbstractStateBinaryOperator) {
        Object object;
        IAbstractState iAbstractState;
        IProgramVarOrConst iProgramVarOrConst2;
        if (this.isBottom()) {
            return arrayDomainState;
        }
        if (arrayDomainState.isBottom()) {
            return this;
        }
        SegmentationMap segmentationMap = new SegmentationMap();
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        ArrayDomainState<IAbstractState> arrayDomainState2 = this;
        ArrayDomainState<STATE> arrayDomainState3 = arrayDomainState;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        HashSet<IProgramVarOrConst> hashSet2 = new HashSet<IProgramVarOrConst>();
        HashSet<Object> hashSet3 = new HashSet<Object>();
        HashSet<Object> hashSet4 = new HashSet<Object>();
        for (IProgramVarOrConst iProgramVarOrConst2 : this.mVariables) {
            if (!iProgramVarOrConst2.getSort().isArraySort() || hashSet.contains(iProgramVarOrConst2)) continue;
            hashSet.add(iProgramVarOrConst2);
            iAbstractState = new HashSet(this.getEqualArrays(iProgramVarOrConst2));
            iAbstractState.retainAll(arrayDomainState.getEqualArrays(iProgramVarOrConst2));
            hashSet.addAll((Collection<IProgramVarOrConst>)iAbstractState);
            object = arrayDomainState2.unify(arrayDomainState3, this.getSegmentation(iProgramVarOrConst2), arrayDomainState.getSegmentation(iProgramVarOrConst2));
            arrayDomainState2 = ((UnificationResult)object).getFirstState();
            arrayDomainState3 = ((UnificationResult)object).getSecondState();
            EqSegmentationConversionResult eqSegmentationConversionResult = arrayDomainState2.convertEqClassSegmentation(arrayDomainState3, ((UnificationResult)object).getSegmentation(), iProgramVarOrConst2.getSort());
            arrayList.addAll(eqSegmentationConversionResult.getConstraints());
            hashSet2.addAll(eqSegmentationConversionResult.getNewVariables());
            hashSet3.addAll(eqSegmentationConversionResult.getRemoveVariablesFirstState());
            hashSet4.addAll(eqSegmentationConversionResult.getRemoveVariablesSecondState());
            segmentationMap.addEquivalenceClass((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of((Set)iAbstractState), eqSegmentationConversionResult.getSegmentation());
            Map<IProgramVar, Segmentation> map = eqSegmentationConversionResult.getNewSegmentations();
            for (Map.Entry<IProgramVar, Object> entry : ((UnificationResult)object).getAuxVarSegmentations().entrySet()) {
                IProgramVar iProgramVar = entry.getKey();
                EqSegmentationConversionResult eqSegmentationConversionResult2 = arrayDomainState2.convertEqClassSegmentation(arrayDomainState3, entry.getValue(), iProgramVar.getSort());
                map.put(iProgramVar, eqSegmentationConversionResult2.getSegmentation());
                map.putAll(eqSegmentationConversionResult2.getNewSegmentations());
                arrayList.addAll(eqSegmentationConversionResult2.getConstraints());
                hashSet2.addAll(eqSegmentationConversionResult2.getNewVariables());
                hashSet3.addAll(eqSegmentationConversionResult2.getRemoveVariablesFirstState());
                hashSet4.addAll(eqSegmentationConversionResult2.getRemoveVariablesSecondState());
            }
            for (Map.Entry<IProgramVar, Object> entry : map.entrySet()) {
                segmentationMap.add((IProgramVarOrConst)entry.getKey(), (Segmentation)entry.getValue());
            }
        }
        hashSet3.addAll(this.mSegmentationMap.getAuxVars());
        hashSet4.addAll(arrayDomainState3.mSegmentationMap.getAuxVars());
        iProgramVarOrConst2 = arrayDomainState2.getSubState().removeVariables(hashSet3);
        Iterator iterator = arrayDomainState3.getSubState().removeVariables(hashSet4);
        iAbstractState = (IAbstractState)iAbstractStateBinaryOperator.apply((Object)iProgramVarOrConst2, (Object)iterator);
        object = this.mToolkit.handleAssumptionBySubdomain(iAbstractState.addVariables(hashSet2), SmtUtils.and((Script)this.mToolkit.getScript(), arrayList));
        return this.updateState((IAbstractState)object, segmentationMap).simplify();
    }

    private Term project(IProgramVar iProgramVar, IProgramVar iProgramVar2, Term term) {
        TermVariable termVariable = iProgramVar.getTermVariable();
        Term term2 = Substitution.apply((ManagedScript)this.mToolkit.getManagedScript(), Collections.singletonMap(iProgramVar2.getTermVariable(), termVariable), (Term)term);
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(term2.getFreeVars()));
        hashSet.remove(termVariable);
        Term term3 = SmtUtils.quantifier((Script)this.mToolkit.getScript(), (int)0, hashSet, (Term)term2);
        return PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mToolkit.getServices(), (ManagedScript)this.mToolkit.getManagedScript(), (boolean)false, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL_LOCAL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)term3);
    }

    public ArrayDomainState<STATE> union(ArrayDomainState<STATE> arrayDomainState) {
        return this.applyDisjunctiveOperator(arrayDomainState, (iAbstractState, iAbstractState2) -> iAbstractState.union(iAbstractState2));
    }

    public ArrayDomainState<STATE> applyWidening(ArrayDomainState<STATE> arrayDomainState) {
        return this.applyDisjunctiveOperator(arrayDomainState, this.mToolkit.getWideningOperator());
    }

    private Triple<ArrayDomainState<STATE>, List<Set<Term>>, List<IProgramVar>> transformSegmentation(UnionFind<Term> unionFind, Segmentation segmentation, Predicate<Term> predicate) {
        Object object;
        ArrayDomainState<STATE> arrayDomainState = this;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<TermVariable> arrayList2 = new ArrayList<TermVariable>();
        ArrayList<IProgramVar> arrayList3 = new ArrayList<IProgramVar>(segmentation.getValues());
        arrayList.add(Collections.emptySet());
        arrayList2.add(this.mToolkit.getMinBound().getTermVariable());
        HashSet<TemporaryBoogieVar> hashSet = new HashSet<TemporaryBoogieVar>();
        HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>();
        Script script = this.mToolkit.getScript();
        int n = 1;
        while (n < segmentation.size()) {
            TermVariable termVariable = segmentation.getBound(n).getTermVariable();
            Set<Term> set = ArrayDomainState.getEqClass((Term)termVariable, unionFind, predicate);
            if (set.isEmpty()) {
                object = (IProgramVar)arrayList3.remove(arrayList.size());
                IProgramVar iProgramVar = (IProgramVar)arrayList3.remove(arrayList.size() - 1);
                hashSet2.add((IProgramVar)object);
                hashSet2.add(iProgramVar);
                TemporaryBoogieVar temporaryBoogieVar = this.mToolkit.createValueVar(object.getSort());
                arrayList3.add(arrayList.size() - 1, temporaryBoogieVar);
                arrayDomainState = arrayDomainState.addAuxVar((IProgramVarOrConst)temporaryBoogieVar);
                hashSet.add(temporaryBoogieVar);
            } else {
                arrayList2.add(termVariable);
                arrayList.add(set);
            }
            ++n;
        }
        hashSet2.retainAll(hashSet);
        arrayDomainState = arrayDomainState.removeAuxVars(hashSet2);
        arrayList.add(Collections.emptySet());
        arrayList2.add(this.mToolkit.getMaxBound().getTermVariable());
        HashSet hashSet3 = new HashSet(arrayList2);
        for (TermVariable termVariable : unionFind.getAllRepresentatives()) {
            object = ArrayDomainState.getEqClass((Term)termVariable, unionFind, predicate);
            if (object.isEmpty() || DataStructureUtils.haveNonEmptyIntersection((Set)unionFind.getEquivalenceClassMembers((Object)termVariable), hashSet3)) continue;
            if (arrayList2.size() == 2) {
                arrayList2.add(1, termVariable);
                arrayList.add(1, object);
                arrayList3.add(1, (IProgramVar)arrayList3.get(0));
                continue;
            }
            boolean bl = false;
            boolean bl2 = !this.containsProgramVar((Term)termVariable);
            int n2 = 1;
            while (n2 < arrayList2.size() - 2) {
                Term term = (Term)arrayList2.get(n2);
                Term term2 = (Term)arrayList2.get(n2 + 1);
                if (this.mToolkit.evaluate(this.mSubState, SmtUtils.leq((Script)script, (Term)term, (Term)termVariable), bl2) == IAbstractPostOperator.EvalResult.TRUE && this.mToolkit.evaluate(this.mSubState, SmtUtils.less((Script)script, (Term)termVariable, (Term)term2), bl2) == IAbstractPostOperator.EvalResult.TRUE) {
                    arrayList2.add(n2 + 1, termVariable);
                    arrayList.add(n2 + 1, object);
                    arrayList3.add(n2 + 1, (IProgramVar)arrayList3.get(n2));
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl || this.mToolkit.evaluate(this.mSubState, SmtUtils.leq((Script)script, (Term)((Term)arrayList2.get(arrayList2.size() - 2)), (Term)termVariable), bl2) != IAbstractPostOperator.EvalResult.TRUE) continue;
            arrayList2.add(arrayList2.size() - 1, termVariable);
            arrayList.add(arrayList.size() - 1, object);
            arrayList3.add((IProgramVar)arrayList3.get(arrayList3.size() - 1));
        }
        return new Triple(arrayDomainState, arrayList, arrayList3);
    }

    private boolean containsProgramVar(Term term) {
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            IProgramVarOrConst iProgramVarOrConst = this.mToolkit.getBoogieVar((IdentifierExpression)this.mToolkit.getExpression((Term)termVariable));
            if (this.mVariables.contains((Object)iProgramVarOrConst)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Set<Term> getEqClass(Term term, UnionFind<Term> unionFind, Predicate<Term> predicate) {
        unionFind.findAndConstructEquivalenceClassIfNeeded((Object)term);
        return unionFind.getEquivalenceClassMembers((Object)term).stream().filter(predicate).collect(Collectors.toSet());
    }

    private static List<Set<Term>> getEqClasses(Collection<? extends Term> collection, UnionFind<Term> unionFind) {
        return collection.stream().map(term2 -> ArrayDomainState.getEqClass(term2, unionFind, term -> true)).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.mSubState.isEmpty();
    }

    public boolean isBottom() {
        return this.mSubState.isBottom();
    }

    public boolean isEqualTo(ArrayDomainState<STATE> arrayDomainState) {
        return this.isSubsetOf(arrayDomainState) == IAbstractState.SubsetResult.EQUAL;
    }

    public IAbstractState.SubsetResult isSubsetOf(ArrayDomainState<STATE> arrayDomainState) {
        Collection<Object> collection;
        UnificationResult unificationResult;
        IProgramVarOrConst iProgramVarOrConst2;
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        ArrayDomainState<STATE> arrayDomainState2 = this.removeUnusedAuxVars();
        ArrayDomainState<STATE> arrayDomainState3 = arrayDomainState.removeUnusedAuxVars();
        for (IProgramVarOrConst iProgramVarOrConst2 : this.mVariables) {
            Sort sort;
            Object object;
            if (!iProgramVarOrConst2.getSort().isArraySort()) continue;
            unificationResult = arrayDomainState2.unify(arrayDomainState3, this.getSegmentation(iProgramVarOrConst2), arrayDomainState.getSegmentation(iProgramVarOrConst2));
            IProgramVarOrConst iProgramVarOrConst3 = unificationResult.getAuxVarSegmentations();
            if (iProgramVarOrConst3.isEmpty()) {
                object = unificationResult.getFirstValues();
                collection = unificationResult.getSecondValues();
            } else {
                object = new ArrayList<IProgramVar>();
                collection = new ArrayList<IProgramVar>();
                for (Map.Entry<IProgramVar, EqClassSegmentation> entry : iProgramVarOrConst3.entrySet()) {
                    sort = TypeUtils.getValueSort(entry.getKey().getSort());
                    if (sort.isArraySort()) continue;
                    EqClassSegmentation eqClassSegmentation = entry.getValue();
                    object.addAll(eqClassSegmentation.getFirstValues());
                    collection.addAll(eqClassSegmentation.getSecondValues());
                }
            }
            arrayDomainState2 = unificationResult.getFirstState();
            arrayDomainState3 = unificationResult.getSecondState();
            int n = 0;
            while (n < object.size()) {
                IProgramVar iProgramVar = (IProgramVar)object.get(n);
                sort = collection.get(n);
                if (iProgramVar == null && sort != null) {
                    hashSet2.add(sort);
                }
                if (sort == null && iProgramVar != null) {
                    hashSet.add(iProgramVar);
                }
                ++n;
            }
        }
        hashSet.addAll(this.mSegmentationMap.getAuxVars());
        hashSet2.addAll(arrayDomainState.mSegmentationMap.getAuxVars());
        iProgramVarOrConst2 = arrayDomainState2.getSubState().removeVariables(hashSet);
        Iterator iterator = arrayDomainState3.getSubState().removeVariables(hashSet2);
        unificationResult = iProgramVarOrConst2.isSubsetOf((IAbstractState)iterator);
        for (IProgramVarOrConst iProgramVarOrConst3 : arrayDomainState2.mSegmentationMap.getArrays()) {
            if (unificationResult == IAbstractState.SubsetResult.NONE) break;
            if (!this.mVariables.contains((Object)iProgramVarOrConst3)) continue;
            collection = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)arrayDomainState2.mSegmentationMap.getEquivalenceClass(iProgramVarOrConst3));
            HashSet<IProgramVarOrConst> hashSet3 = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)arrayDomainState3.mSegmentationMap.getEquivalenceClass(iProgramVarOrConst3));
            collection.retainAll((Collection<?>)this.mVariables);
            hashSet3.retainAll((Collection<?>)this.mVariables);
            unificationResult = collection.equals(hashSet3) ? unificationResult.min(IAbstractState.SubsetResult.EQUAL) : (hashSet3.containsAll(collection) ? unificationResult.min(IAbstractState.SubsetResult.STRICT) : IAbstractState.SubsetResult.NONE);
        }
        return unificationResult;
    }

    public ArrayDomainState<STATE> compact() {
        Object object2;
        SegmentationMap segmentationMap = this.getSegmentationMap();
        IAbstractState iAbstractState = this.mSubState.compact();
        for (Object object2 : this.mVariables) {
            if (!object2.getSort().isArraySort() || !this.isArrayTop((IProgramVarOrConst)object2)) continue;
            segmentationMap.remove((IProgramVarOrConst)object2);
        }
        object2 = new HashSet(iAbstractState.getVariables());
        object2.addAll(segmentationMap.getArrays());
        object2.retainAll((Collection<?>)this.mVariables);
        return new ArrayDomainState<IAbstractState>(iAbstractState, segmentationMap, (ImmutableSet<IProgramVarOrConst>)ImmutableSet.of((Set)object2), this.mToolkit).removeUnusedAuxVars();
    }

    private boolean isArrayTop(IProgramVarOrConst iProgramVarOrConst) {
        if (this.mSegmentationMap.getEquivalenceClass(iProgramVarOrConst).size() > 1) {
            return false;
        }
        Segmentation segmentation = this.getSegmentation(iProgramVarOrConst);
        if (segmentation.size() > 1) {
            return false;
        }
        IProgramVar iProgramVar = segmentation.getValue(0);
        if (iProgramVar.getSort().isArraySort()) {
            return this.isArrayTop((IProgramVarOrConst)iProgramVar);
        }
        Term term = SmtUtils.filterFormula((Term)this.getSubTerm(), Collections.singleton(iProgramVar.getTermVariable()), (Script)this.mToolkit.getScript());
        return SmtUtils.isTrueLiteral((Term)term);
    }

    public Term getTerm(Script script) {
        HashSet<TermVariable> hashSet;
        Term term2;
        Object object2;
        if (this.isBottom()) {
            return script.term("false", new Term[0]);
        }
        if (this.mSegmentationMap.getAllRepresentatives().isEmpty()) {
            return this.getSubTerm();
        }
        HashSet<IProgramVarOrConst> hashSet2 = new HashSet<IProgramVarOrConst>(this.mSegmentationMap.getArrays());
        hashSet2.addAll((Collection<IProgramVarOrConst>)this.mSubState.getVariables());
        hashSet2.removeAll((Collection<?>)this.mVariables);
        Set set = hashSet2.stream().map(iProgramVarOrConst -> (TermVariable)iProgramVarOrConst.getTerm()).collect(Collectors.toSet());
        UnionFind<Term> unionFind = this.getEquivalenceFinder().getEquivalences(set);
        HashMap<Object, Term> hashMap = new HashMap<Object, Term>();
        block0: for (Object object2 : set) {
            if (unionFind.find(object2) == null) continue;
            for (Term term2 : unionFind.getEquivalenceClassMembers(object2)) {
                hashSet = new HashSet<TermVariable>(Arrays.asList(term2.getFreeVars()));
                if (DataStructureUtils.haveNonEmptyIntersection((Set)hashSet, set)) continue;
                hashMap.put(object2, term2);
                continue block0;
            }
        }
        set.removeAll(hashMap.keySet());
        object2 = new ArrayList();
        object2.add(this.getSubTerm());
        HashSet hashSet3 = new HashSet();
        term2 = this.mToolkit.getManagedScript();
        for (IProgramVarOrConst iProgramVarOrConst2 : this.mSegmentationMap.getArrays()) {
            Sort sort2;
            Segmentation segmentation = this.getSegmentation(iProgramVarOrConst2);
            Term term3 = NonrelationalTermUtils.getTermVar(iProgramVarOrConst2);
            for (Sort sort2 : this.mSegmentationMap.getEquivalenceClass(iProgramVarOrConst2)) {
                if (sort2.equals(iProgramVarOrConst2)) continue;
                object2.add(SmtUtils.binaryEquality((Script)script, (Term)term3, (Term)NonrelationalTermUtils.getTermVar((IProgramVarOrConst)sort2)));
            }
            sort2 = TypeUtils.getIndexSort(iProgramVarOrConst2.getSort());
            int n = 0;
            while (n < segmentation.size()) {
                ArrayList<Term> arrayList = new ArrayList<Term>();
                TermVariable termVariable = term2.constructFreshTermVariable("idx", sort2);
                TermVariable termVariable2 = segmentation.getBound(n).getTermVariable();
                TermVariable termVariable3 = segmentation.getBound(n + 1).getTermVariable();
                if (n > 0) {
                    arrayList.add(SmtUtils.greater((Script)script, (Term)termVariable2, (Term)termVariable));
                }
                if (n < segmentation.size() - 1) {
                    arrayList.add(SmtUtils.geq((Script)script, (Term)termVariable, (Term)termVariable3));
                }
                hashSet3.add(termVariable);
                TermVariable termVariable4 = segmentation.getValue(n).getTermVariable();
                Term term4 = script.term("select", new Term[]{term3, termVariable});
                arrayList.add(SmtUtils.binaryEquality((Script)script, (Term)termVariable4, (Term)term4));
                object2.add(SmtUtils.or((Script)script, arrayList));
                ++n;
            }
        }
        Term term5 = Substitution.apply((ManagedScript)term2, hashMap, (Term)SmtUtils.and((Script)script, (Collection)object2));
        hashSet = SmtUtils.quantifier((Script)script, (int)0, set, (Term)term5);
        return SmtUtils.quantifier((Script)script, (int)1, (Collection)hashSet3, (Term)this.mToolkit.eliminateQuantifier((Term)hashSet));
    }

    private static Set<TermVariable> getTermVars(Collection<IProgramVar> collection) {
        return collection.stream().map(IProgramVar::getTermVariable).collect(Collectors.toSet());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Arrays: ").append(this.mSegmentationMap);
        stringBuilder.append(", Substate: ").append(this.mSubState);
        return stringBuilder.toString();
    }

    public String toLogString() {
        return this.toString();
    }

    public Segmentation getSegmentation(IProgramVarOrConst iProgramVarOrConst) {
        return this.mSegmentationMap.getSegmentation(iProgramVarOrConst);
    }

    public Pair<ArrayDomainState<STATE>, Segmentation> getSegmentation(Expression expression) {
        if (expression instanceof IdentifierExpression) {
            IProgramVarOrConst iProgramVarOrConst = this.mToolkit.getBoogieVar((IdentifierExpression)expression);
            return new Pair((Object)this, (Object)this.getSegmentation(iProgramVarOrConst));
        }
        if (expression instanceof ArrayStoreExpression) {
            Object object;
            Object object2;
            Object object4;
            ArrayStoreExpression arrayStoreExpression = (ArrayStoreExpression)expression;
            Expression[] expressionArray = arrayStoreExpression.getIndices();
            if (expressionArray.length > 1) {
                throw new UnsupportedOperationException("Multidimensional stores are not supported here");
            }
            Expression expression2 = expressionArray[0];
            Term term = this.mToolkit.getTerm(expression2);
            Expression expression3 = arrayStoreExpression.getValue();
            Term term2 = this.mToolkit.getTerm(expression3);
            Sort sort = term.getSort();
            Sort sort2 = term2.getSort();
            Pair<ArrayDomainState<STATE>, Segmentation> pair = this.getSegmentation(arrayStoreExpression.getArray());
            Segmentation segmentation = (Segmentation)pair.getSecond();
            ArrayDomainState arrayDomainState = (ArrayDomainState)pair.getFirst();
            Pair<Integer, Integer> pair2 = arrayDomainState.getContainedBoundIndices(segmentation, term);
            int n = (Integer)pair2.getFirst();
            int n2 = (Integer)pair2.getSecond();
            Script script = this.mToolkit.getScript();
            ArrayList<Term> arrayList = new ArrayList<Term>();
            ArrayList<IProgramVar> arrayList2 = new ArrayList<IProgramVar>();
            ArrayList<IProgramVar> arrayList3 = new ArrayList<IProgramVar>();
            int n3 = 0;
            while (n3 < n) {
                arrayList2.add(segmentation.getBound(n3));
                arrayList3.add(segmentation.getValue(n3));
                ++n3;
            }
            ArrayList<IProgramVar> arrayList4 = new ArrayList<IProgramVar>();
            int n4 = n;
            while (n4 < n2) {
                arrayList4.add(segmentation.getValue(n4));
                ++n4;
            }
            arrayList2.add(segmentation.getBound(n));
            TemporaryBoogieVar temporaryBoogieVar = this.mToolkit.createValueVar(sort2);
            boolean bl = temporaryBoogieVar.getSort().isArraySort();
            if (bl) {
                object4 = new ArrayList<Segmentation>();
                for (IProgramVar object32 : arrayList4) {
                    object2 = arrayDomainState.createEquivalentSegmentation(object32);
                    object4.add((Segmentation)object2.getFirst());
                    arrayDomainState = (ArrayDomainState)object2.getSecond();
                }
                Pair<Segmentation, ArrayDomainState<STATE>> pair3 = arrayDomainState.unionSegmentations((List<Segmentation>)object4, ((IProgramVar)arrayList4.get(0)).getSort());
                arrayDomainState = (ArrayDomainState)pair3.getSecond();
                arrayDomainState.mSegmentationMap.add((IProgramVarOrConst)temporaryBoogieVar, (Segmentation)pair3.getFirst());
            } else {
                arrayList.add(SmtUtils.or((Script)script, arrayDomainState.connstructEquivalentConstraints((IProgramVarOrConst)temporaryBoogieVar, arrayList4)));
            }
            arrayList3.add(temporaryBoogieVar);
            object4 = this.mToolkit.createBoundVar(sort);
            arrayList.add(SmtUtils.binaryEquality((Script)script, (Term)object4.getTermVariable(), (Term)term));
            arrayList2.add((IProgramVar)object4);
            TemporaryBoogieVar temporaryBoogieVar2 = this.mToolkit.createValueVar(sort2);
            if (bl) {
                object = arrayDomainState.getSegmentation(expression3);
                arrayDomainState = (ArrayDomainState)object.getFirst();
                arrayDomainState.mSegmentationMap.add((IProgramVarOrConst)temporaryBoogieVar2, (Segmentation)object.getSecond());
            } else {
                arrayList.add(SmtUtils.binaryEquality((Script)script, (Term)temporaryBoogieVar2.getTermVariable(), (Term)term2));
            }
            arrayList3.add(temporaryBoogieVar2);
            object = this.mToolkit.createBoundVar(sort);
            arrayList.add(SmtUtils.binaryEquality((Script)script, (Term)object.getTermVariable(), (Term)SmtUtils.sum((Script)script, (String)"+", (Term[])new Term[]{term, script.numeral("1")})));
            arrayList2.add((IProgramVar)object);
            object2 = this.mToolkit.createValueVar(sort2);
            if (bl) {
                ArrayList<Segmentation> list = new ArrayList<Segmentation>();
                for (IProgramVar iProgramVar : arrayList4) {
                    Pair<Segmentation, ArrayDomainState<STATE>> pair4 = arrayDomainState.createEquivalentSegmentation(iProgramVar);
                    list.add((Segmentation)pair4.getFirst());
                    arrayDomainState = (ArrayDomainState)pair4.getSecond();
                }
                Pair<Segmentation, ArrayDomainState<STATE>> pair5 = arrayDomainState.unionSegmentations(list, ((IProgramVar)arrayList4.get(0)).getSort());
                arrayDomainState = (ArrayDomainState)pair5.getSecond();
                arrayDomainState.mSegmentationMap.add((IProgramVarOrConst)object2, (Segmentation)pair5.getFirst());
            } else {
                arrayList.add(SmtUtils.or((Script)script, arrayDomainState.connstructEquivalentConstraints((IProgramVarOrConst)object2, (List<IProgramVar>)arrayList4)));
            }
            arrayList3.add((IProgramVar)object2);
            int n5 = n2;
            while (n5 < segmentation.size()) {
                arrayList2.add(segmentation.getBound(n5));
                arrayList3.add(segmentation.getValue(n5));
                ++n5;
            }
            arrayList2.add(this.mToolkit.getMaxBound());
            List<IProgramVarOrConst> list = bl ? Arrays.asList(object4, object) : Arrays.asList(temporaryBoogieVar, object4, temporaryBoogieVar2, object, object2);
            IAbstractState iAbstractState = this.mToolkit.handleAssumptionBySubdomain(arrayDomainState.getSubState().addVariables(list), SmtUtils.and((Script)script, arrayList));
            return new Pair(arrayDomainState.updateState(iAbstractState), (Object)new Segmentation(arrayList2, arrayList3));
        }
        Sort sort = this.mToolkit.getTerm(expression).getSort();
        Pair<IProgramVar, Segmentation> pair = this.mToolkit.createTopSegmentation(sort);
        return new Pair(this.addAuxVar((IProgramVarOrConst)pair.getFirst()), (Object)((Segmentation)pair.getSecond()));
    }

    private Pair<Segmentation, ArrayDomainState<STATE>> createEquivalentSegmentation(IProgramVar iProgramVar) {
        Object object;
        Object object2;
        Object object322;
        Segmentation segmentation = this.mSegmentationMap.getSegmentation((IProgramVarOrConst)iProgramVar);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<IProgramVar> arrayList3 = new ArrayList<IProgramVar>();
        ArrayDomainState arrayDomainState = this;
        HashMap<TemporaryBoogieVar, Segmentation> hashMap = new HashMap<TemporaryBoogieVar, Segmentation>();
        arrayList3.add(this.mToolkit.getMinBound());
        int n = 1;
        while (n < segmentation.size()) {
            object322 = segmentation.getBound(n);
            object2 = this.mToolkit.createBoundVar(object322.getSort());
            arrayList3.add((IProgramVar)object2);
            arrayList2.add(object2);
            arrayList.add(this.mToolkit.connstructEquivalentConstraint((IProgramVarOrConst)object2, (IProgramVar)object322, this.getSubTerm()));
            ++n;
        }
        arrayList3.add(this.mToolkit.getMaxBound());
        ArrayList<IProgramVar> arrayList4 = new ArrayList<IProgramVar>();
        for (Object object322 : segmentation.getValues()) {
            object = object322.getSort();
            TemporaryBoogieVar object4 = this.mToolkit.createValueVar((Sort)object);
            if (object.isArraySort()) {
                Pair<Segmentation, ArrayDomainState<STATE>> pair = arrayDomainState.createEquivalentSegmentation((IProgramVar)object322);
                arrayDomainState = (ArrayDomainState)pair.getSecond();
                hashMap.put(object4, (Segmentation)pair.getFirst());
                continue;
            }
            arrayList4.add(object4);
            arrayList2.add(object4);
            arrayList.add(this.mToolkit.connstructEquivalentConstraint((IProgramVarOrConst)object4, (IProgramVar)object322, this.getSubTerm()));
        }
        object322 = new Segmentation(arrayList3, arrayList4);
        object2 = this.mToolkit.handleAssumptionBySubdomain(arrayDomainState.getSubState().addVariables(arrayList2), SmtUtils.and((Script)this.mToolkit.getScript(), arrayList));
        if (hashMap.isEmpty()) {
            return new Pair(object322, arrayDomainState.updateState(object2));
        }
        object = arrayDomainState.getSegmentationMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            ((SegmentationMap)object).add((IProgramVarOrConst)entry.getKey(), (Segmentation)entry.getValue());
        }
        return new Pair(object322, arrayDomainState.updateState(object2, (SegmentationMap)object));
    }

    private Set<IProgramVarOrConst> getEqualArrays(IProgramVarOrConst iProgramVarOrConst) {
        return this.mSegmentationMap.getEquivalenceClass(iProgramVarOrConst);
    }

    private List<Term> connstructEquivalentConstraints(IProgramVarOrConst iProgramVarOrConst, List<IProgramVar> list) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (IProgramVar iProgramVar : list) {
            if (iProgramVar == null) continue;
            arrayList.add(this.mToolkit.connstructEquivalentConstraint(iProgramVarOrConst, iProgramVar, this.getSubTerm()));
        }
        return arrayList;
    }

    public ArrayDomainState<STATE> updateState(STATE STATE, SegmentationMap segmentationMap) {
        return new ArrayDomainState<STATE>(STATE, segmentationMap, this.mVariables, this.mToolkit);
    }

    public ArrayDomainState<STATE> updateState(STATE STATE) {
        return this.updateState(STATE, this.getSegmentationMap());
    }

    public ArrayDomainState<STATE> updateState(SegmentationMap segmentationMap) {
        return this.updateState(this.mSubState, segmentationMap);
    }

    public STATE getSubState() {
        return this.mSubState;
    }

    public SegmentationMap getSegmentationMap() {
        return new SegmentationMap(this.mSegmentationMap);
    }

    public Pair<Integer, Integer> getContainedBoundIndices(Segmentation segmentation, Expression expression) {
        return this.getContainedBoundIndices(segmentation, this.mToolkit.getTerm(expression));
    }

    public Pair<Integer, Integer> getContainedBoundIndices(Segmentation segmentation, Term term) {
        int n = segmentation.size() - 1;
        Script script = this.mToolkit.getScript();
        boolean bl = !this.containsProgramVar(term);
        int n2 = 1;
        while (n2 < segmentation.size()) {
            TermVariable termVariable = segmentation.getBound(n2).getTermVariable();
            if (this.mToolkit.evaluate(this.mSubState, SmtUtils.leq((Script)script, (Term)termVariable, (Term)term), bl) != IAbstractPostOperator.EvalResult.TRUE) {
                n = n2 - 1;
                break;
            }
            ++n2;
        }
        n2 = n + 1;
        int n3 = segmentation.size() - 1;
        while (n3 > n) {
            TermVariable termVariable = segmentation.getBound(n3).getTermVariable();
            if (this.mToolkit.evaluate(this.mSubState, SmtUtils.less((Script)script, (Term)term, (Term)termVariable), bl) != IAbstractPostOperator.EvalResult.TRUE) {
                n2 = n3 + 1;
                break;
            }
            --n3;
        }
        return new Pair((Object)n, (Object)n2);
    }

    private ArrayDomainState<STATE> removeUnusedAuxVars() {
        Object object;
        Object object2;
        LinkedList<IProgramVarOrConst> linkedList = new LinkedList<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mVariables);
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        while (!linkedList.isEmpty()) {
            object2 = linkedList.removeLast();
            hashSet2.add(object2);
            if (hashSet.contains(object2)) continue;
            if (object2.getSort().isArraySort()) {
                if (!this.mSegmentationMap.getArrays().contains(object2)) {
                    return null;
                }
                hashSet.addAll((Collection<Object>)this.mSegmentationMap.getEquivalenceClass((IProgramVarOrConst)object2));
                object = this.getSegmentation((IProgramVarOrConst)object2);
                linkedList.addAll(((Segmentation)object).getBounds());
                linkedList.addAll(((Segmentation)object).getValues());
                continue;
            }
            hashSet.add(object2);
        }
        object2 = DataStructureUtils.difference((Set)this.mSubState.getVariables(), hashSet2);
        object = DataStructureUtils.difference(this.mSegmentationMap.getArrays(), hashSet2);
        if (object2.isEmpty() && object.isEmpty()) {
            return this;
        }
        SegmentationMap segmentationMap = this.getSegmentationMap();
        segmentationMap.removeAll((Set<IProgramVarOrConst>)object);
        return this.updateState(this.mSubState.removeVariables((Collection)object2), segmentationMap);
    }

    private Segmentation simplifySegmentation(Segmentation segmentation) {
        Segmentation segmentation2 = this.mSimplifiedSegmentations.get(segmentation);
        if (segmentation2 == null) {
            Script script = this.mToolkit.getScript();
            ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
            ArrayList<IProgramVar> arrayList2 = new ArrayList<IProgramVar>();
            arrayList.add(segmentation.getBound(0));
            arrayList2.add(segmentation.getValue(0));
            int n = 1;
            while (n < segmentation.size()) {
                IProgramVar iProgramVar;
                IProgramVar iProgramVar2;
                TermVariable termVariable = segmentation.getBound(n).getTermVariable();
                TermVariable termVariable2 = segmentation.getBound(n + 1).getTermVariable();
                Term term = SmtUtils.binaryEquality((Script)script, (Term)termVariable, (Term)termVariable2);
                if (!(n + 1 < segmentation.size() && this.mToolkit.evaluate(this.mSubState, term, true) == IAbstractPostOperator.EvalResult.TRUE || this.areVariablesEquivalent(iProgramVar2 = segmentation.getValue(n), iProgramVar = (IProgramVar)arrayList2.get(arrayList2.size() - 1)))) {
                    arrayList2.add(segmentation.getValue(n));
                    arrayList.add(segmentation.getBound(n));
                }
                ++n;
            }
            arrayList.add(this.mToolkit.getMaxBound());
            segmentation2 = new Segmentation(arrayList, arrayList2);
            this.mSimplifiedSegmentations.put(segmentation, segmentation2);
        }
        return segmentation2;
    }

    private boolean areVariablesEquivalent(IProgramVar iProgramVar, IProgramVar iProgramVar2) {
        if (iProgramVar.equals(iProgramVar2)) {
            return true;
        }
        if (iProgramVar.getSort().isArraySort()) {
            Segmentation segmentation = this.simplifySegmentation(this.getSegmentation((IProgramVarOrConst)iProgramVar));
            Segmentation segmentation2 = this.simplifySegmentation(this.getSegmentation((IProgramVarOrConst)iProgramVar2));
            if (segmentation.size() != segmentation2.size()) {
                return false;
            }
            List<IProgramVar> list = segmentation.getBounds();
            List<IProgramVar> list2 = segmentation2.getBounds();
            List<IProgramVar> list3 = segmentation.getValues();
            List<IProgramVar> list4 = segmentation2.getValues();
            int n = segmentation.size() - 1;
            int n2 = 1;
            while (n2 <= n) {
                if (!this.areVariablesEquivalent(list3.get(n2 - 1), list4.get(n2 - 1))) {
                    return false;
                }
                if (!this.areVariablesEquivalent(list.get(n2), list2.get(n2))) {
                    return false;
                }
                ++n2;
            }
            return this.areVariablesEquivalent(list3.get(n), list4.get(n));
        }
        TemporaryBoogieVar temporaryBoogieVar = this.mToolkit.createAuxVar(iProgramVar.getSort());
        TemporaryBoogieVar temporaryBoogieVar2 = this.mToolkit.createAuxVar(iProgramVar.getSort());
        HashMap<IProgramVar, TemporaryBoogieVar> hashMap = new HashMap<IProgramVar, TemporaryBoogieVar>();
        hashMap.put(iProgramVar, temporaryBoogieVar);
        hashMap.put(iProgramVar2, temporaryBoogieVar2);
        IAbstractState iAbstractState = this.mSubState.renameVariables(hashMap);
        HashMap<IProgramVar, TemporaryBoogieVar> hashMap2 = new HashMap<IProgramVar, TemporaryBoogieVar>();
        hashMap2.put(iProgramVar, temporaryBoogieVar2);
        hashMap2.put(iProgramVar2, temporaryBoogieVar);
        IAbstractState iAbstractState2 = this.mSubState.renameVariables(hashMap2);
        return iAbstractState.isEqualTo(iAbstractState2);
    }

    public ArrayDomainState<STATE> simplify() {
        SegmentationMap segmentationMap = new SegmentationMap();
        for (IProgramVarOrConst iProgramVarOrConst : this.mSegmentationMap.getAllRepresentatives()) {
            Segmentation segmentation = this.simplifySegmentation(this.getSegmentation(iProgramVarOrConst));
            ImmutableSet<IProgramVarOrConst> immutableSet = this.mSegmentationMap.getEquivalenceClass(iProgramVarOrConst);
            segmentationMap.addEquivalenceClass(immutableSet, segmentation);
        }
        return this.updateState(segmentationMap).removeUnusedAuxVars();
    }

    public Term getSubTerm() {
        if (this.mCachedTerm == null) {
            this.mCachedTerm = this.mSubState.getTerm(this.mToolkit.getScript());
        }
        return this.mCachedTerm;
    }

    private EquivalenceFinder getEquivalenceFinder() {
        if (this.mEquivalenceFinder == null) {
            this.mEquivalenceFinder = new EquivalenceFinder(this.getSubTerm(), this.mToolkit.getServices(), this.mToolkit.getManagedScript());
        }
        return this.mEquivalenceFinder;
    }

    public Set<ArrayDomainState<STATE>> union(Set<ArrayDomainState<STATE>> set, int n) {
        LinkedList<ArrayDomainState<STATE>> linkedList = new LinkedList<ArrayDomainState<STATE>>(set);
        HashSet<ArrayDomainState<STATE>> hashSet = new HashSet<ArrayDomainState<STATE>>(set);
        int n2 = set.size() - n;
        while (n2 > 0) {
            ArrayDomainState<STATE> arrayDomainState = linkedList.removeLast();
            ArrayDomainState<STATE> arrayDomainState2 = linkedList.removeLast();
            hashSet.remove(arrayDomainState);
            hashSet.remove(arrayDomainState2);
            ArrayDomainState<STATE> arrayDomainState3 = arrayDomainState.union(arrayDomainState2);
            if (hashSet.add(arrayDomainState3)) {
                linkedList.add(arrayDomainState3);
                --n2;
                continue;
            }
            n2 -= 2;
        }
        assert (hashSet.size() <= n) : "Did not reduce enough states";
        return hashSet;
    }

    private static class EqClassSegmentation {
        private final List<Set<Term>> mBounds;
        private final List<IProgramVar> mFirstValues;
        private final List<IProgramVar> mSecondValues;

        public EqClassSegmentation(List<Set<Term>> list, List<IProgramVar> list2, List<IProgramVar> list3) {
            this.mBounds = list;
            this.mFirstValues = list2;
            this.mSecondValues = list3;
        }

        public List<Set<Term>> getBounds() {
            return this.mBounds;
        }

        public List<IProgramVar> getFirstValues() {
            return this.mFirstValues;
        }

        public List<IProgramVar> getSecondValues() {
            return this.mSecondValues;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{-inf} ").append(this.mFirstValues.get(0)).append(" / ").append(this.mSecondValues.get(0));
            int n = 0;
            while (n < this.mFirstValues.size() - 1) {
                stringBuilder.append(' ').append(this.mBounds.get(n).toString().replace('[', '{').replace(']', '}'));
                stringBuilder.append(' ').append(this.mFirstValues.get(n + 1)).append(" / ").append(this.mSecondValues.get(n + 1));
                ++n;
            }
            return stringBuilder.append(" {inf}").toString();
        }
    }

    private static class EqSegmentationConversionResult {
        private final Segmentation mSegmentation;
        private final Map<IProgramVar, Segmentation> mNewSegmentations;
        private final Collection<Term> mConstraints;
        private final Collection<IProgramVarOrConst> mNewVariables;
        private final Collection<IProgramVarOrConst> mRemoveVariablesFirstState;
        private final Collection<IProgramVarOrConst> mRemoveVariablesSecondState;

        public EqSegmentationConversionResult(Segmentation segmentation, Map<IProgramVar, Segmentation> map, Collection<Term> collection, Collection<IProgramVarOrConst> collection2, Collection<IProgramVarOrConst> collection3, Collection<IProgramVarOrConst> collection4) {
            this.mSegmentation = segmentation;
            this.mNewSegmentations = map;
            this.mConstraints = collection;
            this.mNewVariables = collection2;
            this.mRemoveVariablesFirstState = collection3;
            this.mRemoveVariablesSecondState = collection4;
        }

        public Segmentation getSegmentation() {
            return this.mSegmentation;
        }

        public Map<IProgramVar, Segmentation> getNewSegmentations() {
            return this.mNewSegmentations;
        }

        public Collection<Term> getConstraints() {
            return this.mConstraints;
        }

        public Collection<IProgramVarOrConst> getNewVariables() {
            return this.mNewVariables;
        }

        public Collection<IProgramVarOrConst> getRemoveVariablesFirstState() {
            return this.mRemoveVariablesFirstState;
        }

        public Collection<IProgramVarOrConst> getRemoveVariablesSecondState() {
            return this.mRemoveVariablesSecondState;
        }
    }

    private class UnificationResult {
        private final ArrayDomainState<STATE> mFirstState;
        private final ArrayDomainState<STATE> mSecondState;
        private final EqClassSegmentation mSegmentation;
        private final Map<IProgramVar, EqClassSegmentation> mAuxVarSegmentations;

        public UnificationResult(ArrayDomainState<STATE> arrayDomainState2, ArrayDomainState<STATE> arrayDomainState3, EqClassSegmentation eqClassSegmentation, Map<IProgramVar, EqClassSegmentation> map) {
            this.mFirstState = arrayDomainState2;
            this.mSecondState = arrayDomainState3;
            this.mSegmentation = eqClassSegmentation;
            this.mAuxVarSegmentations = map;
        }

        public Map<IProgramVar, EqClassSegmentation> getAuxVarSegmentations() {
            return this.mAuxVarSegmentations;
        }

        public ArrayDomainState<STATE> getFirstState() {
            return this.mFirstState;
        }

        public ArrayDomainState<STATE> getSecondState() {
            return this.mSecondState;
        }

        public EqClassSegmentation getSegmentation() {
            return this.mSegmentation;
        }

        public List<IProgramVar> getFirstValues() {
            return this.mSegmentation.getFirstValues();
        }

        public List<IProgramVar> getSecondValues() {
            return this.mSegmentation.getSecondValues();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("States:\n");
            stringBuilder.append(this.mFirstState).append('\n');
            stringBuilder.append(this.mSecondState).append("\n\n");
            stringBuilder.append("Segmentation: ").append(this.mSegmentation).append('\n');
            stringBuilder.append("AuxVarSegmentations: ").append(this.mAuxVarSegmentations).append('\n');
            return stringBuilder.toString();
        }
    }
}

