/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr.IcfgLoop;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IcfgLoopDetection<INLOC extends IcfgLocation> {
    private final Set<IcfgLoop<INLOC>> mLoops;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;

    public IcfgLoopDetection(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, IIcfg<INLOC> iIcfg) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mLoops = this.loopExtraction(iIcfg);
    }

    private Set<IcfgLoop<INLOC>> loopExtraction(IIcfg<INLOC> iIcfg) {
        Object object;
        IcfgLocation icfgLocation;
        Object object2;
        TermClassifier termClassifier;
        HashSet<Object> hashSet;
        IcfgEdge icfgEdge22;
        Object object32;
        Object object42;
        Set set = iIcfg.getInitialNodes();
        if (set.size() > 1) {
            this.mLogger.info((Object)"Unable to accelerate with more than one entries");
            return new HashSet<IcfgLoop<INLOC>>();
        }
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Object object42 : set) {
            object32 = new HashSet();
            object32.add(object42);
            hashMap.put(object42, object32);
            for (IcfgEdge icfgEdge22 : object42.getOutgoingNodes()) {
                if (arrayDeque.contains(icfgEdge22)) continue;
                arrayDeque.add(icfgEdge22);
            }
        }
        while (!arrayDeque.isEmpty()) {
            object42 = (IcfgLocation)arrayDeque.removeFirst();
            hashSet = new HashSet<Object>();
            for (Object object32 : object42.getIncomingNodes()) {
                if (!hashMap.containsKey(object32)) continue;
                if (hashSet.isEmpty()) {
                    hashSet.addAll((Collection)hashMap.get(object32));
                    continue;
                }
                hashSet.retainAll((Collection)hashMap.get(object32));
            }
            if (!hashSet.isEmpty()) {
                hashSet.add(object42);
            }
            if (hashSet.equals(hashMap.get(object42))) continue;
            for (Object object32 : object42.getOutgoingNodes()) {
                if (arrayDeque.contains(object32)) continue;
                arrayDeque.add(object32);
            }
            if (hashMap.containsKey(object42)) {
                ((Set)hashMap.get(object42)).addAll(hashSet);
                continue;
            }
            hashMap.put(object42, hashSet);
        }
        object42 = new HashSet();
        hashSet = new HashSet();
        arrayDeque.addAll(iIcfg.getInitialNodes());
        while (!arrayDeque.isEmpty()) {
            object32 = (IcfgLocation)arrayDeque.removeFirst();
            hashSet.add(object32);
            for (IcfgEdge icfgEdge22 : object32.getOutgoingEdges()) {
                if (((Set)hashMap.get(object32)).contains(icfgEdge22.getTarget())) {
                    object42.add(icfgEdge22);
                }
                if (hashSet.contains(icfgEdge22.getTarget())) continue;
                arrayDeque.add((IcfgLocation)icfgEdge22.getTarget());
            }
        }
        object32 = new HashMap();
        icfgEdge22 = new HashSet();
        Object object5 = object42.iterator();
        while (object5.hasNext()) {
            IcfgEdge icfgEdge3 = (IcfgEdge)object5.next();
            termClassifier = new TermClassifier();
            object2 = (IcfgLocation)icfgEdge3.getTarget();
            icfgLocation = new HashSet();
            icfgLocation.add(object2);
            object = new ArrayDeque<IcfgLocation>();
            object.add((IcfgLocation)icfgEdge3.getSource());
            termClassifier.checkTerm(icfgEdge3.getTransformula().getFormula());
            while (!object.isEmpty()) {
                IcfgLocation icfgLocation2 = (IcfgLocation)object.removeFirst();
                if (icfgLocation.contains(icfgLocation2)) continue;
                icfgLocation.add(icfgLocation2);
                object.addAll(icfgLocation2.getIncomingNodes());
                icfgLocation2.getIncomingEdges().forEach(icfgEdge -> termClassifier.checkTerm(icfgEdge.getTransformula().getFormula()));
            }
            if (termClassifier.hasArrays()) {
                icfgEdge22.add(object2);
                this.mLogger.info((Object)("Unable to accelerate loop at node " + String.valueOf(object2) + " since it contains array access."));
                continue;
            }
            if (object32.containsKey(object2)) {
                ((IcfgLoop)object32.get(object2)).addAll(icfgLocation);
                continue;
            }
            object32.put(object2, new IcfgLoop<Object>(this.mServices, (Set<Object>)icfgLocation, object2));
        }
        icfgEdge22.forEach(((Map)object32)::remove);
        object5 = new ArrayList(object32.keySet());
        object2 = ((ArrayList)object5).iterator();
        while (object2.hasNext()) {
            termClassifier = (IcfgLocation)object2.next();
            object = ((ArrayList)object5).iterator();
            while (object.hasNext()) {
                icfgLocation = (IcfgLocation)object.next();
                if (termClassifier.equals((Object)icfgLocation) || !object32.containsKey(termClassifier) || !object32.containsKey(icfgLocation) || !((IcfgLoop)object32.get(icfgLocation)).contains(termClassifier)) continue;
                ((IcfgLoop)object32.get(icfgLocation)).addNestedLoop((IcfgLoop)object32.get(termClassifier));
                object32.remove(termClassifier);
                this.mLogger.info((Object)"Unable to accelerate, since loop contains nested loops");
                return new HashSet<IcfgLoop<INLOC>>();
            }
        }
        if (object32.isEmpty() && icfgEdge22.isEmpty()) {
            return this.altLoopExtraction(iIcfg);
        }
        return new HashSet<IcfgLoop<INLOC>>(object32.values());
    }

    private Set<IcfgLoop<INLOC>> altLoopExtraction(IIcfg<INLOC> iIcfg) {
        HashSet<IcfgLoop<INLOC>> hashSet = new HashSet<IcfgLoop<INLOC>>();
        Set set = iIcfg.getLoopLocations();
        for (IcfgLocation icfgLocation : set) {
            HashSet hashSet2 = new HashSet();
            ArrayDeque arrayDeque = new ArrayDeque();
            for (Object object : icfgLocation.getOutgoingEdges()) {
                arrayDeque.addLast(new ArrayList<IcfgEdge>(Arrays.asList(object)));
            }
            while (!arrayDeque.isEmpty()) {
                Object object;
                object = (List)arrayDeque.pop();
                if (((IcfgLocation)((IcfgEdge)object.get(object.size() - 1)).getTarget()).equals((Object)icfgLocation)) {
                    object.forEach(icfgEdge -> {
                        boolean bl = hashSet2.add((IcfgLocation)icfgEdge.getSource());
                    });
                    continue;
                }
                for (IcfgEdge icfgEdge2 : ((IcfgLocation)((IcfgEdge)object.get(object.size() - 1)).getTarget()).getOutgoingEdges()) {
                    ArrayList<IcfgEdge> arrayList = new ArrayList<IcfgEdge>((Collection<IcfgEdge>)object);
                    arrayList.add(icfgEdge2);
                    arrayDeque.addLast(arrayList);
                }
            }
            hashSet.add(new IcfgLoop<IcfgLocation>(this.mServices, hashSet2, icfgLocation));
        }
        return hashSet;
    }

    public Set<IcfgLoop<INLOC>> getResult() {
        this.mLoops.forEach(icfgLoop -> this.mLogger.info((Object)("Loop @" + String.valueOf(icfgLoop.getHead()) + ": " + String.valueOf(icfgLoop.getLoopbody()) + "; nested @" + String.valueOf(icfgLoop.getNestedLoopHeads()))));
        return this.mLoops;
    }
}

