/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import org.eclipse.cdt.core.resources.ExclusionType;
import org.eclipse.cdt.core.resources.RefreshExclusion;
import org.eclipse.cdt.core.resources.RefreshScopeManager;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class ExclusionInstance {
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    public static final String CONTRIBUTOR_ID_ATTRIBUTE_NAME = "contributorId";
    public static final String DISPLAY_STRING_ATTRIBUTE_NAME = "displayString";
    public static final String EXCLUSION_ELEMENT_NAME = "exclusion";
    public static final String EXCLUSION_TYPE_ATTRIBUTE_NAME = "exclusionType";
    public static final String EXTENSION_DATA_ELEMENT_NAME = "extensionData";
    public static final String FILE_VALUE = "FILE";
    public static final String FOLDER_VALUE = "FOLDER";
    public static final String INSTANCE_ELEMENT_NAME = "instance";
    public static final String RESOURCE_VALUE = "RESOURCE";
    public static final String WORKSPACE_PATH_ATTRIBUTE_NAME = "workspacePath";
    protected String fDisplayString;
    protected ExclusionType fInstanceExclusionType;
    protected RefreshExclusion fParent;
    protected IResource fResource;

    public static synchronized ExclusionInstance loadInstanceData(ICStorageElement instanceElement, RefreshScopeManager manager) {
        String resourcePath;
        String exclusionTypeString;
        String className = instanceElement.getAttribute(CLASS_ATTRIBUTE_NAME);
        ExclusionInstance newInstance = null;
        newInstance = manager.getInstanceForClassName(className);
        if (newInstance == null) {
            newInstance = new ExclusionInstance();
        }
        if ((exclusionTypeString = instanceElement.getAttribute(EXCLUSION_TYPE_ATTRIBUTE_NAME)) != null) {
            if (exclusionTypeString.equals(FILE_VALUE)) {
                newInstance.fInstanceExclusionType = ExclusionType.FILE;
            } else if (exclusionTypeString.equals(FOLDER_VALUE)) {
                newInstance.fInstanceExclusionType = ExclusionType.FOLDER;
            } else if (exclusionTypeString.equals(RESOURCE_VALUE)) {
                newInstance.fInstanceExclusionType = ExclusionType.RESOURCE;
            } else {
                return null;
            }
        }
        if ((resourcePath = instanceElement.getAttribute(WORKSPACE_PATH_ATTRIBUTE_NAME)) != null) {
            newInstance.fResource = ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath);
        }
        newInstance.fDisplayString = instanceElement.getAttribute(DISPLAY_STRING_ATTRIBUTE_NAME);
        newInstance.loadExtendedInstanceData(instanceElement);
        return newInstance;
    }

    public synchronized String getDisplayString() {
        return this.fDisplayString;
    }

    public synchronized ExclusionType getExclusionType() {
        return this.fInstanceExclusionType;
    }

    public synchronized RefreshExclusion getParentExclusion() {
        return this.fParent;
    }

    public synchronized IResource getResource() {
        return this.fResource;
    }

    protected synchronized void loadExtendedInstanceData(ICStorageElement child) {
    }

    protected synchronized void persistExtendedInstanceData(ICStorageElement instanceElement) {
    }

    public synchronized void persistInstanceData(ICStorageElement exclusionElement) {
        ICStorageElement instanceElement = exclusionElement.createChild(INSTANCE_ELEMENT_NAME);
        instanceElement.setAttribute(CLASS_ATTRIBUTE_NAME, this.getClass().getName());
        String exclusionType = null;
        switch (this.getExclusionType()) {
            case FILE: {
                exclusionType = FILE_VALUE;
                break;
            }
            case FOLDER: {
                exclusionType = FOLDER_VALUE;
                break;
            }
            case RESOURCE: {
                exclusionType = RESOURCE_VALUE;
            }
        }
        if (exclusionType != null) {
            instanceElement.setAttribute(EXCLUSION_TYPE_ATTRIBUTE_NAME, exclusionType);
        }
        if (this.fResource != null) {
            instanceElement.setAttribute(WORKSPACE_PATH_ATTRIBUTE_NAME, this.fResource.getFullPath().toString());
        }
        if (this.fDisplayString != null) {
            instanceElement.setAttribute(DISPLAY_STRING_ATTRIBUTE_NAME, this.fDisplayString);
        }
        this.persistExtendedInstanceData(instanceElement);
    }

    public synchronized void setDisplayString(String displayString) {
        this.fDisplayString = displayString;
    }

    public synchronized void setExclusionType(ExclusionType type) {
        this.fInstanceExclusionType = type;
    }

    public synchronized void setParentExclusion(RefreshExclusion parent) {
        this.fParent = parent;
    }

    public synchronized void setResource(IResource resource) {
        this.fResource = resource;
    }
}

