/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.Formula2NFCompiler;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.XMLWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestForm2MCFormCompiler
extends Formula2NFCompiler {
    protected static final String DEFAULT_LOGGER = "TestForm2MCFormCompiler";
    protected DOMParser parser = null;
    private List<Element> mcFormsList = null;
    private List<Element> trueNodeList = null;
    private List<String> handledIntervalsList = null;
    private int syncEventCounter = 0;

    public TestForm2MCFormCompiler(String string) throws Exception {
        this.logger = string.equals("") ? ILogger.getLogger((String)DEFAULT_LOGGER) : ILogger.getLogger((String)string);
        this.initialiseParser();
        this.trueNodeList = new ArrayList<Element>();
        this.mcFormsList = new ArrayList<Element>();
        this.handledIntervalsList = new ArrayList<String>();
    }

    public TestForm2MCFormCompiler() throws Exception {
        this("");
    }

    protected void initialiseParser() throws Exception {
        this.parser = new DOMParser();
        this.logger.debug((Object)"Trying to set parser feature \"http://xml.org/sax/features/validation\"");
        this.parser.setFeature("http://xml.org/sax/features/validation", true);
        this.logger.debug((Object)"Setting parser feature \"http://xml.org/sax/features/validation\" successful");
        this.logger.debug((Object)"Trying to set parser feature \"http://apache.org/xml/features/validation/schema\"");
        this.parser.setFeature("http://apache.org/xml/features/validation/schema", true);
        this.logger.debug((Object)"Setting parser feature \"http://apache.org/xml/features/validation/schema\" successful");
    }

    protected Document parse(String string) throws SAXException, IOException {
        this.logger.debug((Object)("Trying to parse file=\"" + string + "\""));
        this.parser.parse(string);
        this.logger.debug((Object)("Parsing file=\"" + string + "\" successful"));
        return this.parser.getDocument();
    }

    public Document compile(String string) throws Exception {
        return this.compile(string, "");
    }

    public Document compile(String string, String object) throws Exception {
        this.document = this.parse(string);
        this.mcFormsList.clear();
        this.trueNodeList.clear();
        this.handledIntervalsList.clear();
        File file = new File(string);
        String string2 = file.getName();
        String string3 = file.getName().substring(0, string2.length() - 4);
        String string4 = file.getParent() != null ? file.getParent() + "/" : "";
        String string5 = string4 + string3 + "_bin.xml";
        String string6 = string4 + string3 + "_sync.xml";
        String string7 = string4 + string3 + "_nf.xml";
        if (((String)object).equals("")) {
            object = string4 + string3 + "_mc.xml";
        }
        this.logger.info((Object)"Starting compilation");
        NodeList nodeList = this.document.getElementsByTagName("testForm");
        if (nodeList.getLength() != 1) {
            throw new RuntimeException("Testform count != 1 is not allowed");
        }
        Element element = (Element)nodeList.item(0);
        this.logger.info((Object)"Trying to make testForm tree binary");
        this.makeBinary(element);
        this.logger.info((Object)"Making testForm tree binary successful");
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.writeXMLDocumentToFile(this.document, string5);
        this.logger.info((Object)"Trying to replace chops with sync events");
        this.introduceSyncEvents();
        this.logger.info((Object)"Replacing chops with sync events successful");
        xMLWriter.writeXMLDocumentToFile(this.document, string6);
        this.logger.info((Object)"Trying to build normal form");
        this.buildNF(element);
        this.logger.info((Object)"Building normal form successful");
        xMLWriter.writeXMLDocumentToFile(this.document, string7);
        this.logger.info((Object)"Trying to build model-checkable form");
        this.findMCForms(element);
        this.appendMCForms();
        this.logger.info((Object)"Building model-checkable form successful");
        xMLWriter.writeXMLDocumentToFile(this.document, (String)object);
        this.logger.info((Object)"Compilation finished");
        return this.document;
    }

    private void appendMCForms() {
        Element element;
        if (!this.mcFormsList.isEmpty()) {
            element = this.document.createElement("mcForms");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xsi:noNamespaceSchemaLocation", "../schemas/ModelCheckForm.xsd");
            for (Element element2 : this.mcFormsList) {
                element.appendChild(element2);
            }
        } else {
            throw new RuntimeException("The list of mcForms is empty");
        }
        this.document.replaceChild(element, this.document.getFirstChild());
    }

    protected void introduceSyncEvents() {
        NodeList nodeList = this.document.getElementsByTagName("tfTree");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            if (element.getAttribute("operator").equals("CHOP")) {
                element.setAttribute("operator", this.getFreshSyncEvent());
            }
            ++n2;
        }
    }

    private Element getNewTrueNode() {
        Element element = this.document.createElement("trace");
        element.setAttribute("spec", "true");
        Element element2 = this.document.createElement("phase");
        Element element3 = this.document.createElement("stateInvariant");
        Element element4 = this.document.createElement("booleanExpression");
        element4.setAttribute("expression", "true");
        element3.appendChild(element4);
        element2.appendChild(element3);
        element.appendChild(element2);
        this.trueNodeList.add(element);
        return element;
    }

    @Override
    protected void changeNodeSyncChildAnd(Element element, Element[] elementArray, int n) {
        Element[] elementArray2 = this.getFormulaOperands(elementArray[n]);
        String string = element.getAttribute("operator");
        Element element2 = this.document.createElement("tfTree");
        element2.setAttribute("operator", string);
        Element element3 = this.document.createElement("tfTree");
        element3.setAttribute("operator", string);
        Element element4 = this.document.createElement("tfTree");
        element4.setAttribute("operator", string);
        elementArray[n].appendChild(element2);
        elementArray[n].appendChild(element3);
        if (n == 0) {
            element2.appendChild(elementArray2[0]);
            element2.appendChild(this.getNewTrueNode());
            element3.appendChild(elementArray2[1]);
            element3.appendChild(this.getNewTrueNode());
            element4.appendChild(this.getNewTrueNode());
            element4.appendChild(elementArray[1]);
            element.appendChild(element4);
        } else {
            element2.appendChild(this.getNewTrueNode());
            element2.appendChild(elementArray2[0]);
            element3.appendChild(this.getNewTrueNode());
            element3.appendChild(elementArray2[1]);
            element4.appendChild(elementArray[0]);
            element4.appendChild(this.getNewTrueNode());
            element.insertBefore(element4, elementArray[1]);
        }
        element.setAttribute("operator", "AND");
    }

    @Override
    protected void changeNodeNotChildAnd(Element element, Element element2) {
        throw new RuntimeException("Operator NOT may not be used in testformulae");
    }

    @Override
    protected void changeNodeNotChildOr(Element element, Element element2) {
        throw new RuntimeException("Operator NOT may not be used in testformulae");
    }

    protected void findMCForms(Node node) {
        if (node.getNodeType() != 1) {
            this.logger.debug((Object)"No element node, returning...");
            return;
        }
        Element element = (Element)node;
        if (element.getNodeName().equals("testForm")) {
            this.logger.debug((Object)"TestForm node, finding mcForm in children...");
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                this.findMCForms(nodeList.item(n));
                ++n;
            }
            this.logger.debug((Object)"TestForm node, finding mcForm in children finished, returning...");
            return;
        }
        if (element.getAttribute("operator").equals("OR")) {
            this.logger.debug((Object)"OR-node, finding mcForm in children...");
            Element[] elementArray = this.getFormulaOperands(element);
            int n = 0;
            while (n < elementArray.length) {
                this.findMCForms(elementArray[n]);
                ++n;
            }
            this.logger.debug((Object)"OR-node, finding mcForm in children finished, returning...");
        } else {
            this.logger.debug((Object)"Building mcForm...");
            this.createMCForm(element);
            this.logger.debug((Object)"Building mcForm finished, returning...");
        }
    }

    protected void createMCForm(Element element) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = this.getFreshSyncEvent();
        if (element.getNodeName().equals("trace")) {
            this.logger.debug((Object)"Building mcForm from single trace node...");
            object = this.createMCTrace(element, string);
            if (object != null) {
                arrayList.add(object);
            }
            this.logger.debug((Object)"Building mcForm from single trace node finished...");
        } else {
            Element element2;
            Element element3;
            this.logger.debug((Object)"Building mcForm from several trace nodes...");
            object = new ArrayList();
            NodeList nodeList = element.getElementsByTagName("trace");
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                element3 = (Element)nodeList.item(n2);
                if (this.isTrueNode(element3)) {
                    ((ArrayList)object).add(element3);
                } else {
                    element2 = this.createMCTrace(element3, string);
                    if (element2 != null) {
                        arrayList.add(element2);
                    }
                }
                ++n2;
            }
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                element3 = (Element)iterator.next();
                element2 = this.createMCTrace(element3, string);
                if (element2 == null) continue;
                arrayList.add(element2);
            }
            this.logger.debug((Object)"Building mcForm from several trace nodes finished...");
        }
        if (!arrayList.isEmpty()) {
            object = this.document.createElement("mcForm");
            for (Element element4 : arrayList) {
                object.appendChild(element4);
            }
            this.mcFormsList.add((Element)object);
        }
    }

    protected Element createMCTrace(Element element, String string) {
        Element element2 = (Element)element.getParentNode();
        Element element3 = null;
        if (!element2.getNodeName().equals("testForm")) {
            element3 = (Element)element2.getParentNode();
        }
        boolean bl = this.isFirstChild(element);
        boolean bl2 = element3 != null ? this.isFirstChild(element2) : true;
        String string2 = null;
        String string3 = null;
        if (element2.getAttribute("operator").startsWith("S")) {
            string2 = element2.getAttribute("operator");
        }
        if (element3 != null && element3.getAttribute("operator").startsWith("S")) {
            string3 = element3.getAttribute("operator");
        }
        if (string2 == null) {
            this.logger.debug((Object)"SyncEvent1==null");
            if (this.isTrueNode(element)) {
                return null;
            }
            return this.getMCTraceNode((Element)element.cloneNode(true), null, string);
        }
        if (bl) {
            if (string3 == null || bl2) {
                this.logger.debug((Object)"traceIsFirstChild && (syncEvent2==NULL || parentNode1IsFirstChild");
                if (this.isTrueNode(element)) {
                    return null;
                }
                return this.getMCTraceNode((Element)element.cloneNode(true), null, string2);
            }
            this.logger.debug((Object)"traceIsFirstChild && (syncEvent2!=NULL && !parentNode1IsFirstChild");
            if (this.isAlreadyHandled(string3, string2) && this.isTrueNode(element)) {
                return null;
            }
            return this.getMCTraceNode((Element)element.cloneNode(true), string3, string2);
        }
        if (string3 == null || !bl2) {
            this.logger.debug((Object)"!traceIsFirstChild && (syncEvent2==NULL || parentNode1IsFirstChild");
            if (this.isTrueNode(element)) {
                return null;
            }
            return this.getMCTraceNode((Element)element.cloneNode(true), string2, string);
        }
        this.logger.debug((Object)"!traceIsFirstChild && (syncEvent2!=NULL && parentNode1IsFirstChild");
        if (this.isAlreadyHandled(string2, string3) && this.isTrueNode(element)) {
            return null;
        }
        return this.getMCTraceNode((Element)element.cloneNode(true), string2, string3);
    }

    private String getFreshSyncEvent() {
        String string = "S" + this.syncEventCounter;
        ++this.syncEventCounter;
        return string;
    }

    protected Element getMCTraceNode(Element element, String string, String string2) {
        Element element2 = this.document.createElement("mcTrace");
        if (string != null) {
            if (string.equals("")) {
                throw new RuntimeException("Existing entry sync events are not allowed to be empty");
            }
            element2.setAttribute("entrySync", string);
        }
        if (string2.equals("")) {
            throw new RuntimeException("Exit sync events are not allowed to be empty");
        }
        element2.setAttribute("exitSync", string2);
        element2.appendChild(element);
        this.handledIntervalsList.add(string + string2);
        return element2;
    }

    private boolean isTrueNode(Element element) {
        return this.trueNodeList.contains(element);
    }

    private boolean isAlreadyHandled(String string, String string2) {
        return this.handledIntervalsList.contains(string + string2);
    }

    private boolean isFirstChild(Node node) {
        Element element = (Element)node.getParentNode();
        Element[] elementArray = this.getFormulaOperands(element);
        return node == elementArray[0];
    }

    @Override
    protected Element getNewTreeElement() {
        return this.document.createElement("tfTree");
    }

    @Override
    protected boolean isTreeElement(Node node) {
        return node.getNodeName().equals("tfTree");
    }

    @Override
    protected boolean isBasicElement(Node node) {
        return node.getNodeName().equals("trace");
    }

    @Override
    protected boolean isFormulaElement(Node node) {
        return node.getNodeName().equals("testForm");
    }

    @Override
    protected boolean isCorrectOperator(String string) {
        return string.equals("OR") || string.equals("AND") || string.equals("CHOP") || string.startsWith("S");
    }
}

