/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import java.util.Collections;
import java.util.List;

public class InitializerResult
extends Result {
    private final ExpressionResult mRootExpressionResult;
    private final Designator mRootDesignator;
    private final List<InitializerResult> mChildren;

    public InitializerResult(BoogieASTNode boogieASTNode, Designator designator, ExpressionResult expressionResult, List<InitializerResult> list) {
        super(boogieASTNode);
        this.mRootDesignator = designator;
        this.mRootExpressionResult = expressionResult;
        this.mChildren = list == null ? null : Collections.unmodifiableList(list);
    }

    public Designator getRootDesignator() {
        return this.mRootDesignator;
    }

    public ExpressionResult getRootExpressionResult() {
        return this.mRootExpressionResult;
    }

    public boolean isInitializerList() {
        return this.mChildren != null;
    }

    public List<InitializerResult> getList() {
        return this.mChildren;
    }

    public boolean hasRootDesignator() {
        return this.mRootDesignator != null;
    }

    public boolean hasRootExpressionResult() {
        return this.mRootExpressionResult != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasRootDesignator()) {
            stringBuilder.append(this.getRootDesignator());
            stringBuilder.append(" : ");
        }
        if (this.hasRootExpressionResult()) {
            stringBuilder.append(this.getRootExpressionResult().getLrValue().toString());
        }
        if (this.isInitializerList()) {
            String string = "";
            stringBuilder.append("{ ");
            for (InitializerResult initializerResult : this.getList()) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(initializerResult.toString());
            }
            stringBuilder.append(" }");
        }
        return stringBuilder.toString();
    }

    public static ExpressionResult getFirstValueInInitializer(InitializerResult initializerResult) {
        if (initializerResult.hasRootExpressionResult()) {
            return initializerResult.getRootExpressionResult();
        }
        if (!initializerResult.getList().isEmpty()) {
            return InitializerResult.getFirstValueInInitializer(initializerResult.getList().get(0));
        }
        throw new AssertionError((Object)"found no value in initializer");
    }

    public static final class ArrayDesignator
    extends Designator {
        final Integer mArrayCellId;

        public ArrayDesignator(Integer n) {
            this.mArrayCellId = n;
        }

        public Integer getArrayCellId() {
            return this.mArrayCellId;
        }

        public String toString() {
            return "[" + String.valueOf(this.mArrayCellId) + "]";
        }
    }

    public static abstract sealed class Designator
    permits ArrayDesignator, StructDesignator {
    }

    public static final class StructDesignator
    extends Designator {
        final String mStructFieldId;

        public StructDesignator(String string) {
            this.mStructFieldId = string;
        }

        public String getStructFieldId() {
            return this.mStructFieldId;
        }

        public String toString() {
            return "." + this.mStructFieldId;
        }
    }
}

