/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ScopedHashMap<K, V>
implements Map<K, V> {
    private Deque<Map<K, V>> mScopes;

    public ScopedHashMap() {
        this.clear();
        assert (!this.mScopes.isEmpty());
    }

    public ScopedHashMap(ScopedHashMap<K, V> scopedHashMap) {
        this.mScopes = new ArrayDeque<Map<K, V>>();
        for (Map<K, V> map : scopedHashMap.mScopes) {
            this.mScopes.addLast(new HashMap<K, V>(map));
        }
        assert (!this.mScopes.isEmpty());
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        for (Map<K, V> map : this.mScopes) {
            if (map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        for (Map<K, V> map : this.mScopes) {
            if (!map.containsKey(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        for (Map<K, V> map : this.mScopes) {
            if (!map.containsValue(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        for (Map<K, V> map : this.mScopes) {
            V v = map.get(object);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        return this.mScopes.peekFirst().put(k, v);
    }

    @Override
    public V remove(Object object) {
        return this.mScopes.peekFirst().remove(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.mScopes.peekFirst().putAll(map);
    }

    @Override
    public void clear() {
        this.mScopes = new ArrayDeque<Map<K, V>>();
        this.mScopes.addFirst(new HashMap());
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public void beginScope() {
        this.mScopes.addFirst(new HashMap());
    }

    public void endScope() {
        this.mScopes.removeFirst();
        assert (!this.mScopes.isEmpty()) : "You ended a scope you did not begin";
    }

    public int getScopesCount() {
        return this.mScopes.size() - 1;
    }

    public String toString() {
        return this.mScopes.toString();
    }
}

