/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.Clause;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.ClauseStatus;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.IClauseCondition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.VariableStatus;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMaxSatSolver<V> {
    protected final AutomataLibraryServices mServices;
    protected final ILogger mLogger;
    protected final Set<V> mVariables = new HashSet<V>();
    protected final Map<V, Boolean> mVariablesIrrevocablySet = new HashMap<V, Boolean>();
    protected final Set<V> mUnsetVariables = new HashSet<V>();
    protected Map<V, Boolean> mPropagatees = new LinkedHashMap<V, Boolean>();
    protected boolean mConjunctionEquivalentToFalse;
    protected Set<Clause<V>> mClausesMarkedForRemoval = new LinkedHashSet<Clause<V>>();
    protected final HashRelation<V, Clause<V>> mOccursPositive = new HashRelation();
    protected final HashRelation<V, Clause<V>> mOccursNegative = new HashRelation();
    protected int mDecisions;
    protected int mWrongDecisions;
    protected int mClauses;
    protected int mTrivialClauses;
    protected int mCurrentLiveClauses;
    protected int mMaxLiveClauses;

    public AbstractMaxSatSolver(AutomataLibraryServices automataLibraryServices) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        Clause.trues = 0;
        Clause.falses = 0;
        Clause.neithers = 0;
    }

    public int getNumberOfVariables() {
        return this.mVariables.size();
    }

    public int getNumberOfClauses() {
        return this.mClauses;
    }

    public void addVariable(V v) {
        boolean bl = this.mVariables.add(v);
        if (!bl) {
            throw new IllegalArgumentException("variable already added " + String.valueOf(v));
        }
        this.mUnsetVariables.add(v);
    }

    @Deprecated
    public abstract void addHornClause(V[] var1, V var2);

    public abstract void addClause(V[] var1, V[] var2);

    public boolean solve() throws AutomataOperationCanceledException {
        this.mLogger.info((Object)"starting solver");
        this.propagateAll();
        this.makeAssignmentPersistent();
        this.mLogger.debug((Object)("trues before first decision: " + Clause.trues));
        this.mLogger.debug((Object)("falses before first decision: " + Clause.falses));
        this.mLogger.debug((Object)("neithers before first decision: " + Clause.neithers));
        this.firstDecisionOrStop();
        while (!this.mUnsetVariables.isEmpty()) {
            this.decideOne();
            if (this.mConjunctionEquivalentToFalse) {
                return false;
            }
            if (this.mServices.getProgressAwareTimer().continueProcessing()) continue;
            throw new AutomataOperationCanceledException(this.getRunningTaskInfo());
        }
        this.makeAssignmentPersistent();
        this.mLogger.info((Object)"finished solver");
        this.log();
        this.mLogger.debug((Object)("trues total: " + Clause.trues));
        this.mLogger.debug((Object)("falses total: " + Clause.falses));
        this.mLogger.debug((Object)("neithers total: " + Clause.neithers));
        return true;
    }

    protected void firstDecisionOrStop() {
    }

    protected abstract void log();

    public Map<V, Boolean> getValues() {
        return Collections.unmodifiableMap(this.mVariablesIrrevocablySet);
    }

    public VariableStatus getValue(V v) {
        Boolean bl = this.getPersistentAssignment(v);
        if (bl == null) {
            return VariableStatus.UNSET;
        }
        if (bl.booleanValue()) {
            return VariableStatus.TRUE;
        }
        return VariableStatus.FALSE;
    }

    protected abstract Boolean getPersistentAssignment(V var1);

    protected abstract VariableStatus getTemporaryAssignment(V var1);

    protected VariableStatus getCurrentVariableStatus(V v) {
        assert (this.mVariables.contains(v)) : "missing variable: " + String.valueOf(v);
        Boolean bl = this.getPersistentAssignment(v);
        if (bl != null) {
            if (bl.booleanValue()) {
                return VariableStatus.TRUE;
            }
            return VariableStatus.FALSE;
        }
        return this.getTemporaryAssignment(v);
    }

    protected abstract void backtrack(V var1);

    protected abstract void makeAssignmentPersistent();

    protected void propagateAll() {
        while (!this.mPropagatees.isEmpty() && !this.mConjunctionEquivalentToFalse) {
            this.propagateOne();
        }
    }

    private void propagateOne() {
        Map.Entry<V, Boolean> entry = this.getPropagatee();
        this.setVariable(entry.getKey(), entry.getValue());
    }

    private Map.Entry<V, Boolean> getPropagatee() {
        Iterator<Map.Entry<V, Boolean>> iterator = this.mPropagatees.entrySet().iterator();
        Map.Entry<V, Boolean> entry = iterator.next();
        return entry;
    }

    protected abstract void setVariable(V var1, boolean var2);

    protected void reEvaluateStatusOfAllClauses(Set<V> set, V v) {
        boolean bl = set.remove(v);
        assert (bl);
        for (V v2 : set) {
            this.undoAssignment(v2);
            this.reEvaluateStatusOfAllClauses(v2);
        }
    }

    protected void reEvaluateStatusOfAllClauses(V v) {
        for (Clause clause : this.mOccursPositive.getImage(v)) {
            this.reEvaluateClauseStatus(clause);
            if (!this.mConjunctionEquivalentToFalse) continue;
            return;
        }
        for (Clause clause : this.mOccursNegative.getImage(v)) {
            this.reEvaluateClauseStatus(clause);
            if (!this.mConjunctionEquivalentToFalse) continue;
            return;
        }
    }

    private void reEvaluateClauseStatus(Clause<V> clause) {
        boolean bl = clause.isHorn();
        clause.updateClauseCondition(this);
        if (clause.isEquivalentToFalse()) {
            this.mConjunctionEquivalentToFalse = true;
        } else if (clause.isEquivalentToTrue()) {
            this.mClausesMarkedForRemoval.add(clause);
        } else if (clause.isPseudoUnit()) {
            Pair<V, Boolean> pair = clause.getPropagatee();
            Boolean bl2 = this.mPropagatees.put((Boolean)pair.getFirst(), (Boolean)pair.getSecond());
            if (bl2 != null && !bl2.equals(pair.getSecond())) {
                this.mConjunctionEquivalentToFalse = true;
            }
        } else if (bl != clause.isHorn()) {
            if (bl && !clause.isHorn()) {
                this.incrementNumberOfNonHornClauses();
            } else {
                this.decrementNumberOfNonHornClauses();
            }
        }
    }

    protected void incrementNumberOfNonHornClauses() {
    }

    protected void decrementNumberOfNonHornClauses() {
    }

    protected void undoAssignment(V v) {
    }

    protected abstract void decideOne();

    protected V getUnsetVariable() {
        Iterator<V> iterator = this.mUnsetVariables.iterator();
        V v = iterator.next();
        iterator.remove();
        return v;
    }

    protected void removeMarkedClauses() {
        for (Clause<V> clause : this.mClausesMarkedForRemoval) {
            this.removeClause(clause);
        }
        this.mCurrentLiveClauses -= this.mClausesMarkedForRemoval.size();
        this.mClausesMarkedForRemoval = new LinkedHashSet<Clause<V>>();
    }

    private void removeClause(Clause<V> clause) {
        Object v;
        V[] VArray = clause.mPositiveAtoms;
        int n = clause.mPositiveAtoms.length;
        int n2 = 0;
        while (n2 < n) {
            v = VArray[n2];
            this.mOccursPositive.removePair(v, clause);
            ++n2;
        }
        VArray = clause.mNegativeAtoms;
        n = clause.mNegativeAtoms.length;
        n2 = 0;
        while (n2 < n) {
            v = VArray[n2];
            this.mOccursNegative.removePair(v, clause);
            ++n2;
        }
    }

    protected boolean checkClausesConsistent() {
        IClauseCondition iClauseCondition;
        Clause clause;
        boolean bl = true;
        HashSet<Clause> hashSet = new HashSet<Clause>();
        for (Map.Entry object : this.mOccursPositive.getSetOfPairs()) {
            clause = (Clause)object.getValue();
            hashSet.add(clause);
            iClauseCondition = clause.computeClauseCondition(this);
            if (!iClauseCondition.getClauseStatus().equals((Object)clause.getClauseStatus())) continue;
            bl = false;
            assert (bl);
        }
        for (Map.Entry entry : this.mOccursNegative.getSetOfPairs()) {
            clause = (Clause)entry.getValue();
            hashSet.add(clause);
            iClauseCondition = clause.computeClauseCondition(this);
            if (!iClauseCondition.getClauseStatus().equals((Object)clause.getClauseStatus())) continue;
            bl = false;
            assert (bl);
        }
        for (Clause clause2 : hashSet) {
            if (clause2.isPseudoUnit() && !this.mPropagatees.get(clause2.getUnsetAtom(this)).booleanValue()) {
                bl = false;
                assert (bl);
            }
            if (clause2.getClauseStatus() != ClauseStatus.TRUE || this.mClausesMarkedForRemoval.contains(clause2)) continue;
            bl = false;
            assert (bl);
        }
        for (Clause clause3 : this.mClausesMarkedForRemoval) {
            if (clause3.getClauseStatus() != ClauseStatus.TRUE) {
                bl = false;
                assert (bl);
            }
            if (hashSet.contains(clause3)) continue;
            bl = false;
            assert (bl);
        }
        if (hashSet.size() != this.mCurrentLiveClauses) {
            bl = false;
            assert (bl);
        }
        return bl;
    }

    private RunningTaskInfo getRunningTaskInfo() {
        return new RunningTaskInfo(this.getClass(), "Solving system of " + this.mClauses + " clauses.");
    }
}

