/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations;

import de.uni_freiburg.informatik.ultimate.core.lib.translation.DefaultTranslator;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.ProgramExecutionFormatter;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BlockEncodingBacktranslator
extends DefaultTranslator<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>, Term, Term, IcfgLocation, IcfgLocation, ILocation> {
    private static final boolean PRINT_MAPPINGS = false;
    private final Map<IIcfgTransition<IcfgLocation>, List<IIcfgTransition<IcfgLocation>>> mSequentialCompositions = new HashMap<IIcfgTransition<IcfgLocation>, List<IIcfgTransition<IcfgLocation>>>();
    private final Map<IIcfgTransition<IcfgLocation>, Set<IIcfgTransition<IcfgLocation>>> mParallelCompositions = new HashMap<IIcfgTransition<IcfgLocation>, Set<IIcfgTransition<IcfgLocation>>>();
    private final Map<IIcfgTransition<IcfgLocation>, TermVariable> mBranchEncoderMapping = new HashMap<IIcfgTransition<IcfgLocation>, TermVariable>();
    private final Map<IIcfgTransition<IcfgLocation>, Consumer<AtomicTraceElement.AtomicTraceElementBuilder<IIcfgTransition<IcfgLocation>>>> mAteTransformer = new HashMap<IIcfgTransition<IcfgLocation>, Consumer<AtomicTraceElement.AtomicTraceElementBuilder<IIcfgTransition<IcfgLocation>>>>();
    private final Map<IcfgLocation, IcfgLocation> mLocationMapping = new HashMap<IcfgLocation, IcfgLocation>();
    private final ILogger mLogger;
    private final Set<IIcfgTransition<IcfgLocation>> mIntermediateEdges = new HashSet<IIcfgTransition<IcfgLocation>>();
    private Function<Term, Term> mTermTranslator = term -> term;
    private Set<Term> mVariableBlacklist = Collections.emptySet();

    public BlockEncodingBacktranslator(Class<? extends IIcfgTransition<IcfgLocation>> clazz, Class<Term> clazz2, ILogger iLogger) {
        super(clazz, clazz, clazz2, clazz2);
        this.mLogger = iLogger;
    }

    public IProgramExecution<IIcfgTransition<IcfgLocation>, Term> translateProgramExecution(IProgramExecution<IIcfgTransition<IcfgLocation>, Term> iProgramExecution) {
        if (iProgramExecution == null) {
            throw new IllegalArgumentException("programExecution is null");
        }
        if (!(iProgramExecution instanceof IcfgProgramExecution)) {
            throw new IllegalArgumentException("argument is not IcfgProgramExecution but " + String.valueOf(iProgramExecution.getClass()));
        }
        IcfgProgramExecution icfgProgramExecution = (IcfgProgramExecution)iProgramExecution;
        Map<TermVariable, Boolean>[] mapArray = icfgProgramExecution.getBranchEncoders();
        assert (mapArray.length == icfgProgramExecution.getLength()) : "incorrect number of branch encoders: expected " + icfgProgramExecution.getLength() + ", actual " + mapArray.length;
        assert (this.checkCallStackSourceProgramExecution(this.mLogger, icfgProgramExecution)) : "callstack of initial program execution already broken";
        ArrayList arrayList = new ArrayList();
        ArrayList<IIcfgTransition<IcfgLocation>> arrayList2 = new ArrayList<IIcfgTransition<IcfgLocation>>();
        ArrayList<Map<TermVariable, Boolean>> arrayList3 = new ArrayList<Map<TermVariable, Boolean>>();
        int n = 0;
        while (n < icfgProgramExecution.getLength()) {
            IIcfgTransition<IcfgLocation> iIcfgTransition;
            AtomicTraceElement atomicTraceElement = icfgProgramExecution.getTraceElement(n);
            Collection<IIcfgTransition<IcfgLocation>> collection = this.translateBack((IIcfgTransition)atomicTraceElement.getTraceElement(), mapArray[n]);
            Iterator<IIcfgTransition<IcfgLocation>> iterator = collection.iterator();
            while (iterator.hasNext()) {
                iIcfgTransition = iterator.next();
                AtomicTraceElement.AtomicTraceElementBuilder atomicTraceElementBuilder = AtomicTraceElement.AtomicTraceElementBuilder.fromReplaceElementAndStep(atomicTraceElement, iIcfgTransition);
                Consumer<AtomicTraceElement.AtomicTraceElementBuilder<IIcfgTransition<IcfgLocation>>> consumer = this.mAteTransformer.get(atomicTraceElement.getTraceElement());
                if (consumer != null) {
                    consumer.accept((AtomicTraceElement.AtomicTraceElementBuilder<IIcfgTransition<IcfgLocation>>)atomicTraceElementBuilder);
                }
                arrayList.add(atomicTraceElementBuilder.build());
                if (!iterator.hasNext()) continue;
                arrayList2.add(null);
                arrayList3.add(mapArray[n]);
            }
            iIcfgTransition = this.translateProgramState(icfgProgramExecution.getProgramState(n));
            arrayList2.add(iIcfgTransition);
            arrayList3.add(mapArray[n]);
            ++n;
        }
        HashMap<Integer, IProgramExecution.ProgramState<Term>> hashMap = new HashMap<Integer, IProgramExecution.ProgramState<Term>>();
        hashMap.put(-1, this.translateProgramState(icfgProgramExecution.getInitialProgramState()));
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            hashMap.put(n2, (IProgramExecution.ProgramState)arrayList2.get(n2));
            ++n2;
        }
        IcfgProgramExecution<IIcfgTransition<IcfgLocation>> icfgProgramExecution2 = new IcfgProgramExecution<IIcfgTransition<IcfgLocation>>(arrayList, hashMap, arrayList3.toArray(new Map[arrayList3.size()]), icfgProgramExecution.isConcurrent(), IcfgProgramExecution.getClassFromAtomicTraceElements(arrayList));
        assert (this.checkCallStackTargetProgramExecution(this.mLogger, icfgProgramExecution2)) : "callstack broke during translation";
        return icfgProgramExecution2;
    }

    private Collection<IIcfgTransition<IcfgLocation>> translateBack(IIcfgTransition<IcfgLocation> iIcfgTransition, Map<TermVariable, Boolean> map) {
        ArrayDeque<IIcfgTransition<IcfgLocation>> arrayDeque = new ArrayDeque<IIcfgTransition<IcfgLocation>>();
        ArrayDeque<IIcfgTransition> arrayDeque2 = new ArrayDeque<IIcfgTransition>();
        arrayDeque2.push(iIcfgTransition);
        while (!arrayDeque2.isEmpty()) {
            Collection<IIcfgTransition<IcfgLocation>> collection;
            IIcfgTransition iIcfgTransition2 = (IIcfgTransition)arrayDeque2.pop();
            if (this.mSequentialCompositions.containsKey(iIcfgTransition2)) {
                collection = this.mSequentialCompositions.get(iIcfgTransition2);
                assert (collection != null);
                for (IIcfgTransition<IcfgLocation> iIcfgTransition3 : collection) {
                    arrayDeque2.push(iIcfgTransition3);
                }
                continue;
            }
            if (this.mParallelCompositions.containsKey(iIcfgTransition2)) {
                collection = this.mParallelCompositions.get(iIcfgTransition2);
                assert (collection != null);
                if (map == null) {
                    this.mLogger.warn((Object)"Failed to translate choice composition: Branch encoders not available.");
                    arrayDeque.addFirst(iIcfgTransition2);
                    continue;
                }
                boolean bl = false;
                for (IIcfgTransition iIcfgTransition3 : collection) {
                    assert (this.mBranchEncoderMapping.get(iIcfgTransition3) != null) : "Choice composition is missing branch encoder";
                    TermVariable termVariable = this.mBranchEncoderMapping.get(iIcfgTransition3);
                    assert (map.get(termVariable) != null) : "Branch indicator value was unknown";
                    if (!map.get(termVariable).booleanValue()) continue;
                    arrayDeque2.push(iIcfgTransition3);
                    bl = true;
                    break;
                }
                assert (bl) : "Could not determine correct choice for choice composition";
                continue;
            }
            arrayDeque.addFirst(iIcfgTransition2);
        }
        return arrayDeque;
    }

    public void mapEdges(IIcfgTransition<IcfgLocation> iIcfgTransition2, IIcfgTransition<IcfgLocation> iIcfgTransition3) {
        List<IIcfgTransition<IcfgLocation>> list = this.mSequentialCompositions.get(iIcfgTransition3);
        if (list != null) {
            this.mIntermediateEdges.add(iIcfgTransition3);
            for (IIcfgTransition<IcfgLocation> iIcfgTransition4 : list) {
                this.mapEdges(iIcfgTransition2, iIcfgTransition4);
            }
            return;
        }
        List list2 = this.mSequentialCompositions.computeIfAbsent(iIcfgTransition2, iIcfgTransition -> new ArrayList());
        list2.add(iIcfgTransition3);
    }

    public void mapEdges(IIcfgTransition<IcfgLocation> iIcfgTransition, Map<TermVariable, IIcfgTransition<IcfgLocation>> map) {
        for (Map.Entry<TermVariable, IIcfgTransition<IcfgLocation>> entry : map.entrySet()) {
            this.mapEdges(iIcfgTransition, entry.getValue(), entry.getKey());
        }
    }

    public void mapEdges(IIcfgTransition<IcfgLocation> iIcfgTransition2, IIcfgTransition<IcfgLocation> iIcfgTransition3, TermVariable termVariable) {
        TermVariable termVariable2 = this.mBranchEncoderMapping.get(iIcfgTransition3);
        assert (termVariable2 == null || termVariable2 == termVariable) : "Ambiguous branch encoder for transition";
        this.mBranchEncoderMapping.put(iIcfgTransition3, termVariable);
        Set<IIcfgTransition<IcfgLocation>> set = this.mParallelCompositions.get(iIcfgTransition3);
        if (set != null) {
            this.mIntermediateEdges.add(iIcfgTransition3);
            for (IIcfgTransition<IcfgLocation> iIcfgTransition4 : set) {
                this.mapEdges(iIcfgTransition2, iIcfgTransition4, this.mBranchEncoderMapping.get(iIcfgTransition4));
            }
            return;
        }
        Set set2 = this.mParallelCompositions.computeIfAbsent(iIcfgTransition2, iIcfgTransition -> new HashSet());
        set2.add(iIcfgTransition3);
    }

    public void removeIntermediateMappings() {
        if (this.mIntermediateEdges.isEmpty()) {
            return;
        }
        for (IIcfgTransition<IcfgLocation> iIcfgTransition : this.mIntermediateEdges) {
            assert (this.mSequentialCompositions.values().stream().noneMatch(list -> list.contains(iIcfgTransition))) : "Intermediate edge should not be used in sequential composition";
            assert (this.mParallelCompositions.values().stream().noneMatch(set -> set.contains(iIcfgTransition))) : "Intermediate edge should not be used in parallel composition";
            this.mSequentialCompositions.remove(iIcfgTransition);
            this.mParallelCompositions.remove(iIcfgTransition);
        }
        this.mIntermediateEdges.clear();
    }

    private void printMapping(IIcfgTransition<IcfgLocation> iIcfgTransition, List<IIcfgTransition<IcfgLocation>> list) {
        this.mLogger.info((Object)(BlockEncodingBacktranslator.markCodeblock(iIcfgTransition) + iIcfgTransition.hashCode() + " is mapped to " + BlockEncodingBacktranslator.getCollectionString(list)));
    }

    private void printMapping(IIcfgTransition<IcfgLocation> iIcfgTransition, Set<IIcfgTransition<IcfgLocation>> set) {
        this.mLogger.info((Object)(BlockEncodingBacktranslator.markCodeblock(iIcfgTransition) + iIcfgTransition.hashCode() + " is mapped (in parallel) to " + BlockEncodingBacktranslator.getCollectionString(set)));
    }

    private static String getCollectionString(Collection<IIcfgTransition<IcfgLocation>> collection) {
        return collection.stream().map(iIcfgTransition -> BlockEncodingBacktranslator.markCodeblock(iIcfgTransition) + String.valueOf(iIcfgTransition.hashCode())).collect(Collectors.joining(","));
    }

    public void addAteTransformer(IIcfgTransition<IcfgLocation> iIcfgTransition, Consumer<AtomicTraceElement.AtomicTraceElementBuilder<IIcfgTransition<IcfgLocation>>> consumer) {
        this.mAteTransformer.merge(iIcfgTransition, consumer, Consumer::andThen);
    }

    private static String markCodeblock(IIcfgTransition<IcfgLocation> iIcfgTransition) {
        return "";
    }

    public void mapLocations(IcfgLocation icfgLocation, IcfgLocation icfgLocation2) {
        IcfgLocation icfgLocation3 = this.mLocationMapping.get(icfgLocation2);
        if (icfgLocation3 != null) {
            this.mLocationMapping.put(icfgLocation, icfgLocation3);
        } else {
            this.mLocationMapping.put(icfgLocation, icfgLocation2);
        }
    }

    public Map<IcfgLocation, IcfgLocation> getLocationMapping() {
        return Collections.unmodifiableMap(this.mLocationMapping);
    }

    @Deprecated
    public Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> getEdgeMapping() {
        HashMap<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> hashMap = new HashMap<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>>();
        for (Map.Entry<IIcfgTransition<IcfgLocation>, List<IIcfgTransition<IcfgLocation>>> entry : this.mSequentialCompositions.entrySet()) {
            if (entry.getValue().size() > 1) {
                throw new UnsupportedOperationException("The new edge " + String.valueOf(entry.getKey()) + " is mapped to multiple edges");
            }
            hashMap.put(entry.getKey(), entry.getValue().isEmpty() ? null : entry.getValue().get(0));
        }
        return hashMap;
    }

    protected void printBrokenCallStackSource(List<AtomicTraceElement<IIcfgTransition<IcfgLocation>>> list, int n) {
        List list2 = list.stream().limit(n).map(atomicTraceElement -> (IIcfgTransition)atomicTraceElement.getTraceElement()).collect(Collectors.toList());
        this.mLogger.fatal((Object)new ProgramExecutionFormatter(new IcfgBacktranslationValueProvider()).formatProgramExecution(IcfgProgramExecution.create(list2, Collections.emptyMap())));
    }

    protected void printBrokenCallStackTarget(List<AtomicTraceElement<IIcfgTransition<IcfgLocation>>> list, int n) {
        this.printBrokenCallStackSource(list, n);
    }

    public void setTermTranslator(Function<Term, Term> function) {
        this.mTermTranslator = function;
    }

    public Term translateExpression(Term term) {
        Term term2 = this.mTermTranslator.apply(term);
        return term2;
    }

    public IProgramExecution.ProgramState<Term> translateProgramState(IProgramExecution.ProgramState<Term> programState) {
        if (programState == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        for (Term term : programState.getVariables()) {
            if (this.mVariableBlacklist.contains(term)) continue;
            Term term2 = this.translateExpression(term);
            ArrayList<Term> arrayList = new ArrayList<Term>();
            for (Term term3 : programState.getValues((Object)term)) {
                arrayList.add(this.translateExpression(term3));
            }
            hashMap.put(term2, arrayList);
        }
        return new IProgramExecution.ProgramState(hashMap, this.getTargetExpressionClass());
    }

    public void setVariableBlacklist(Set<Term> set) {
        this.mVariableBlacklist = set;
    }
}

