/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker.ObserverDispatcher;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker.RCFGWalker;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;

public class RCFGWalkerBreadthFirst
extends RCFGWalker {
    protected Queue<IcfgEdge> mRemainingEdges = new LinkedList<IcfgEdge>();
    protected HashSet<IcfgEdge> mProcessedEdges = new HashSet();

    public RCFGWalkerBreadthFirst(ObserverDispatcher observerDispatcher, ILogger iLogger) {
        super(observerDispatcher, iLogger);
    }

    @Override
    public void startFrom(Collection<IcfgEdge> collection) {
        this.mRemainingEdges.addAll(collection);
        this.processMethods();
    }

    protected void processMethods() {
        while (!this.mRemainingEdges.isEmpty()) {
            if (this.mDispatcher.abortAll()) {
                return;
            }
            IcfgEdge icfgEdge = this.mRemainingEdges.poll();
            this.level(icfgEdge);
            this.mProcessedEdges.add(icfgEdge);
            IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getTarget();
            this.level(icfgLocation);
            if (this.mDispatcher.abortCurrentBranch()) continue;
            for (IcfgEdge icfgEdge2 : icfgLocation.getOutgoingEdges()) {
                if (this.mProcessedEdges.contains(icfgEdge2)) continue;
                this.mRemainingEdges.add(icfgEdge2);
            }
        }
    }
}

