/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ICallSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.SummaryCache;
import java.util.HashMap;
import java.util.Map;

public class ReUseSupersetCallSummarizer
implements ICallSummarizer {
    private final SifaStats mStats;
    private final SymbolicTools mTools;
    private final IDomain mDomain;
    private final ICallSummarizer mSummarizer;
    private final Map<String, SummaryCache> mSummaryCache = new HashMap<String, SummaryCache>();

    public ReUseSupersetCallSummarizer(SifaStats sifaStats, SymbolicTools symbolicTools, IDomain iDomain, ICallSummarizer iCallSummarizer) {
        this.mStats = sifaStats;
        this.mTools = symbolicTools;
        this.mDomain = iDomain;
        this.mSummarizer = iCallSummarizer;
    }

    @Override
    public IPredicate summarize(String string2, IPredicate iPredicate) {
        this.mStats.start(SifaStats.Key.CALL_SUMMARIZER_OVERALL_TIME);
        this.mStats.increment(SifaStats.Key.CALL_SUMMARIZER_APPLICATIONS);
        IPredicate iPredicate2 = this.mSummaryCache.computeIfAbsent(string2, string -> new SummaryCache()).reUseOrCompute(iPredicate, this::isSubsetEq, () -> this.mSummarizer.summarize(string2, iPredicate), this.mTools);
        this.mStats.stop(SifaStats.Key.CALL_SUMMARIZER_OVERALL_TIME);
        return iPredicate2;
    }

    private boolean isSubsetEq(IPredicate iPredicate, IPredicate iPredicate2) {
        IDomain.ResultForAlteredInputs resultForAlteredInputs = this.mDomain.isSubsetEq(iPredicate, iPredicate2);
        return resultForAlteredInputs.isTrueForAbstraction() && resultForAlteredInputs.getRhs() == iPredicate2;
    }
}

