/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NestedRun<LETTER, STATE>
implements IRun<LETTER, STATE> {
    private static final char BLANK = ' ';
    private NestedWord<LETTER> mNestedWord;
    private List<STATE> mStateSequence;

    public NestedRun(NestedWord<LETTER> nestedWord, List<STATE> list) {
        if (nestedWord.length() + 1 != list.size()) {
            throw new IllegalArgumentException("In a run the length of the sequence of states is the length of the word plus 1.");
        }
        this.mNestedWord = nestedWord;
        this.mStateSequence = list;
    }

    public NestedRun(STATE STATE) {
        Object[] objectArray = new Object[]{};
        int[] nArray = new int[]{};
        this.mNestedWord = new NestedWord<Object>(objectArray, nArray);
        this.mStateSequence = new ArrayList<STATE>(1);
        this.mStateSequence.add(STATE);
    }

    public NestedRun(STATE STATE, LETTER LETTER, int n, STATE STATE2) {
        if (n != -2 && n != Integer.MIN_VALUE && n != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Wrong position in the nested word.");
        }
        Object[] objectArray = new Object[]{LETTER};
        int[] nArray = new int[]{n};
        this.mNestedWord = new NestedWord<Object>(objectArray, nArray);
        this.mStateSequence = new ArrayList<STATE>(2);
        this.mStateSequence.add(STATE);
        this.mStateSequence.add(STATE2);
    }

    @Override
    public NestedWord<LETTER> getWord() {
        return this.mNestedWord;
    }

    @Override
    public List<STATE> getStateSequence() {
        return this.mStateSequence;
    }

    @Override
    public int getLength() {
        return this.mStateSequence.size();
    }

    public boolean isCallPosition(int n) {
        return this.mNestedWord.isCallPosition(n);
    }

    public boolean isInternalPosition(int n) {
        return this.mNestedWord.isInternalPosition(n);
    }

    public boolean isReturnPosition(int n) {
        return this.mNestedWord.isReturnPosition(n);
    }

    public boolean isPendingCall(int n) {
        return this.mNestedWord.isPendingCall(n);
    }

    public NestedRun<LETTER, STATE> concatenate(NestedRun<LETTER, STATE> nestedRun) {
        STATE STATE;
        STATE STATE2 = this.mStateSequence.get(this.mStateSequence.size() - 1);
        if (STATE2.equals(STATE = nestedRun.mStateSequence.get(0))) {
            NestedWord<LETTER> nestedWord = this.mNestedWord.concatenate((NestedWord<LETTER>)nestedRun.getWord());
            ArrayList<STATE> arrayList = new ArrayList<STATE>(this.mStateSequence);
            int n = 1;
            while (n < nestedRun.getStateSequence().size()) {
                arrayList.add(nestedRun.getStateSequence().get(n));
                ++n;
            }
            return new NestedRun<LETTER, STATE>(nestedWord, arrayList);
        }
        throw new IllegalArgumentException("Can only concatenate two runs where the last element of the first run's statement sequence is the same state as the last element of the second run's statement sequence.");
    }

    public STATE getStateAtPosition(int n) {
        return this.mStateSequence.get(n);
    }

    @Override
    public LETTER getSymbol(int n) {
        return this.mNestedWord.getSymbol(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.mNestedWord.length()) {
            stringBuilder.append(this.getStateAtPosition(n)).append(' ');
            if (this.mNestedWord.isInternalPosition(n)) {
                stringBuilder.append(this.mNestedWord.getSymbol(n)).append(' ');
            } else if (this.mNestedWord.isCallPosition(n)) {
                stringBuilder.append(this.mNestedWord.getSymbol(n)).append("< ");
            } else if (this.mNestedWord.isReturnPosition(n)) {
                stringBuilder.append('>').append(this.mNestedWord.getSymbol(n)).append(' ');
            }
            ++n;
        }
        stringBuilder.append(this.getStateAtPosition(this.mStateSequence.size() - 1)).append(' ');
        return stringBuilder.toString();
    }

    public static <LETTER, STATE> boolean isEqual(NestedRun<LETTER, STATE> nestedRun, NestedRun<LETTER, STATE> nestedRun2) {
        if (nestedRun == null || nestedRun2 == null) {
            return nestedRun == null && nestedRun2 == null;
        }
        if (nestedRun.getLength() != nestedRun2.getLength()) {
            return false;
        }
        int n = nestedRun.getLength();
        int n2 = 0;
        while (n2 < n) {
            LETTER LETTER;
            LETTER LETTER2;
            STATE STATE;
            STATE STATE2 = nestedRun.getStateAtPosition(n2);
            if (!Objects.equals(STATE2, STATE = nestedRun2.getStateAtPosition(n2))) {
                return false;
            }
            if (n2 < n - 1 && !Objects.equals(LETTER2 = nestedRun.getSymbol(n2), LETTER = nestedRun2.getSymbol(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public NestedRun<LETTER, STATE> getSubRun(int n, int n2) {
        return new NestedRun<LETTER, STATE>(this.mNestedWord.getSubWord(n, n2), new ArrayList<STATE>(this.mStateSequence.subList(n, n2 + 1)));
    }
}

