/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.BuchiProgramAcceptingStateAnnotation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IcfgDuplicator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.IEncoder;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.InterproceduralSequenzer;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.MaximizeFinalStates;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.MinimizeStatesMultiEdgeMultiNode;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.MinimizeStatesMultiEdgeSingleNode;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.MinimizeStatesSingleEdgeSingleNode;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.ParallelComposer;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.RemoveInfeasibleEdges;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.RemoveSinkStates;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.RewriteNotEquals;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.Simplifier;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.SmallBlockEncoder;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.preferences.BlockEncodingPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.IcfgSizeBenchmark;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public final class BlockEncoder {
    private static final BuchiProgramAcceptingStateAnnotation BUCHI_PROGRAM_ACCEPTING_STATE_ANNOTATION = new BuchiProgramAcceptingStateAnnotation();
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final BlockEncodingBacktranslator mBacktranslator;
    private final IcfgEdgeBuilder mEdgeBuilder;
    private BasicIcfg<IcfgLocation> mIterationResult;
    private final boolean mRunAsPlugin;

    public BlockEncoder(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator, IcfgEdgeBuilder icfgEdgeBuilder, BasicIcfg<IcfgLocation> basicIcfg) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mIterationResult = null;
        this.mBacktranslator = blockEncodingBacktranslator;
        this.mEdgeBuilder = icfgEdgeBuilder;
        this.mRunAsPlugin = true;
        this.processIcfg(basicIcfg);
    }

    public BlockEncoder(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, IIcfg<?> iIcfg, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mRunAsPlugin = false;
        this.mBacktranslator = new BlockEncodingBacktranslator(IcfgEdge.class, Term.class, this.mLogger);
        CfgSmtToolkit cfgSmtToolkit = iIcfg.getCfgSmtToolkit();
        this.mEdgeBuilder = new IcfgEdgeBuilder(cfgSmtToolkit, this.mServices, simplificationTechnique);
        BasicIcfg basicIcfg = new IcfgDuplicator(this.mLogger, this.mServices, cfgSmtToolkit.getManagedScript(), this.mBacktranslator).copy(iIcfg, "_BEv2", true);
        this.processIcfg((BasicIcfg<IcfgLocation>)basicIcfg);
    }

    public IIcfg<IcfgLocation> getResult() {
        return this.mIterationResult;
    }

    public BlockEncodingBacktranslator getBacktranslator() {
        return this.mBacktranslator;
    }

    private void processIcfg(BasicIcfg<IcfgLocation> basicIcfg) {
        this.reportSizeBenchmark("Initial Icfg", (IIcfg<?>)basicIcfg);
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        int n = iPreferenceProvider.getInt("Iterate optimizations for n times (<=0 means until nothing changes)") - 1;
        if (n < 0) {
            n = -1;
        } else {
            this.mLogger.info((Object)String.format("Using %s=%s", "Iterate optimizations for n times (<=0 means until nothing changes)", n + 1));
        }
        this.mIterationResult = basicIcfg;
        List<Supplier<IEncoder<IcfgLocation>>> list = this.getEncoderProviders(iPreferenceProvider, (IIcfg<?>)basicIcfg);
        boolean bl = iPreferenceProvider.getBoolean("Apply optimizations until nothing changes");
        this.mLogger.info((Object)String.format("Using %s=%s", "Apply optimizations until nothing changes", bl));
        int n2 = 1;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"==== BE Preprocessing ====");
        }
        if (iPreferenceProvider.getBoolean("Rewrite not-equals")) {
            this.mLogger.info((Object)"Using Rewrite not-equals");
            this.mIterationResult = new RewriteNotEquals(this.mEdgeBuilder, this.mServices, this.mBacktranslator, this.mLogger).getResult(this.mIterationResult);
        }
        if (iPreferenceProvider.getBoolean("Use SBE")) {
            int n3;
            block13: {
                this.mLogger.info((Object)"Using Use SBE");
                n3 = 0;
                do {
                    SmallBlockEncoder object = new SmallBlockEncoder(this.mEdgeBuilder, this.mServices, this.mBacktranslator, this.mLogger);
                    this.mIterationResult = object.getResult(this.mIterationResult);
                    n3 += object.getRemovedEdges();
                    if (!object.isGraphStructureChanged()) break block13;
                } while (this.mServices.getProgressMonitorService().continueProcessing());
                int n4 = IcfgUtils.getNumberOfLocations(basicIcfg);
                String string = String.format("applying SBE block encoding to ICFG that has %s locations", n4);
                throw new ToolchainCanceledException(BlockEncoder.class, string);
            }
            this.mLogger.info((Object)("SBE split " + n3 + " edges"));
        }
        while (true) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("==== BE Pass #" + n2 + "===="));
            }
            ++n2;
            EncodingResult encodingResult = new EncodingResult(this.mIterationResult, false);
            for (Supplier<IEncoder<IcfgLocation>> supplier : list) {
                IEncoder<IcfgLocation> iEncoder = supplier.get();
                encodingResult = BlockEncoder.applyEncoder(encodingResult, iEncoder);
            }
            this.mIterationResult = encodingResult.getIcfg();
            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                int n5 = IcfgUtils.getNumberOfLocations(basicIcfg);
                String string = String.format("applying block encoding to ICFG that has %s locations", n5);
                throw new ToolchainCanceledException(BlockEncoder.class, string);
            }
            if (!bl || !encodingResult.isChanged() || n == 0) break;
            if (n <= 0) continue;
            --n;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"==== BE Postprocessing ====");
        }
        if (iPreferenceProvider.getBoolean("Create parallel compositions if possible")) {
            this.mLogger.info((Object)String.format("Using %s", "Create parallel compositions if possible"));
            this.mIterationResult = new ParallelComposer(this.mEdgeBuilder, this.mServices, this.mBacktranslator, this.mLogger).getResult(this.mIterationResult);
        }
        if (iPreferenceProvider.getBoolean("Simplify transitions")) {
            this.mLogger.info((Object)String.format("Using %s", "Simplify transitions"));
            this.mIterationResult = new Simplifier(this.mEdgeBuilder, this.mServices, this.mBacktranslator, this.mLogger).getResult(this.mIterationResult);
        }
        this.reportSizeBenchmark("Encoded RCFG", (IIcfg<?>)this.mIterationResult);
    }

    private List<Supplier<IEncoder<IcfgLocation>>> getEncoderProviders(IPreferenceProvider iPreferenceProvider, IIcfg<?> iIcfg) {
        ArrayList<Supplier<IEncoder<IcfgLocation>>> arrayList = new ArrayList<Supplier<IEncoder<IcfgLocation>>>();
        if (iPreferenceProvider.getBoolean("Remove infeasible edges")) {
            this.mLogger.info((Object)"Using Remove infeasible edges");
            arrayList.add(() -> new RemoveInfeasibleEdges(this.mServices, this.mBacktranslator, this.mLogger));
        }
        if (iPreferenceProvider.getBoolean("Maximize final states")) {
            this.mLogger.info((Object)"Using Maximize final states");
            arrayList.add(() -> new MaximizeFinalStates(this.mServices, BlockEncoder::markBuchiProgramAccepting, BlockEncoder::isBuchiProgramAccepting, this.mBacktranslator, this.mLogger));
        }
        boolean bl = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Minimize states even if more edges are added than removed.");
        this.mLogger.info((Object)String.format("Using %s=%s", "Minimize states even if more edges are added than removed.", bl));
        BlockEncodingPreferences.MinimizeStates minimizeStates = (BlockEncodingPreferences.MinimizeStates)iPreferenceProvider.getEnum("Minimize states using LBE with the strategy", BlockEncodingPreferences.MinimizeStates.class);
        if (minimizeStates != BlockEncodingPreferences.MinimizeStates.NONE) {
            this.mLogger.info((Object)String.format("Using %s=%s", new Object[]{"Minimize states using LBE with the strategy", minimizeStates}));
            switch (minimizeStates) {
                case SINGLE: {
                    arrayList.add(() -> new MinimizeStatesSingleEdgeSingleNode(this.mEdgeBuilder, this.mServices, this.mBacktranslator, BlockEncoder::hasToBePreserved, this.mLogger, bl));
                    break;
                }
                case SINGLE_NODE_MULTI_EDGE: {
                    arrayList.add(() -> new MinimizeStatesMultiEdgeSingleNode(this.mEdgeBuilder, this.mServices, this.mBacktranslator, BlockEncoder::hasToBePreserved, this.mLogger, bl));
                    break;
                }
                case MULTI: {
                    arrayList.add(() -> new MinimizeStatesMultiEdgeMultiNode(this.mEdgeBuilder, this.mServices, this.mBacktranslator, BlockEncoder::hasToBePreserved, this.mLogger, bl));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf((Object)minimizeStates) + " is an unknown enum value!");
                }
            }
        }
        if (iPreferenceProvider.getBoolean("Remove sink states")) {
            this.mLogger.info((Object)"Using Remove sink states");
            arrayList.add(() -> new RemoveSinkStates(this.mServices, BlockEncoder::hasToBePreserved, this.mBacktranslator, this.mLogger));
        }
        arrayList.add(() -> new InterproceduralSequenzer(this.mEdgeBuilder, this.mServices, this.mBacktranslator, this.mLogger));
        return arrayList;
    }

    private static EncodingResult applyEncoder(EncodingResult encodingResult, IEncoder<IcfgLocation> iEncoder) {
        BasicIcfg<IcfgLocation> basicIcfg = iEncoder.getResult(encodingResult.getIcfg());
        return new EncodingResult(basicIcfg, encodingResult.isChanged() || iEncoder.isGraphStructureChanged());
    }

    private void reportSizeBenchmark(String string, IIcfg<?> iIcfg) {
        IcfgSizeBenchmark icfgSizeBenchmark = new IcfgSizeBenchmark(iIcfg, string);
        this.mLogger.info((Object)(string + " " + String.valueOf(icfgSizeBenchmark)));
        if (this.mRunAsPlugin) {
            icfgSizeBenchmark.reportBenchmarkResult(this.mServices.getResultService(), Activator.PLUGIN_ID, string);
        }
    }

    private static boolean hasToBePreserved(IIcfg<?> iIcfg, IcfgLocation icfgLocation) {
        if (icfgLocation == null) {
            return false;
        }
        String string = icfgLocation.getProcedure();
        Set set = (Set)iIcfg.getProcedureErrorNodes().get(string);
        if (set.contains(icfgLocation)) {
            return true;
        }
        Set set2 = iIcfg.getLoopLocations();
        return set2.contains(icfgLocation);
    }

    private static boolean isBuchiProgramAccepting(IcfgLocation icfgLocation) {
        return BuchiProgramAcceptingStateAnnotation.getAnnotation((IElement)icfgLocation) != null;
    }

    private static void markBuchiProgramAccepting(IcfgLocation icfgLocation) {
        BUCHI_PROGRAM_ACCEPTING_STATE_ANNOTATION.annotate((IElement)icfgLocation);
    }

    private static class EncodingResult {
        private final BasicIcfg<IcfgLocation> mNode;
        private final boolean mIsChanged;

        private EncodingResult(BasicIcfg<IcfgLocation> basicIcfg, boolean bl) {
            this.mNode = basicIcfg;
            this.mIsChanged = bl;
        }

        private boolean isChanged() {
            return this.mIsChanged;
        }

        private BasicIcfg<IcfgLocation> getIcfg() {
            return this.mNode;
        }
    }
}

