/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.ExpressionTransformer;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.HavocBundler;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctAssumeProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctStatementProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.CallInfoCache;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class OctPostOperator
implements IAbstractPostOperator<OctDomainState, IcfgEdge> {
    private final ILogger mLogger;
    private final BoogieSymbolTable mSymbolTable;
    private final int mMaxParallelStates;
    private final boolean mFallbackAssignIntervalProjection;
    private final HavocBundler mHavocBundler;
    private final ExpressionTransformer mExprTransformer;
    private final OctStatementProcessor mStatementProcessor;
    private final OctAssumeProcessor mAssumeProcessor;
    private final IBoogieSymbolTableVariableProvider mBpl2SmtTable;
    private final CallInfoCache mCallInfoCache;

    public OctPostOperator(ILogger iLogger, BoogieSymbolTable boogieSymbolTable, CfgSmtToolkit cfgSmtToolkit, int n, boolean bl, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider, IAbstractPostOperator<IntervalDomainState, IcfgEdge> iAbstractPostOperator, CodeBlockFactory codeBlockFactory) {
        if (n < 1) {
            throw new IllegalArgumentException("MaxParallelStates needs to be > 0, was " + n);
        }
        this.mLogger = iLogger;
        this.mSymbolTable = boogieSymbolTable;
        this.mBpl2SmtTable = iBoogieSymbolTableVariableProvider;
        this.mMaxParallelStates = n;
        this.mFallbackAssignIntervalProjection = bl;
        this.mHavocBundler = new HavocBundler();
        this.mExprTransformer = new ExpressionTransformer(iBoogieSymbolTableVariableProvider);
        this.mStatementProcessor = new OctStatementProcessor(this);
        this.mAssumeProcessor = new OctAssumeProcessor(this.mLogger, this, iAbstractPostOperator, codeBlockFactory, iBoogieSymbolTableVariableProvider);
        this.mCallInfoCache = new CallInfoCache(cfgSmtToolkit, boogieSymbolTable);
    }

    public static OctDomainState join(List<OctDomainState> list) {
        OctDomainState octDomainState = null;
        for (OctDomainState octDomainState2 : list) {
            octDomainState = octDomainState == null ? octDomainState2 : octDomainState.union(octDomainState2);
        }
        return octDomainState;
    }

    public static List<OctDomainState> joinToSingleton(List<OctDomainState> list) {
        return AbsIntUtil.singletonArrayList(OctPostOperator.join(list));
    }

    public static List<OctDomainState> deepCopy(List<OctDomainState> list) {
        ArrayList<OctDomainState> arrayList = new ArrayList<OctDomainState>(list.size());
        list.forEach(octDomainState -> {
            boolean bl = arrayList.add(octDomainState.deepCopy());
        });
        return arrayList;
    }

    public List<OctDomainState> splitF(List<OctDomainState> list, Function<List<OctDomainState>, List<OctDomainState>> function, Function<List<OctDomainState>, List<OctDomainState>> function2) {
        List<OctDomainState> list2 = function.apply(OctPostOperator.deepCopy(list));
        list2.addAll((Collection<OctDomainState>)function2.apply(list));
        return this.joinDownToMax(list2);
    }

    public List<OctDomainState> splitC(List<OctDomainState> list, Consumer<OctDomainState> consumer, Consumer<OctDomainState> consumer2) {
        List<OctDomainState> list2 = OctPostOperator.deepCopy(list);
        list.forEach(consumer);
        list2.forEach(consumer2);
        list.addAll(list2);
        return this.joinDownToMax(list);
    }

    public static List<OctDomainState> removeBottomStates(List<OctDomainState> list) {
        ArrayList<OctDomainState> arrayList = new ArrayList<OctDomainState>(list.size());
        for (OctDomainState octDomainState : list) {
            if (octDomainState.isBottom()) continue;
            arrayList.add(octDomainState);
        }
        return arrayList;
    }

    public List<OctDomainState> joinDownToMax(List<OctDomainState> list) {
        if (list.size() <= this.mMaxParallelStates) {
            return list;
        }
        if ((list = OctPostOperator.removeBottomStates(list)).size() <= this.mMaxParallelStates) {
            return list;
        }
        return OctPostOperator.joinToSingleton(list);
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public ExpressionTransformer getExprTransformer() {
        return this.mExprTransformer;
    }

    public OctAssumeProcessor getAssumeProcessor() {
        return this.mAssumeProcessor;
    }

    public IBoogieSymbolTableVariableProvider getBoogie2SmtSymbolTable() {
        return this.mBpl2SmtTable;
    }

    public int getMaxParallelStates() {
        return this.mMaxParallelStates;
    }

    public boolean isFallbackAssignIntervalProjectionEnabled() {
        return this.mFallbackAssignIntervalProjection;
    }

    public List<OctDomainState> apply(OctDomainState octDomainState, IcfgEdge icfgEdge) {
        IcfgEdge icfgEdge2 = icfgEdge.getLabel();
        if (icfgEdge2 instanceof Summary && !((Summary)icfgEdge2).calledProcedureHasImplementation()) {
            throw new UnsupportedOperationException("Summary for procedure without implementation");
        }
        if (icfgEdge2 instanceof Call) {
            return this.applyCall(octDomainState, octDomainState, (Call)icfgEdge2);
        }
        if (icfgEdge2 instanceof Return) {
            return this.applyReturn(octDomainState, octDomainState, ((Return)icfgEdge2).getCallStatement());
        }
        List<OctDomainState> list = OctPostOperator.deepCopy(Collections.singletonList(octDomainState));
        List<Statement> list2 = this.mHavocBundler.bundleHavocsCached(icfgEdge2);
        for (Statement statement : list2) {
            list = this.mStatementProcessor.processStatement(statement, list);
        }
        return list;
    }

    public List<OctDomainState> apply(OctDomainState octDomainState, OctDomainState octDomainState2, IcfgEdge icfgEdge) {
        List<OctDomainState> list;
        IcfgEdge icfgEdge2 = icfgEdge.getLabel();
        if (icfgEdge2 instanceof Call) {
            list = this.applyCall(octDomainState, octDomainState2, (Call)icfgEdge2);
        } else if (icfgEdge2 instanceof Return) {
            list = this.applyReturn(octDomainState, octDomainState2, ((Return)icfgEdge2).getCallStatement());
        } else if (icfgEdge2 instanceof Summary) {
            list = this.applyReturn(octDomainState, octDomainState2, ((Summary)icfgEdge2).getCallStatement());
        } else {
            throw new UnsupportedOperationException("Unsupported transition: " + String.valueOf(icfgEdge2));
        }
        return list;
    }

    private List<OctDomainState> applyCall(OctDomainState octDomainState, OctDomainState octDomainState3, Call call) {
        if (octDomainState3.isBottom()) {
            return new ArrayList<OctDomainState>();
        }
        CallStatement callStatement = call.getCallStatement();
        CallInfoCache.CallInfo callInfo = this.mCallInfoCache.getCallInfo(callStatement);
        List<OctDomainState> list = new ArrayList<OctDomainState>();
        list.add((OctDomainState)octDomainState.addVariables(callInfo.getTempInParams()));
        list = OctPostOperator.deepCopy(list);
        AssignmentStatement assignmentStatement = callInfo.getInParamAssign();
        AssignmentStatement assignmentStatement2 = callInfo.getOldVarAssign((Set<IProgramVarOrConst>)octDomainState3.getVariables());
        if (assignmentStatement != null) {
            int n = 0;
            while (n < assignmentStatement.getRhs().length) {
                list = this.mStatementProcessor.processSingleAssignment(callInfo.getTempInParams().get(n), assignmentStatement.getRhs()[n], list);
                ++n;
            }
        }
        if (assignmentStatement2 != null) {
            list = this.mStatementProcessor.processStatement((Statement)assignmentStatement2, list);
        }
        ArrayList<OctDomainState> arrayList = new ArrayList<OctDomainState>();
        list.forEach(octDomainState2 -> {
            boolean bl = arrayList.add(octDomainState3.copyValuesOnScopeChange((OctDomainState)octDomainState2, callInfo.getInParam2TmpVars(), true));
        });
        return arrayList;
    }

    private List<OctDomainState> applyReturn(OctDomainState octDomainState, OctDomainState octDomainState2, CallStatement callStatement) {
        ArrayList<OctDomainState> arrayList = new ArrayList<OctDomainState>();
        if (!octDomainState2.isBottom()) {
            Procedure procedure = this.calledProcedure(callStatement);
            List<Pair<IProgramVarOrConst, IProgramVarOrConst>> list = this.generateMapCallLhsToOutParams(callStatement.getLhs(), procedure);
            octDomainState2 = octDomainState2.copyValuesOnScopeChange(octDomainState, list, false);
            arrayList.add(octDomainState2);
        }
        return arrayList;
    }

    private Procedure calledProcedure(CallStatement callStatement) {
        List list = this.mSymbolTable.getFunctionOrProcedureDeclaration(callStatement.getMethodName());
        Procedure procedure = null;
        for (Declaration declaration : list) {
            assert (declaration instanceof Procedure) : "call/return of non-procedure " + callStatement.getMethodName() + ": " + String.valueOf(declaration);
            Procedure procedure2 = (Procedure)declaration;
            if (procedure2.getBody() == null) continue;
            if (procedure != null) {
                throw new UnsupportedOperationException("Multiple implementations of " + callStatement.getMethodName());
            }
            procedure = procedure2;
        }
        if (procedure == null) {
            throw new UnsupportedOperationException("Missing implementation of " + callStatement.getMethodName());
        }
        return procedure;
    }

    private List<Pair<IProgramVarOrConst, IProgramVarOrConst>> generateMapCallLhsToOutParams(VariableLHS[] variableLHSArray, Procedure procedure) {
        ArrayList<Pair<IProgramVarOrConst, IProgramVarOrConst>> arrayList = new ArrayList<Pair<IProgramVarOrConst, IProgramVarOrConst>>(variableLHSArray.length);
        int n = 0;
        VarList[] varListArray = procedure.getOutParams();
        int n2 = varListArray.length;
        int n3 = 0;
        while (n3 < n2) {
            VarList varList = varListArray[n3];
            String[] stringArray = varList.getIdentifiers();
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String string = stringArray[n5];
                assert (n < variableLHSArray.length) : "missing left hand side for out-parameter";
                VariableLHS variableLHS = variableLHSArray[n];
                IProgramVar iProgramVar = this.mBpl2SmtTable.getBoogieVar(variableLHS.getIdentifier(), variableLHS.getDeclarationInformation(), false);
                assert (iProgramVar != null);
                IProgramVar iProgramVar2 = this.mBpl2SmtTable.getBoogieVar(string, procedure.getIdentifier(), false);
                assert (iProgramVar2 != null);
                arrayList.add((Pair<IProgramVarOrConst, IProgramVarOrConst>)new Pair((Object)iProgramVar, (Object)iProgramVar2));
                ++n;
                ++n5;
            }
            ++n3;
        }
        assert (n == variableLHSArray.length) : "missing out-parameter for left hand side";
        return arrayList;
    }

    IProgramVar getBoogieVar(VariableLHS variableLHS) {
        IProgramVar iProgramVar = this.getBoogie2SmtSymbolTable().getBoogieVar(variableLHS.getIdentifier(), variableLHS.getDeclarationInformation(), false);
        if (iProgramVar == null) {
            String string = variableLHS.getIdentifier().replaceAll("old\\((.*)\\)", "$1");
            iProgramVar = this.getBoogie2SmtSymbolTable().getBoogieVar(string, variableLHS.getDeclarationInformation(), false);
            iProgramVar = ((ProgramNonOldVar)iProgramVar).getOldVar();
        }
        assert (iProgramVar != null) : "Unknown Boogie var: " + variableLHS.getIdentifier();
        return iProgramVar;
    }

    IProgramVarOrConst getBoogieVar(IdentifierExpression identifierExpression) {
        IProgramVar iProgramVar = this.getBoogie2SmtSymbolTable().getBoogieVar(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation(), false);
        if (iProgramVar != null) {
            return iProgramVar;
        }
        iProgramVar = this.getBoogie2SmtSymbolTable().getBoogieConst(identifierExpression.getIdentifier());
        assert (iProgramVar != null);
        return iProgramVar;
    }

    public IAbstractPostOperator.EvalResult evaluate(OctDomainState octDomainState, Term term, Script script) {
        return octDomainState.evaluate(script, term);
    }
}

