/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import java.util.Comparator;
import java.util.Map;

public class CanonicalPartialComparatorForMaps<K, V>
implements IPartialComparator<Map<K, V>> {
    private final IPartialComparator<V> mComparator;

    public CanonicalPartialComparatorForMaps(IPartialComparator<V> iPartialComparator) {
        this.mComparator = iPartialComparator;
    }

    public CanonicalPartialComparatorForMaps(Comparator<V> comparator, boolean bl) {
        this(IPartialComparator.fromNonPartialComparator(comparator, bl));
    }

    public CanonicalPartialComparatorForMaps(Comparator<V> comparator) {
        this(comparator, true);
    }

    @Override
    public IPartialComparator.ComparisonResult compare(Map<K, V> map, Map<K, V> map2) {
        if (map == map2) {
            return IPartialComparator.ComparisonResult.EQUAL;
        }
        if (map.size() > map2.size()) {
            return this.compare(map2, map).invert();
        }
        IPartialComparator.ComparisonResult comparisonResult = IPartialComparator.ComparisonResult.EQUAL;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v = map2.get(entry.getKey());
            IPartialComparator.ComparisonResult comparisonResult2 = v == null ? IPartialComparator.ComparisonResult.STRICTLY_GREATER : this.mComparator.compare(entry.getValue(), v);
            if ((comparisonResult = IPartialComparator.ComparisonResult.aggregate(comparisonResult, comparisonResult2)) != IPartialComparator.ComparisonResult.INCOMPARABLE) continue;
            return comparisonResult;
        }
        if (comparisonResult == IPartialComparator.ComparisonResult.EQUAL && map.size() < map2.size()) {
            comparisonResult = IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
        } else if (comparisonResult == IPartialComparator.ComparisonResult.STRICTLY_GREATER && !map.keySet().containsAll(map2.keySet())) {
            comparisonResult = IPartialComparator.ComparisonResult.INCOMPARABLE;
        }
        return comparisonResult;
    }
}

