/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.RunConstructor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.StateContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.Summary;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.ITransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class LassoConstructor<LETTER, STATE> {
    private final AutomataLibraryServices mServices;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mNwars;
    private final StateContainer<LETTER, STATE> mGoal;
    private final Set<StateContainer<LETTER, STATE>> mVisited = new HashSet<StateContainer<LETTER, STATE>>();
    private final ArrayList<Map<StateContainer<LETTER, STATE>, SuccessorInfo>> mSuccInfos = new ArrayList();
    private final StronglyConnectedComponent<StateContainer<LETTER, STATE>> mScc;
    private final boolean mFindAcceptingSummary;
    private int mIteration;
    private boolean mGoalFound;
    private NestedRun<LETTER, STATE> mLoop;
    private final NestedRun<LETTER, STATE> mStem;
    private final NestedLassoRun<LETTER, STATE> mLasso;

    public LassoConstructor(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, StateContainer<LETTER, STATE> stateContainer, StronglyConnectedComponent<StateContainer<LETTER, STATE>> stronglyConnectedComponent) throws AutomataOperationCanceledException {
        this(automataLibraryServices, nestedWordAutomatonReachableStates, stateContainer, null, stronglyConnectedComponent, false);
    }

    public LassoConstructor(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, Summary<LETTER, STATE> summary, StronglyConnectedComponent<StateContainer<LETTER, STATE>> stronglyConnectedComponent) throws AutomataOperationCanceledException {
        this(automataLibraryServices, nestedWordAutomatonReachableStates, summary.getSucc(), summary, stronglyConnectedComponent, true);
    }

    private LassoConstructor(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, StateContainer<LETTER, STATE> stateContainer, Summary<LETTER, STATE> summary, StronglyConnectedComponent<StateContainer<LETTER, STATE>> stronglyConnectedComponent, boolean bl) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mNwars = nestedWordAutomatonReachableStates;
        this.mGoal = stateContainer;
        this.mScc = stronglyConnectedComponent;
        this.mFindAcceptingSummary = bl;
        this.mIteration = 0;
        HashMap<StateContainer<LETTER, STATE>, SuccessorInfo> hashMap = new HashMap<StateContainer<LETTER, STATE>, SuccessorInfo>();
        this.mSuccInfos.add(hashMap);
        if (bl) {
            SuccessorInfo successorInfo = new SuccessorInfo(summary.obtainIncomingReturnTransition(this.mNwars), this.mGoal);
            hashMap.put(summary.getHierPred(), successorInfo);
        } else {
            this.addPredecessors(this.mGoal, hashMap);
        }
        this.findRunBackwards();
        this.constructRunOfLoop();
        this.mStem = new RunConstructor<LETTER, STATE>(this.mServices, this.mNwars, this.mGoal).constructRun();
        this.mLasso = new NestedLassoRun<LETTER, STATE>(this.mStem, this.mLoop);
    }

    private void findRunBackwards() {
        while (!this.mGoalFound) {
            if (this.mIteration > this.mScc.getNumberOfStates()) {
                throw new AssertionError((Object)"unable to find state in SCC");
            }
            assert (this.mSuccInfos.size() == this.mIteration + 1);
            ++this.mIteration;
            HashMap<StateContainer<LETTER, STATE>, SuccessorInfo> hashMap = new HashMap<StateContainer<LETTER, STATE>, SuccessorInfo>();
            this.mSuccInfos.add(hashMap);
            for (StateContainer<LETTER, STATE> stateContainer : this.mSuccInfos.get(this.mIteration - 1).keySet()) {
                this.addPredecessors(stateContainer, hashMap);
            }
        }
    }

    private void constructRunOfLoop() throws AutomataOperationCanceledException {
        this.mLoop = new NestedRun(this.mGoal.getState());
        StateContainer<LETTER, STATE> stateContainer = this.mGoal;
        int n = this.mIteration;
        while (n >= 0) {
            NestedRun nestedRun;
            SuccessorInfo successorInfo = this.mSuccInfos.get(n).get(stateContainer);
            if (successorInfo.getTransition() instanceof IncomingInternalTransition) {
                var5_5 = (IncomingInternalTransition)successorInfo.getTransition();
                nestedRun = new NestedRun(stateContainer.getState(), ((IncomingInternalTransition)var5_5).getLetter(), -2, successorInfo.getSuccessor().getState());
            } else if (successorInfo.getTransition() instanceof IncomingCallTransition) {
                var5_5 = (IncomingCallTransition)successorInfo.getTransition();
                nestedRun = new NestedRun(stateContainer.getState(), ((IncomingCallTransition)var5_5).getLetter(), Integer.MAX_VALUE, successorInfo.getSuccessor().getState());
            } else if (successorInfo.getTransition() instanceof IncomingReturnTransition) {
                var5_5 = (IncomingReturnTransition)successorInfo.getTransition();
                StateContainer<LETTER, STATE> stateContainer2 = this.mNwars.obtainStateContainer(((IncomingReturnTransition)var5_5).getLinPred());
                assert (stateContainer.getState().equals(((IncomingReturnTransition)var5_5).getHierPred()));
                Summary<LETTER, STATE> summary = new Summary<LETTER, STATE>(stateContainer, stateContainer2, ((IncomingReturnTransition)var5_5).getLetter(), successorInfo.getSuccessor());
                boolean bl = this.mFindAcceptingSummary && n == 0;
                nestedRun = new RunConstructor<LETTER, STATE>(this.mServices, this.mNwars, summary, bl).constructRun();
                assert (nestedRun != null) : "no run for summary found";
            } else {
                throw new AssertionError((Object)"unsupported transition");
            }
            this.mLoop = this.mLoop.concatenate(nestedRun);
            stateContainer = successorInfo.getSuccessor();
            --n;
        }
    }

    public NestedLassoRun<LETTER, STATE> getNestedLassoRun() {
        return this.mLasso;
    }

    private void addPredecessors(StateContainer<LETTER, STATE> stateContainer, Map<StateContainer<LETTER, STATE>, SuccessorInfo> map) {
        StateContainer<LETTER, STATE> stateContainer2;
        for (IncomingReturnTransition<LETTER, STATE> iTransitionlet : this.mNwars.returnPredecessors(stateContainer.getState())) {
            stateContainer2 = this.mNwars.obtainStateContainer(iTransitionlet.getHierPred());
            this.checkAndAddPredecessor(stateContainer, map, iTransitionlet, stateContainer2);
        }
        for (IncomingCallTransition incomingCallTransition : this.mNwars.callPredecessors(stateContainer.getState())) {
            stateContainer2 = this.mNwars.obtainStateContainer(incomingCallTransition.getPred());
            this.checkAndAddPredecessor(stateContainer, map, incomingCallTransition, stateContainer2);
        }
        for (IncomingInternalTransition incomingInternalTransition : this.mNwars.internalPredecessors(stateContainer.getState())) {
            stateContainer2 = this.mNwars.obtainStateContainer(incomingInternalTransition.getPred());
            this.checkAndAddPredecessor(stateContainer, map, incomingInternalTransition, stateContainer2);
        }
    }

    private void checkAndAddPredecessor(StateContainer<LETTER, STATE> stateContainer, Map<StateContainer<LETTER, STATE>, SuccessorInfo> map, ITransitionlet<LETTER, STATE> iTransitionlet, StateContainer<LETTER, STATE> stateContainer2) {
        if (this.mScc.getNodes().contains(stateContainer2) && !this.mVisited.contains(stateContainer2)) {
            this.mVisited.add(stateContainer2);
            SuccessorInfo successorInfo = new SuccessorInfo(iTransitionlet, stateContainer);
            map.put(stateContainer2, successorInfo);
            if (this.mGoal.equals(stateContainer2)) {
                this.mGoalFound = true;
            }
        }
    }

    private class SuccessorInfo {
        private final ITransitionlet<LETTER, STATE> mTransition;
        private final StateContainer<LETTER, STATE> mSuccessor;

        public SuccessorInfo(ITransitionlet<LETTER, STATE> iTransitionlet, StateContainer<LETTER, STATE> stateContainer) {
            this.mTransition = iTransitionlet;
            this.mSuccessor = stateContainer;
        }

        public ITransitionlet<LETTER, STATE> getTransition() {
            return this.mTransition;
        }

        public StateContainer<LETTER, STATE> getSuccessor() {
            return this.mSuccessor;
        }
    }
}

