/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize.LocalizeException;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize.LocalizeWriter;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.TermToZCDDVisitor;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.ZTerm;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.ZWrapper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.print.oz.PrintUtils;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.Exists1Pred;
import net.sourceforge.czt.z.ast.ExistsPred;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.FalsePred;
import net.sourceforge.czt.z.ast.ForallPred;
import net.sourceforge.czt.z.ast.IffPred;
import net.sourceforge.czt.z.ast.ImpliesPred;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.NumExpr;
import net.sourceforge.czt.z.ast.ParenAnn;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.StrokeList;
import net.sourceforge.czt.z.ast.TruePred;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.impl.ZFactoryImpl;
import net.sourceforge.czt.z.util.OperatorName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.ApplExprVisitor;
import net.sourceforge.czt.z.visitor.Exists1PredVisitor;
import net.sourceforge.czt.z.visitor.ExistsPredVisitor;
import net.sourceforge.czt.z.visitor.ExprPredVisitor;
import net.sourceforge.czt.z.visitor.FalsePredVisitor;
import net.sourceforge.czt.z.visitor.ForallPredVisitor;
import net.sourceforge.czt.z.visitor.IffPredVisitor;
import net.sourceforge.czt.z.visitor.ImpliesPredVisitor;
import net.sourceforge.czt.z.visitor.MemPredVisitor;
import net.sourceforge.czt.z.visitor.NegPredVisitor;
import net.sourceforge.czt.z.visitor.NumExprVisitor;
import net.sourceforge.czt.z.visitor.TruePredVisitor;

public class LocalizeZVisitor
implements TermVisitor<StringBuffer>,
ForallPredVisitor<StringBuffer>,
NegPredVisitor<StringBuffer>,
NumExprVisitor<StringBuffer>,
ExistsPredVisitor<StringBuffer>,
Exists1PredVisitor<StringBuffer>,
ExprPredVisitor<StringBuffer>,
FalsePredVisitor<StringBuffer>,
TruePredVisitor<StringBuffer>,
ImpliesPredVisitor<StringBuffer>,
IffPredVisitor<StringBuffer>,
MemPredVisitor<StringBuffer>,
ApplExprVisitor<StringBuffer> {
    protected static final String MEMBERSHIP_PREDICATE = "Membership predicate";
    protected SectionInfo sectionInfo;
    protected Set<String> constants;
    protected Map<String, String> declarations;
    protected TermToZCDDVisitor toCDDVisitor;
    protected int quantificationLevel;
    protected LocalizeWriter localizeWriter;
    private final Map<String, Integer> freeTypes;
    private final Map<String, String> nullPointers;
    private final boolean useClausesForm;

    public LocalizeZVisitor(ZTerm zTerm, Set<String> set, Map<String, String> map, Map<String, Integer> map2, Map<String, String> map3, LocalizeWriter localizeWriter, boolean bl) {
        this.sectionInfo = zTerm.getSectionInfo();
        this.toCDDVisitor = new TermToZCDDVisitor(zTerm);
        this.constants = set;
        this.declarations = map;
        this.freeTypes = map2;
        this.nullPointers = map3;
        this.localizeWriter = localizeWriter;
        this.useClausesForm = bl;
        this.quantificationLevel = 0;
    }

    public LocalizeZVisitor(ZTerm zTerm, Set<String> set, Map<String, String> map, Map<String, Integer> map2, Map<String, String> map3, LocalizeWriter localizeWriter) {
        this(zTerm, set, map, map2, map3, localizeWriter, true);
    }

    public StringBuffer visitTerm(Term term) {
        this.removePrimesFromConstants(term);
        StringWriter stringWriter = new StringWriter();
        PrintUtils.print((Term)term, (Writer)stringWriter, (SectionManager)((SectionManager)this.sectionInfo), (String)ZWrapper.getSectionName(), (Markup)Markup.UNICODE);
        String string = stringWriter.toString().trim();
        for (String string2 : this.nullPointers.keySet()) {
            if (!string.contains(string2)) continue;
            string = string.replace(string2, this.nullPointers.get(string2));
        }
        return new StringBuffer(string);
    }

    private void removePrimesFromConstants(Term term) {
        ZName zName;
        if (term instanceof RefExpr && (zName = ((RefExpr)term).getZName()).getWord().startsWith("_")) {
            zName.setWord(zName.getWord().substring(1));
        }
        if (term instanceof ZName) {
            zName = (ZName)term;
            if (this.constants.contains(zName.getWord())) {
                zName.setStrokeList((StrokeList)new ZFactoryImpl().createZStrokeList());
            }
        } else {
            ZName zName2 = zName = term.getChildren();
            int n = ((Object[])zName).length;
            int n2 = 0;
            while (n2 < n) {
                Object object = zName2[n2];
                if (object instanceof Term) {
                    this.removePrimesFromConstants((Term)object);
                }
                ++n2;
            }
        }
    }

    public StringBuffer visitForallPred(ForallPred forallPred) {
        Object object;
        Object object22;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (++this.quantificationLevel > 1) {
            --this.quantificationLevel;
            throw new LocalizeException("Nested quantified expression not supported by localize export!");
        }
        stringBuffer.append("(FORALL ");
        ZSchText zSchText = forallPred.getZSchText();
        int n = zSchText.getZDeclList().size();
        for (Object object22 : zSchText.getZDeclList()) {
            --n;
            if (!(object22 instanceof VarDecl)) continue;
            int n2 = ((VarDecl)object22).getZNameList().size();
            Expr expr = ((VarDecl)object22).getExpr();
            object = ((StringBuffer)expr.accept((Visitor)this)).toString().trim();
            if (!(this.declarations.containsValue(object) || ((String)object).equals("\u211d") || ((String)object).equals(ZString.NUM) || this.freeTypes.containsKey(object))) {
                throw new LocalizeException("Unsupported type in quantification(use \u211d, " + ZString.NUM + " or a free type): " + (String)object);
            }
            for (Name name : ((VarDecl)object22).getZNameList()) {
                stringBuffer.append(name);
                if (n <= 0 && --n2 <= 0) continue;
                stringBuffer.append(",");
            }
        }
        stringBuffer.append("). ");
        object22 = CDD.TRUE;
        if (zSchText.getPred() != null) {
            object22 = (CDD)zSchText.getPred().accept((Visitor)this.toCDDVisitor);
        }
        CDD cDD = ((CDD)object22).negate().or((CDD)forallPred.getPred().accept((Visitor)this.toCDDVisitor));
        CDD[] cDDArray = cDD.toCNF();
        int n3 = 0;
        while (n3 < cDDArray.length) {
            if (n3 != 0) {
                stringBuffer2.append("           ");
            }
            stringBuffer2.append(stringBuffer);
            object = new StringWriter();
            if (this.useClausesForm) {
                this.localizeWriter.writeClauseToWriter(cDDArray[n3], (Writer)object);
            } else {
                this.localizeWriter.writeClauseAsDisjunction(cDDArray[n3], (Writer)object);
            }
            stringBuffer2.append(object);
            if (n3 + 1 < cDDArray.length) {
                stringBuffer2.append(";\n");
            }
            ++n3;
        }
        --this.quantificationLevel;
        return stringBuffer2;
    }

    public StringBuffer visitNegPred(NegPred negPred) {
        StringBuffer stringBuffer = new StringBuffer("NOT").append("(");
        stringBuffer.append((StringBuffer)negPred.getPred().accept((Visitor)this)).append(")");
        return stringBuffer;
    }

    public StringBuffer visitExistsPred(ExistsPred existsPred) {
        throw new LocalizeException("Predicate type not supported by localize export: " + String.valueOf(ExistsPred.class) + "\n" + existsPred.toString());
    }

    public StringBuffer visitExists1Pred(Exists1Pred exists1Pred) {
        throw new LocalizeException("Predicate type not supported by localize export: " + String.valueOf(Exists1Pred.class) + "\n" + exists1Pred.toString());
    }

    public StringBuffer visitExprPred(ExprPred exprPred) {
        StringWriter stringWriter = new StringWriter();
        PrintUtils.print((Term)exprPred, (Writer)stringWriter, (SectionManager)((SectionManager)this.sectionInfo), (String)ZWrapper.getSectionName(), (Markup)Markup.UNICODE);
        throw new LocalizeException("Unexcepted expression in Localize export (predicate expected): \n" + stringWriter.toString());
    }

    public StringBuffer visitFalsePred(FalsePred falsePred) {
        throw new LocalizeException("Predicate type not supported by localize export: " + String.valueOf(FalsePred.class) + "\n" + falsePred.toString());
    }

    public StringBuffer visitTruePred(TruePred truePred) {
        return new StringBuffer("");
    }

    public StringBuffer visitImpliesPred(ImpliesPred impliesPred) {
        throw new LocalizeException("Predicate type not supported by localize export: " + String.valueOf(ImpliesPred.class) + "\n" + impliesPred.toString());
    }

    public StringBuffer visitIffPred(IffPred iffPred) {
        throw new LocalizeException("Predicate type not supported by localize export: " + String.valueOf(IffPred.class) + "\n" + iffPred.toString());
    }

    public StringBuffer visitMemPred(MemPred memPred) {
        if (!memPred.getMixfix().booleanValue()) {
            throw new LocalizeException("Predicate type not supported by localize export: Membership predicate\n" + memPred.toString());
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (memPred.getRightExpr() instanceof SetExpr) {
            stringBuffer.append((StringBuffer)memPred.getLeftExpr().accept((Visitor)this));
            stringBuffer.append("=");
            SetExpr setExpr = (SetExpr)memPred.getRightExpr();
            for (Expr expr : setExpr.getZExprList()) {
                stringBuffer.append((StringBuffer)expr.accept((Visitor)this));
            }
        } else {
            if (memPred.getRightExpr() instanceof RefExpr) {
                OperatorName operatorName = ((RefExpr)memPred.getRightExpr()).getZName().getOperatorName();
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    String[] stringArray = operatorName.getWords();
                    if (!operatorName.isUnary() && memPred.getLeftExpr() instanceof TupleExpr) {
                        Iterator iterator = ((TupleExpr)memPred.getLeftExpr()).getZExprList().iterator();
                        int n = 0;
                        while (n < stringArray.length) {
                            if (stringArray[n].equals(ZString.ARG)) {
                                stringBuilder.append((StringBuffer)((Expr)iterator.next()).accept((Visitor)this));
                            } else if (stringArray[n].equals(ZString.NEQ)) {
                                stringBuffer.append("NOT(");
                                stringBuilder2.append(")");
                                stringBuilder.append("=");
                            } else {
                                stringBuilder.append(LocalizeWriter.operatorFor(stringArray[n]));
                            }
                            ++n;
                        }
                    } else {
                        int n = 0;
                        while (n < stringArray.length) {
                            if (stringArray[n].equals(ZString.ARG)) {
                                stringBuilder.append((StringBuffer)memPred.getLeftExpr().accept((Visitor)this));
                            } else if (stringArray[n].equals(ZString.NEQ)) {
                                stringBuffer.append("NOT(");
                                stringBuilder2.append(")");
                                stringBuilder.append("=");
                            } else {
                                stringBuilder.append(LocalizeWriter.operatorFor(stringArray[n]));
                            }
                            ++n;
                        }
                    }
                    stringBuffer.append((CharSequence)stringBuilder).append((CharSequence)stringBuilder2);
                }
                catch (NoSuchElementException noSuchElementException) {
                    noSuchElementException.printStackTrace();
                    throw new LocalizeException("Malformed operator application: \n" + String.valueOf(operatorName));
                }
            }
            throw new LocalizeException("Unexpected predicate during Localize export: \n" + memPred.getRightExpr().toString());
        }
        return stringBuffer;
    }

    public StringBuffer visitApplExpr(ApplExpr applExpr) {
        StringBuffer stringBuffer = new StringBuffer();
        if (applExpr.getMixfix().booleanValue() && applExpr.getRightExpr() instanceof TupleExpr) {
            OperatorName operatorName = ((RefExpr)applExpr.getLeftExpr()).getZName().getOperatorName();
            String[] stringArray = operatorName.getWords();
            Iterator iterator = ((TupleExpr)applExpr.getRightExpr()).getZExprList().iterator();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(ZString.ARG)) {
                    Expr expr = (Expr)iterator.next();
                    if (expr instanceof ApplExpr && ((ApplExpr)expr).getMixfix().booleanValue()) {
                        stringBuffer.append("(");
                        stringBuffer.append((StringBuffer)expr.accept((Visitor)this));
                        stringBuffer.append(")");
                    } else {
                        stringBuffer.append((StringBuffer)expr.accept((Visitor)this));
                    }
                } else if (stringArray[n].equals("div")) {
                    stringBuffer.append("/");
                } else {
                    stringBuffer.append(stringArray[n].trim());
                }
                ++n;
            }
        } else {
            stringBuffer.append((StringBuffer)applExpr.getLeftExpr().accept((Visitor)this));
            if (applExpr.getRightExpr().getAnn(ParenAnn.class) != null && applExpr.getRightExpr() instanceof RefExpr) {
                stringBuffer.append((StringBuffer)applExpr.getRightExpr().accept((Visitor)this));
            } else {
                stringBuffer.append("(" + String.valueOf(applExpr.getRightExpr().accept((Visitor)this)) + ")");
            }
        }
        return stringBuffer;
    }

    public StringBuffer visitNumExpr(NumExpr numExpr) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("_").append(numExpr.getValue());
        return stringBuffer;
    }
}

