/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import java.util.Collections;
import java.util.List;

public class Segmentation {
    private final List<IProgramVar> mBounds;
    private final List<IProgramVar> mValues;

    public Segmentation(List<IProgramVar> list, List<IProgramVar> list2) {
        if (list.size() != list2.size() + 1) {
            throw new IllegalArgumentException(String.format("Incompatible sizes of bounds (%d) and values (%d)", list.size(), list2.size()));
        }
        this.mBounds = list;
        this.mValues = list2;
    }

    public List<IProgramVar> getBounds() {
        return Collections.unmodifiableList(this.mBounds);
    }

    public List<IProgramVar> getValues() {
        return Collections.unmodifiableList(this.mValues);
    }

    public IProgramVar getBound(int n) {
        return this.mBounds.get(n);
    }

    public IProgramVar getValue(int n) {
        return this.mValues.get(n);
    }

    public int size() {
        return this.mValues.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.size()) {
            stringBuilder.append('[').append(this.getBound(n)).append("] ");
            stringBuilder.append(this.getValue(n)).append(' ');
            ++n;
        }
        stringBuilder.append('[').append(this.getBound(this.size())).append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.mBounds.hashCode() + this.mValues.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Segmentation segmentation = (Segmentation)object;
        return this.mBounds.equals(segmentation.mBounds) && this.mValues.equals(segmentation.mValues);
    }
}

