/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class CallInfoCache {
    private final Map<CallStatement, CallInfo> mCall2CallInfo = new HashMap<CallStatement, CallInfo>();
    private final CfgSmtToolkit mCfgSmtToolkit;
    private final BoogieSymbolTable mSymbolTable;
    private final IIcfgSymbolTable mIcfgSymbolTable;

    public CallInfoCache(CfgSmtToolkit cfgSmtToolkit, BoogieSymbolTable boogieSymbolTable) {
        this.mCfgSmtToolkit = cfgSmtToolkit;
        this.mSymbolTable = boogieSymbolTable;
        this.mIcfgSymbolTable = cfgSmtToolkit.getSymbolTable();
    }

    public CallInfo getCallInfo(CallStatement callStatement) {
        CallInfo callInfo = this.mCall2CallInfo.get(callStatement);
        if (callInfo != null) {
            return callInfo;
        }
        CallInfo callInfo2 = this.createCallInfo(callStatement);
        this.mCall2CallInfo.put(callStatement, callInfo2);
        return callInfo2;
    }

    private CallInfo createCallInfo(CallStatement callStatement) {
        Expression[] expressionArray = callStatement.getArguments();
        List<IProgramVarOrConst> list = this.getInParams(callStatement);
        Map<IProgramVarOrConst, Pair<VariableLHS, IdentifierExpression>> map = this.getOldvarAssignMap(callStatement);
        if (expressionArray.length == 0) {
            return new CallInfo(list, map);
        }
        List<String> list2 = CallInfoCache.getArgumentTemporaries(expressionArray.length, this.getForbiddenNames(callStatement.getMethodName()));
        ArrayList<VariableLHS> arrayList = new ArrayList<VariableLHS>();
        HashMap<LeftHandSide, IProgramVarOrConst> hashMap = new HashMap<LeftHandSide, IProgramVarOrConst>();
        ArrayList<IProgramVarOrConst> arrayList2 = new ArrayList<IProgramVarOrConst>();
        ILocation iLocation = callStatement.getLocation();
        int n = 0;
        while (n < expressionArray.length) {
            String string = list2.get(n);
            IProgramVar iProgramVar = AbsIntUtil.createTemporaryIBoogieVar(string, expressionArray[n].getType());
            VariableLHS variableLHS = new VariableLHS(iLocation, string);
            arrayList2.add((IProgramVarOrConst)iProgramVar);
            hashMap.put((LeftHandSide)variableLHS, (IProgramVarOrConst)iProgramVar);
            arrayList.add(variableLHS);
            ++n;
        }
        AssignmentStatement assignmentStatement = new AssignmentStatement(iLocation, arrayList.toArray(new LeftHandSide[arrayList.size()]), expressionArray);
        return new CallInfo(list, map, assignmentStatement, arrayList2, hashMap);
    }

    private static List<String> getArgumentTemporaries(int n, Set<String> set) {
        int n2;
        String string;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        StringBuilder stringBuilder = new StringBuilder("param_");
        boolean bl = false;
        while (!bl) {
            string = stringBuilder.toString();
            n2 = 0;
            while (n2 < n) {
                String string2 = string + String.valueOf(n2);
                if (set.contains(string2)) {
                    stringBuilder.append('_');
                    break;
                }
                ++n2;
            }
            bl = true;
        }
        string = stringBuilder.toString();
        n2 = 0;
        while (n2 < n) {
            arrayList.add(string + String.valueOf(n2));
            ++n2;
        }
        return arrayList;
    }

    private Map<IProgramVarOrConst, Pair<VariableLHS, IdentifierExpression>> getOldvarAssignMap(CallStatement callStatement) {
        Set set = this.mCfgSmtToolkit.getSymbolTable().getGlobals();
        int n = set.size();
        if (n == 0) {
            return null;
        }
        ILocation iLocation = callStatement.getLocation();
        HashMap<IProgramVarOrConst, Pair<VariableLHS, IdentifierExpression>> hashMap = new HashMap<IProgramVarOrConst, Pair<VariableLHS, IdentifierExpression>>();
        for (IProgramNonOldVar iProgramNonOldVar : set) {
            DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null);
            IBoogieType iBoogieType = this.mSymbolTable.getTypeForVariableSymbol(iProgramNonOldVar.getGloballyUniqueId(), DeclarationInformation.StorageClass.GLOBAL, null);
            Pair pair = new Pair((Object)new VariableLHS(iLocation, iBoogieType, iProgramNonOldVar.getOldVar().getGloballyUniqueId(), declarationInformation), (Object)new IdentifierExpression(iLocation, iBoogieType, iProgramNonOldVar.getGloballyUniqueId(), declarationInformation));
            hashMap.put((IProgramVarOrConst)iProgramNonOldVar, (Pair<VariableLHS, IdentifierExpression>)pair);
        }
        return hashMap;
    }

    private List<IProgramVarOrConst> getInParams(CallStatement callStatement) {
        Procedure procedure = this.getProcedure(callStatement.getMethodName());
        assert (procedure != null);
        VarList[] varListArray = procedure.getInParams();
        ArrayList<IProgramVarOrConst> arrayList = new ArrayList<IProgramVarOrConst>();
        Map<String, ILocalProgramVar> map = this.getName2Locals(callStatement.getMethodName());
        VarList[] varListArray2 = varListArray;
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray2[n2];
            String[] stringArray = varList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                IProgramVarOrConst iProgramVarOrConst = (IProgramVarOrConst)map.get(string);
                assert (iProgramVarOrConst != null);
                arrayList.add(iProgramVarOrConst);
                ++n4;
            }
            ++n2;
        }
        if (callStatement.getArguments().length != arrayList.size()) {
            throw new UnsupportedOperationException("The number of the expressions in the call statement arguments does not correspond to the length of the number of arguments in the symbol table.");
        }
        return arrayList;
    }

    private Map<String, ILocalProgramVar> getName2Locals(String string) {
        Set set = this.mIcfgSymbolTable.getLocals(string);
        HashMap<String, ILocalProgramVar> hashMap = new HashMap<String, ILocalProgramVar>();
        for (ILocalProgramVar iLocalProgramVar : set) {
            hashMap.put(iLocalProgramVar.getIdentifier(), iLocalProgramVar);
        }
        return hashMap;
    }

    private Procedure getProcedure(String string) {
        return this.mSymbolTable.getFunctionOrProcedureDeclaration(string).stream().filter(declaration -> declaration instanceof Procedure).map(declaration -> (Procedure)declaration).filter(procedure -> procedure.getBody() != null).findFirst().orElseThrow(() -> new UnsupportedOperationException("Only uninterpreted functions available for " + string));
    }

    private Set<String> getForbiddenNames(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        this.mIcfgSymbolTable.getLocals(string).forEach(iLocalProgramVar -> {
            boolean bl = hashSet.add(iLocalProgramVar.getGloballyUniqueId());
        });
        this.mIcfgSymbolTable.getGlobals().forEach(iProgramNonOldVar -> {
            boolean bl = hashSet.add(iProgramNonOldVar.getGloballyUniqueId());
        });
        this.mIcfgSymbolTable.getConstants().forEach(iProgramConst -> {
            boolean bl = hashSet.add(iProgramConst.getGloballyUniqueId());
        });
        return hashSet;
    }

    public static final class CallInfo {
        private final AssignmentStatement mInParamAssign;
        private final List<IProgramVarOrConst> mTmpVars;
        private final Map<LeftHandSide, IProgramVarOrConst> mTmpVarUses;
        private final List<IProgramVarOrConst> mRealInParams;
        private final Map<IProgramVarOrConst, Pair<VariableLHS, IdentifierExpression>> mOldVarAssign;
        private final List<Pair<IProgramVarOrConst, IProgramVarOrConst>> mInParam2TmpVars;

        private CallInfo(List<IProgramVarOrConst> list, Map<IProgramVarOrConst, Pair<VariableLHS, IdentifierExpression>> map) {
            this(list, map, null, Collections.emptyList(), Collections.emptyMap());
        }

        private CallInfo(List<IProgramVarOrConst> list, Map<IProgramVarOrConst, Pair<VariableLHS, IdentifierExpression>> map, AssignmentStatement assignmentStatement, List<IProgramVarOrConst> list2, Map<LeftHandSide, IProgramVarOrConst> map2) {
            this.mOldVarAssign = map;
            this.mInParamAssign = assignmentStatement;
            this.mTmpVars = Collections.unmodifiableList(list2);
            this.mTmpVarUses = Collections.unmodifiableMap(map2);
            this.mRealInParams = Collections.unmodifiableList(list);
            assert (list.size() == list2.size());
            ArrayList<Pair> arrayList = new ArrayList<Pair>(list.size());
            int n = 0;
            while (n < list.size()) {
                arrayList.add(new Pair((Object)list.get(n), (Object)list2.get(n)));
                ++n;
            }
            this.mInParam2TmpVars = Collections.unmodifiableList(arrayList);
        }

        public List<IProgramVarOrConst> getRealInParams() {
            return this.mRealInParams;
        }

        public List<IProgramVarOrConst> getTempInParams() {
            return this.mTmpVars;
        }

        public Map<LeftHandSide, IProgramVarOrConst> getLhs2TmpVar() {
            return this.mTmpVarUses;
        }

        public List<Pair<IProgramVarOrConst, IProgramVarOrConst>> getInParam2TmpVars() {
            return this.mInParam2TmpVars;
        }

        public AssignmentStatement getInParamAssign() {
            return this.mInParamAssign;
        }

        public AssignmentStatement getOldVarAssign(Set<IProgramVarOrConst> set) {
            if (this.mOldVarAssign == null) {
                return null;
            }
            List list = this.mOldVarAssign.entrySet().stream().filter(entry -> set.contains(entry.getKey())).map(entry -> (Pair)entry.getValue()).collect(Collectors.toList());
            int n = list.size();
            if (n == 0) {
                return null;
            }
            ILocation iLocation = ((VariableLHS)((Pair)list.get(0)).getFirst()).getLocation();
            LeftHandSide[] leftHandSideArray = new LeftHandSide[n];
            Expression[] expressionArray = new Expression[n];
            int n2 = 0;
            for (Pair pair : list) {
                leftHandSideArray[n2] = (LeftHandSide)pair.getFirst();
                expressionArray[n2] = (Expression)pair.getSecond();
                ++n2;
            }
            return new AssignmentStatement(iLocation, leftHandSideArray, expressionArray);
        }
    }
}

