/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.MutableRational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.math.BigInteger;

public class Rational
implements Comparable<Rational> {
    int mNum;
    int mDenom;
    public static final Rational POSITIVE_INFINITY = new Rational(1, 0);
    public static final Rational NAN = new Rational(0, 0);
    public static final Rational NEGATIVE_INFINITY = new Rational(-1, 0);
    public static final Rational ZERO = new Rational(0, 1);
    public static final Rational ONE = new Rational(1, 1);
    public static final Rational MONE = new Rational(-1, 1);
    public static final Rational TWO = new Rational(2, 1);

    private Rational(int n, int n2) {
        this.mNum = n;
        this.mDenom = n2;
    }

    public static Rational valueOf(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        int n = bigInteger2.signum();
        if (n < 0) {
            bigInteger = bigInteger.negate();
            bigInteger2 = bigInteger2.negate();
        } else if (n == 0) {
            return Rational.valueOf(bigInteger.signum(), 0L);
        }
        if (!bigInteger2.equals(BigInteger.ONE) && !(bigInteger3 = Rational.gcd(bigInteger, bigInteger2).abs()).equals(BigInteger.ONE)) {
            bigInteger = bigInteger.divide(bigInteger3);
            bigInteger2 = bigInteger2.divide(bigInteger3);
        }
        if (bigInteger2.bitLength() < 32 && bigInteger.bitLength() < 32) {
            return Rational.valueOf(bigInteger.intValue(), bigInteger2.intValue());
        }
        return new BigRational(bigInteger, bigInteger2);
    }

    public static Rational valueOf(long l, long l2) {
        if (l2 != 1L) {
            long l3 = Math.abs(Rational.gcd(l, l2));
            if (l3 == 0L) {
                return NAN;
            }
            if (l2 < 0L) {
                l3 = -l3;
            }
            l /= l3;
            l2 /= l3;
        }
        if (l2 == 1L) {
            if (l == 0L) {
                return ZERO;
            }
            if (l == 1L) {
                return ONE;
            }
            if (l == -1L) {
                return MONE;
            }
        } else if (l2 == 0L) {
            if (l == 1L) {
                return POSITIVE_INFINITY;
            }
            return NEGATIVE_INFINITY;
        }
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE && l2 <= Integer.MAX_VALUE) {
            return new Rational((int)l, (int)l2);
        }
        return new BigRational(BigInteger.valueOf(l), BigInteger.valueOf(l2));
    }

    public static int gcd(int n, int n2) {
        while (n2 != 0) {
            int n3 = n % n2;
            n = n2;
            n2 = n3;
        }
        return n;
    }

    public static long gcd(long l, long l2) {
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (l == 0L || l2 == 1L) {
            return l2;
        }
        if (l2 == 0L || l == 1L) {
            return l;
        }
        int n = Long.numberOfTrailingZeros(l);
        int n2 = Long.numberOfTrailingZeros(l2);
        l >>= n;
        l2 >>= n2;
        while (l != l2) {
            long l3;
            if (l < l2) {
                l3 = l2 - l;
                l2 = l;
            } else {
                if (l2 == 1L) {
                    l = l2;
                    break;
                }
                l3 = l - l2;
            }
            while (((int)(l3 >>= 1) & 1) == 0) {
            }
            l = l3;
        }
        return l << Math.min(n, n2);
    }

    public static BigInteger gcd(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == BigInteger.ONE || bigInteger2 == BigInteger.ONE) {
            return BigInteger.ONE;
        }
        int n = bigInteger.bitLength();
        int n2 = bigInteger2.bitLength();
        if (n < 31 && n2 < 31) {
            return BigInteger.valueOf(Rational.gcd(bigInteger.intValue(), bigInteger2.intValue()));
        }
        if (n < 63 && n2 < 63) {
            return BigInteger.valueOf(Rational.gcd(bigInteger.longValue(), bigInteger2.longValue()));
        }
        return bigInteger.gcd(bigInteger2);
    }

    public Rational add(Rational rational) {
        if (rational == ZERO) {
            return this;
        }
        if (this == ZERO) {
            return rational;
        }
        if (rational instanceof BigRational) {
            return rational.add(this);
        }
        if (this.mDenom == rational.mDenom) {
            if (this.mDenom == 0) {
                return this.mNum == rational.mNum ? this : NAN;
            }
            return Rational.valueOf((long)this.mNum + (long)rational.mNum, this.mDenom);
        }
        int n = Rational.gcd(this.mDenom, rational.mDenom);
        long l = this.mDenom / n;
        long l2 = rational.mDenom / n;
        long l3 = l * (long)rational.mDenom;
        long l4 = l2 * (long)this.mNum + l * (long)rational.mNum;
        return Rational.valueOf(l4, l3);
    }

    public Rational addmul(Rational rational, Rational rational2) {
        return this.add(rational.mul(rational2));
    }

    public Rational subdiv(Rational rational, Rational rational2) {
        return this.sub(rational).div(rational2);
    }

    public Rational negate() {
        return Rational.valueOf(-((long)this.mNum), this.mDenom);
    }

    public Rational sub(Rational rational) {
        return this.add(rational.negate());
    }

    public Rational mul(Rational rational) {
        if (rational == ONE) {
            return this;
        }
        if (this == ONE) {
            return rational;
        }
        if (rational == MONE) {
            return this.negate();
        }
        if (this == MONE) {
            return rational.negate();
        }
        if (rational instanceof BigRational) {
            return rational.mul(this);
        }
        long l = (long)this.mNum * (long)rational.mNum;
        long l2 = (long)this.mDenom * (long)rational.mDenom;
        return Rational.valueOf(l, l2);
    }

    public Rational mul(BigInteger bigInteger) {
        if (bigInteger.bitLength() < 32) {
            int n = bigInteger.intValue();
            if (n == 1) {
                return this;
            }
            if (n == -1) {
                return this.negate();
            }
            long l = (long)this.mNum * (long)n;
            return Rational.valueOf(l, this.mDenom);
        }
        if (this == ONE) {
            return Rational.valueOf(bigInteger, BigInteger.ONE);
        }
        if (this == MONE) {
            return Rational.valueOf(bigInteger.negate(), BigInteger.ONE);
        }
        return Rational.valueOf(this.numerator().multiply(bigInteger), this.denominator());
    }

    public Rational div(Rational rational) {
        if (rational == ONE) {
            return this;
        }
        if (rational == MONE) {
            return this.negate();
        }
        if (rational instanceof BigRational) {
            return ((BigRational)rational).idiv(this);
        }
        long l = (long)this.mNum * (long)rational.mDenom;
        long l2 = (long)this.mDenom * (long)rational.mNum;
        if (l2 == 0L && rational.mNum < 0) {
            l = -l;
        }
        return Rational.valueOf(l, l2);
    }

    public Rational gcd(Rational rational) {
        if (this == ZERO) {
            return rational.abs();
        }
        if (rational == ZERO) {
            return this.abs();
        }
        if (rational instanceof BigRational) {
            return rational.gcd(this);
        }
        int n = Rational.gcd(this.mDenom, rational.mDenom);
        long l = (long)(this.mDenom / n) * (long)rational.mDenom;
        long l2 = Rational.gcd(this.mNum < 0 ? -((long)this.mNum) : (long)this.mNum, rational.mNum < 0 ? -((long)rational.mNum) : (long)rational.mNum);
        return Rational.valueOf(l2, l);
    }

    public Rational inverse() {
        return Rational.valueOf(this.mDenom, this.mNum);
    }

    public boolean isNegative() {
        return this.mNum < 0;
    }

    public int signum() {
        return this.mNum < 0 ? -1 : (this.mNum == 0 ? 0 : 1);
    }

    @Override
    public int compareTo(Rational rational) {
        if (rational instanceof BigRational) {
            return -rational.compareTo(this);
        }
        if (rational.mDenom == this.mDenom) {
            return this.mNum < rational.mNum ? -1 : (this.mNum == rational.mNum ? 0 : 1);
        }
        long l = (long)this.mNum * (long)rational.mDenom;
        long l2 = (long)rational.mNum * (long)this.mDenom;
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    public boolean equals(Object object) {
        if (object instanceof Rational) {
            if (object instanceof BigRational) {
                return false;
            }
            Rational rational = (Rational)object;
            return this.mNum == rational.mNum && this.mDenom == rational.mDenom;
        }
        if (object instanceof MutableRational) {
            return ((MutableRational)object).equals(this);
        }
        return false;
    }

    public BigInteger numerator() {
        return BigInteger.valueOf(this.mNum);
    }

    public BigInteger denominator() {
        return BigInteger.valueOf(this.mDenom);
    }

    public int hashCode() {
        return HashUtils.hashJenkins((int)this.mNum, (Object)this.mDenom);
    }

    public String toString() {
        if (this.mDenom == 0) {
            return this.mNum > 0 ? "inf" : (this.mNum == 0 ? "nan" : "-inf");
        }
        if (this.mDenom == 1) {
            return String.valueOf(this.mNum);
        }
        return this.mNum + "/" + this.mDenom;
    }

    public boolean isIntegral() {
        return this.mDenom <= 1;
    }

    public Rational floor() {
        if (this.mDenom <= 1) {
            return this;
        }
        int n = this.mNum / this.mDenom;
        if (this.mNum < 0) {
            --n;
        }
        return Rational.valueOf(n, 1L);
    }

    public Rational frac() {
        if (this.mDenom <= 1) {
            return ZERO;
        }
        int n = this.mNum % this.mDenom;
        if (n < 0) {
            n += this.mDenom;
        }
        return Rational.valueOf(n, this.mDenom);
    }

    public Rational ceil() {
        if (this.mDenom <= 1) {
            return this;
        }
        int n = this.mNum / this.mDenom;
        if (this.mNum > 0) {
            ++n;
        }
        return Rational.valueOf(n, 1L);
    }

    public Rational abs() {
        return Rational.valueOf(Math.abs((long)this.mNum), this.mDenom);
    }

    public Term toTerm(Sort sort) {
        return sort.getTheory().constant(this, sort);
    }

    public boolean isRational() {
        return this.mDenom != 0;
    }

    static class BigRational
    extends Rational {
        BigInteger mBignum;
        BigInteger mBigdenom;

        private BigRational(BigInteger bigInteger, BigInteger bigInteger2) {
            super(bigInteger.signum(), 1);
            this.mBignum = bigInteger;
            this.mBigdenom = bigInteger2;
        }

        @Override
        public Rational add(Rational rational) {
            BigInteger bigInteger;
            if (rational == ZERO) {
                return this;
            }
            BigInteger bigInteger2 = this.denominator();
            if (bigInteger2.equals(bigInteger = rational.denominator())) {
                return BigRational.valueOf(this.numerator().add(rational.numerator()), bigInteger2);
            }
            BigInteger bigInteger3 = bigInteger2.gcd(bigInteger);
            BigInteger bigInteger4 = bigInteger2.divide(bigInteger3);
            BigInteger bigInteger5 = bigInteger.divide(bigInteger3);
            BigInteger bigInteger6 = this.numerator().multiply(bigInteger5).add(rational.numerator().multiply(bigInteger4));
            BigInteger bigInteger7 = bigInteger2.multiply(bigInteger5);
            return BigRational.valueOf(bigInteger6, bigInteger7);
        }

        @Override
        public Rational negate() {
            return Rational.valueOf(this.mBignum.negate(), this.mBigdenom);
        }

        @Override
        public Rational mul(Rational rational) {
            if (rational == ONE) {
                return this;
            }
            if (rational == ZERO) {
                return rational;
            }
            if (rational == MONE) {
                return this.negate();
            }
            BigInteger bigInteger = this.numerator().multiply(rational.numerator());
            BigInteger bigInteger2 = this.denominator().multiply(rational.denominator());
            return BigRational.valueOf(bigInteger, bigInteger2);
        }

        @Override
        public Rational mul(BigInteger bigInteger) {
            if (bigInteger.bitLength() < 2) {
                int n = bigInteger.intValue();
                if (n == 1) {
                    return this;
                }
                if (n == -1) {
                    return this.negate();
                }
                if (n == 0) {
                    return ZERO;
                }
            }
            return BigRational.valueOf(this.numerator().multiply(bigInteger), this.denominator());
        }

        @Override
        public Rational div(Rational rational) {
            if (rational == ONE) {
                return this;
            }
            if (rational == MONE) {
                return this.negate();
            }
            BigInteger bigInteger = this.denominator().multiply(rational.numerator());
            BigInteger bigInteger2 = this.numerator().multiply(rational.denominator());
            if (bigInteger.equals(BigInteger.ZERO) && rational.numerator().signum() == -1) {
                bigInteger2 = bigInteger2.negate();
            }
            return BigRational.valueOf(bigInteger2, bigInteger);
        }

        public Rational idiv(Rational rational) {
            BigInteger bigInteger = this.denominator().multiply(rational.numerator());
            BigInteger bigInteger2 = this.numerator().multiply(rational.denominator());
            if (bigInteger2.equals(BigInteger.ZERO) && this.numerator().signum() == -1) {
                bigInteger = bigInteger.negate();
            }
            return BigRational.valueOf(bigInteger, bigInteger2);
        }

        @Override
        public Rational inverse() {
            return BigRational.valueOf(this.mBigdenom, this.mBignum);
        }

        @Override
        public Rational gcd(Rational rational) {
            if (rational == ZERO) {
                return this.abs();
            }
            BigInteger bigInteger = this.denominator();
            BigInteger bigInteger2 = rational.denominator();
            BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
            BigInteger bigInteger4 = bigInteger.divide(bigInteger3).multiply(bigInteger2);
            BigInteger bigInteger5 = this.numerator().gcd(rational.numerator());
            return Rational.valueOf(bigInteger5, bigInteger4);
        }

        @Override
        public int compareTo(Rational rational) {
            BigInteger bigInteger = this.numerator().multiply(rational.denominator());
            BigInteger bigInteger2 = rational.numerator().multiply(this.denominator());
            return bigInteger.compareTo(bigInteger2);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof BigRational) {
                BigRational bigRational = (BigRational)object;
                return this.mBignum.equals(bigRational.mBignum) && this.mBigdenom.equals(bigRational.mBigdenom);
            }
            if (object instanceof MutableRational) {
                return ((MutableRational)object).equals(this);
            }
            return false;
        }

        @Override
        public BigInteger numerator() {
            return this.mBignum;
        }

        @Override
        public BigInteger denominator() {
            return this.mBigdenom;
        }

        @Override
        public int hashCode() {
            int n = HashUtils.hashJenkins((int)0, (byte[])this.mBignum.toByteArray());
            return HashUtils.hashJenkins((int)n, (byte[])this.mBigdenom.toByteArray());
        }

        @Override
        public String toString() {
            if (this.mBigdenom.equals(BigInteger.ONE)) {
                return this.mBignum.toString();
            }
            return this.mBignum.toString() + "/" + this.mBigdenom.toString();
        }

        @Override
        public boolean isIntegral() {
            return this.mBigdenom.equals(BigInteger.ONE);
        }

        @Override
        public Rational floor() {
            if (this.denominator().equals(BigInteger.ONE)) {
                return this;
            }
            BigInteger bigInteger = this.numerator().divide(this.denominator());
            if (this.numerator().signum() < 0) {
                bigInteger = bigInteger.subtract(BigInteger.ONE);
            }
            return Rational.valueOf(bigInteger, BigInteger.ONE);
        }

        @Override
        public Rational frac() {
            if (this.mBigdenom.equals(BigInteger.ONE)) {
                return ZERO;
            }
            BigInteger bigInteger = this.mBignum.mod(this.mBigdenom);
            if (bigInteger.signum() < 0) {
                bigInteger = bigInteger.add(this.mBigdenom);
            }
            return Rational.valueOf(bigInteger, this.mBigdenom);
        }

        @Override
        public Rational ceil() {
            if (this.denominator().equals(BigInteger.ONE)) {
                return this;
            }
            BigInteger bigInteger = this.numerator().divide(this.denominator());
            if (this.numerator().signum() > 0) {
                bigInteger = bigInteger.add(BigInteger.ONE);
            }
            return Rational.valueOf(bigInteger, BigInteger.ONE);
        }

        @Override
        public Rational abs() {
            return BigRational.valueOf(this.mBignum.abs(), this.mBigdenom);
        }
    }
}

