/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NonDeclaringTermTransferrer
extends TermTransformer {
    private final boolean mApplyLocalSimplifications;
    private final Script mScript;

    public NonDeclaringTermTransferrer(Script script) {
        this(script, false);
    }

    public NonDeclaringTermTransferrer(Script script, boolean bl) {
        this.mScript = script;
        this.mApplyLocalSimplifications = bl;
    }

    protected void convert(Term term) {
        if (term instanceof TermVariable) {
            TermVariable termVariable = this.transferTermVariable((TermVariable)term);
            this.setResult((Term)termVariable);
        } else if (term instanceof ConstantTerm) {
            this.setResult(this.convertConstantTerm((ConstantTerm)term));
        } else {
            super.convert(term);
        }
    }

    private Term convertConstantTerm(ConstantTerm constantTerm) {
        Sort sort = this.transferSort(constantTerm.getSort());
        Object object = constantTerm.getValue();
        if (object instanceof BigInteger) {
            if (sort.isNumericSort()) {
                return this.mScript.numeral((BigInteger)object);
            }
            return this.mScript.getTheory().constant(object, sort);
        }
        if (object instanceof BigDecimal) {
            return this.mScript.decimal((BigDecimal)object);
        }
        if (object instanceof Rational) {
            return ((Rational)object).toTerm(sort);
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.startsWith("#x")) {
                return this.mScript.hexadecimal(string);
            }
            if (string.startsWith("#b")) {
                return this.mScript.binary(string);
            }
        }
        throw new AssertionError((Object)("unexpected ConstantTerm (maybe not yet implemented)" + String.valueOf(constantTerm)));
    }

    TermVariable transferTermVariable(TermVariable termVariable) {
        Sort sort = this.transferSort(termVariable.getSort());
        TermVariable termVariable2 = this.mScript.variable(termVariable.getName(), sort);
        return termVariable2;
    }

    public Sort transferSort(Sort sort) {
        Sort[] sortArray = this.transferSorts(sort.getArguments());
        String[] stringArray = sort.getIndices();
        return this.mScript.sort(sort.getName(), stringArray, sortArray);
    }

    public Sort[] transferSorts(Sort[] sortArray) {
        Sort[] sortArray2 = new Sort[sortArray.length];
        int n = 0;
        while (n < sortArray.length) {
            sortArray2[n] = this.transferSort(sortArray[n]);
            ++n;
        }
        return sortArray2;
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        Sort sort = functionSymbol.isReturnOverload() ? this.transferSort(functionSymbol.getReturnSort()) : null;
        Term term = this.mApplyLocalSimplifications ? SmtUtils.unfTerm(this.mScript, functionSymbol.getName(), functionSymbol.getIndices(), sort, termArray) : this.mScript.term(functionSymbol.getName(), applicationTerm.getFunction().getIndices(), sort, termArray);
        this.setResult(term);
    }

    public void postConvertLet(LetTerm letTerm, Term[] termArray, Term term) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        TermVariable[] termVariableArray = new TermVariable[quantifiedFormula.getVariables().length];
        int n = 0;
        while (n < quantifiedFormula.getVariables().length) {
            termVariableArray[n] = this.transferTermVariable(quantifiedFormula.getVariables()[n]);
            ++n;
        }
        Term term2 = this.mScript.quantifier(quantifiedFormula.getQuantifier(), termVariableArray, term, (Term[][])new Term[0][]);
        this.setResult(term2);
    }

    public void postConvertAnnotation(AnnotatedTerm annotatedTerm, Annotation[] annotationArray, Term term) {
        Term term2 = this.mScript.annotate(term, annotationArray);
        this.setResult(term2);
    }
}

