/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashTreeRelation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AssertOrderUtils {
    public static Set<Integer> getTraceDifference(NestedWord<?> nestedWord, Set<Integer> set) {
        return IntStream.range(0, nestedWord.length()).boxed().filter(n -> !set.contains(n)).collect(Collectors.toSet());
    }

    public static <L extends IAction> Map<Integer, Set<Integer>> partitionStatementsAccordingDepth(Counterexample<L> counterexample) {
        HashTreeRelation hashTreeRelation = new HashTreeRelation();
        NestedWord<L> nestedWord = counterexample.getWord();
        List<Object> list = counterexample.getControlConfigurations();
        int n = 0;
        while (n <= nestedWord.length()) {
            hashTreeRelation.addPair(list.get(n), (Object)n);
            ++n;
        }
        HashMap<Integer, Set<Integer>> hashMap = new HashMap<Integer, Set<Integer>>();
        AssertOrderUtils.dfsPartitionStatementsAccordingToDepth(0, nestedWord.length(), 0, (HashTreeRelation<Object, Integer>)hashTreeRelation, hashMap, list);
        return hashMap;
    }

    private static void dfsPartitionStatementsAccordingToDepth(Integer n, Integer n2, int n3, HashTreeRelation<Object, Integer> hashTreeRelation, Map<Integer, Set<Integer>> map, List<Object> list) {
        int n4 = n;
        while (n4 < n2) {
            TreeSet treeSet = hashTreeRelation.getImage(list.get(n4));
            if (treeSet.size() >= 2 && treeSet.higher(n4) != null && treeSet.higher(n4) < n2) {
                int n5 = treeSet.lower(n2);
                AssertOrderUtils.addStmtPositionToDepth(n3 + 1, map, n4);
                AssertOrderUtils.dfsPartitionStatementsAccordingToDepth(n4 + 1, n5, n3 + 1, hashTreeRelation, map, list);
                n4 = n5;
                continue;
            }
            AssertOrderUtils.addStmtPositionToDepth(n3, map, n4);
            ++n4;
        }
    }

    private static void addStmtPositionToDepth(int n, Map<Integer, Set<Integer>> map, int n2) {
        if (map.containsKey(n)) {
            map.get(n).add(n2);
        } else {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(n2);
            map.put(n, hashSet);
        }
    }
}

