/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.LoopAccelerators;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.AcceleratedInterpolationCore;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.PredicateHelper;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.benchmark.AcceleratedInterpolationBenchmark;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator.AcceleratorFastUPR;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator.AcceleratorJordan;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator.AcceleratorQvasr;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator.AcceleratorQvasrs;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator.AcceleratorWernerOverapprox;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopdetector.Loopdetector;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.looppreprocessor.LoopPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AcceleratedInterpolation<L extends IIcfgTransition<?>>
implements IInterpolatingTraceCheck<L> {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private final Counterexample<L> mCounterexampleTrace;
    private final List<L> mCounterexample;
    private final IPredicateUnifier mPredUnifier;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mPredTransformer;
    private final PredicateHelper<L> mPredHelper;
    private final ITraceCheckPreferences mPrefs;
    private final IIcfg<?> mIcfg;
    private Script.LBool mIsTraceCorrect;
    private IPredicate[] mInterpolants;
    private IProgramExecution<L, Term> mFeasibleProgramExecution;
    private TraceCheckReasonUnknown mReasonUnknown;
    private boolean mTraceCheckFinishedNormally;
    private final AcceleratedInterpolationBenchmark mAccelInterpolBench;
    private final Class<L> mTransitionClazz;

    public AcceleratedInterpolation(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ITraceCheckPreferences iTraceCheckPreferences, ManagedScript managedScript, IPredicateUnifier iPredicateUnifier, Counterexample<L> counterexample, Class<L> clazz, LoopAccelerators loopAccelerators, AcceleratedInterpolationCore.IStrategySupplier<L> iStrategySupplier) {
        LoopPreprocessor<L> loopPreprocessor;
        Object object;
        Loopdetector loopdetector;
        this.mLogger = iLogger;
        this.mScript = managedScript;
        this.mTransitionClazz = clazz;
        this.mServices = iUltimateServiceProvider;
        this.mCounterexampleTrace = counterexample;
        this.mCounterexample = this.mCounterexampleTrace.getWord().asList();
        this.mPrefs = iTraceCheckPreferences;
        this.mAccelInterpolBench = new AcceleratedInterpolationBenchmark();
        this.mAccelInterpolBench.start((Object)AcceleratedInterpolationBenchmark.AcceleratedInterpolationStatisticsDefinitions.ACCELINTERPOL_OVERALL);
        this.mIcfg = this.mPrefs.getIcfgContainer();
        this.mPredUnifier = iPredicateUnifier;
        this.mLogger.debug((Object)"Accelerated Interpolation engaged!");
        this.mPredTransformer = new PredicateTransformer(this.mScript, (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, this.mScript));
        this.mPredHelper = new PredicateHelper(this.mPredUnifier, this.mPredTransformer, this.mLogger, this.mScript, this.mServices);
        this.mInterpolants = new IPredicate[this.mCounterexample.size()];
        object = new AcceleratedInterpolationCore<L>(this.mServices, this.mLogger, this.mScript, this.mPredUnifier, this.mPrefs, this.mCounterexampleTrace, this.mIcfg, loopdetector, loopPreprocessor, switch (loopAccelerators) {
            case LoopAccelerators.FAST_UPR -> {
                loopdetector = new Loopdetector(this.mCounterexample, this.mLogger);
                object = new ArrayList<String>(Arrays.asList("ite", "mod", "!=", "not"));
                loopPreprocessor = new LoopPreprocessor<L>(this.mLogger, this.mScript, this.mServices, this.mPredUnifier, this.mPredHelper, this.mIcfg.getCfgSmtToolkit(), (List<String>)object);
                yield new AcceleratorFastUPR(this.mLogger, this.mScript, this.mServices, this.mIcfg.getCfgSmtToolkit().getSymbolTable());
            }
            case LoopAccelerators.JORDAN -> {
                loopdetector = new Loopdetector(this.mCounterexample, this.mLogger);
                loopPreprocessor = new LoopPreprocessor<L>(this.mLogger, this.mScript, this.mServices, this.mPredUnifier, this.mPredHelper, this.mIcfg.getCfgSmtToolkit(), new ArrayList<String>(Arrays.asList("ite")));
                yield new AcceleratorJordan(this.mLogger, this.mScript, this.mServices);
            }
            case LoopAccelerators.QVASR -> {
                loopdetector = new Loopdetector(this.mCounterexample, this.mLogger);
                loopPreprocessor = new LoopPreprocessor<L>(this.mLogger, this.mScript, this.mServices, this.mPredUnifier, this.mPredHelper, this.mIcfg.getCfgSmtToolkit(), Arrays.asList("No DNF"));
                yield new AcceleratorQvasr(this.mLogger, this.mScript, this.mServices, this.mPredUnifier);
            }
            case LoopAccelerators.QVASRS -> {
                loopdetector = new Loopdetector(this.mCounterexample, this.mLogger);
                loopPreprocessor = new LoopPreprocessor<L>(this.mLogger, this.mScript, this.mServices, this.mPredUnifier, this.mPredHelper, this.mIcfg.getCfgSmtToolkit(), Arrays.asList("No DNF"));
                yield new AcceleratorQvasrs(this.mLogger, this.mScript, this.mServices);
            }
            case LoopAccelerators.WERNER_OVERAPPROX -> {
                loopdetector = new Loopdetector(this.mCounterexample, this.mLogger);
                loopPreprocessor = new LoopPreprocessor<L>(this.mLogger, this.mScript, this.mServices, this.mPredUnifier, this.mPredHelper, this.mIcfg.getCfgSmtToolkit(), new ArrayList<String>(Arrays.asList("")));
                yield new AcceleratorWernerOverapprox(this.mLogger, this.mScript, this.mServices, this.mIcfg.getCfgSmtToolkit().getSymbolTable());
            }
            default -> throw new UnsupportedOperationException("Unkown " + String.valueOf(loopAccelerators));
        }, iStrategySupplier);
        try {
            try {
                this.mAccelInterpolBench.start((Object)AcceleratedInterpolationBenchmark.AcceleratedInterpolationStatisticsDefinitions.ACCELINTERPOL_CORE);
                this.mIsTraceCorrect = ((AcceleratedInterpolationCore)object).acceleratedInterpolationCoreIsCorrect();
                if (this.mIsTraceCorrect == Script.LBool.UNSAT) {
                    this.mInterpolants = ((AcceleratedInterpolationCore)object).getInterpolants();
                }
                this.mTraceCheckFinishedNormally = true;
                this.mReasonUnknown = this.mIsTraceCorrect == Script.LBool.UNKNOWN ? new TraceCheckReasonUnknown(TraceCheckReasonUnknown.Reason.SOLVER_RESPONSE_OTHER, null, TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_DEPENDING) : null;
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                this.mTraceCheckFinishedNormally = false;
                this.mIsTraceCorrect = Script.LBool.UNKNOWN;
                this.mReasonUnknown = new TraceCheckReasonUnknown(TraceCheckReasonUnknown.Reason.ULTIMATE_TIMEOUT, (Exception)((Object)toolchainCanceledException), TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_DEPENDING);
                this.mAccelInterpolBench.stopAllStopwatches();
                this.mLogger.debug((Object)"Finished");
            }
            catch (SMTLIBException sMTLIBException) {
                this.mTraceCheckFinishedNormally = false;
                this.mIsTraceCorrect = Script.LBool.UNKNOWN;
                this.mReasonUnknown = TraceCheckReasonUnknown.constructReasonUnknown((SMTLIBException)sMTLIBException);
                this.mAccelInterpolBench.stopAllStopwatches();
                this.mLogger.debug((Object)"Finished");
            }
        }
        finally {
            this.mAccelInterpolBench.stopAllStopwatches();
            this.mLogger.debug((Object)"Finished");
        }
    }

    private IProgramExecution<L, Term> computeProgramExecution() {
        if (this.mIsTraceCorrect == Script.LBool.SAT) {
            return IProgramExecution.emptyExecution(Term.class, this.mTransitionClazz);
        }
        return null;
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        if (this.isCorrect() == Script.LBool.UNSAT) {
            return new InterpolantComputationStatus();
        }
        if (this.isCorrect() == Script.LBool.SAT) {
            return new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.TRACE_FEASIBLE, null);
        }
        throw new UnsupportedOperationException();
    }

    public IPredicate[] getInterpolants() {
        return this.mInterpolants;
    }

    public Map<Integer, IPredicate> getPendingContexts() {
        return Collections.emptyMap();
    }

    public IPredicate getPostcondition() {
        return this.mPredUnifier.getFalsePredicate();
    }

    public IPredicate getPrecondition() {
        return this.mPredUnifier.getTruePredicate();
    }

    public IPredicateUnifier getPredicateUnifier() {
        return this.mPredUnifier;
    }

    public IProgramExecution<L, Term> getRcfgProgramExecution() {
        if (this.mFeasibleProgramExecution == null) {
            this.mFeasibleProgramExecution = this.computeProgramExecution();
        }
        return this.mFeasibleProgramExecution;
    }

    public IStatisticsDataProvider getStatistics() {
        return null;
    }

    public List<L> getTrace() {
        return this.mCounterexample;
    }

    public TraceCheckReasonUnknown getTraceCheckReasonUnknown() {
        return this.mReasonUnknown;
    }

    public Script.LBool isCorrect() {
        return this.mIsTraceCorrect;
    }

    public boolean isPerfectSequence() {
        return this.isCorrect() == Script.LBool.UNSAT;
    }

    public boolean providesRcfgProgramExecution() {
        return this.mIsTraceCorrect != Script.LBool.SAT;
    }

    public boolean wasTracecheckFinishedNormally() {
        return this.mTraceCheckFinishedNormally;
    }
}

