/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.lib.proofs.IProof;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ProofAnnotation
extends ModernAnnotations {
    private static final long serialVersionUID = -9142656546325935187L;
    private static final String KEY = ProofAnnotation.class.getName();
    @Visualizable
    private final List<IProof> mProofs;

    private ProofAnnotation(List<IProof> list) {
        this.mProofs = list;
    }

    public List<IProof> getProofs() {
        return Collections.unmodifiableList(this.mProofs);
    }

    public static void addProof(IElement iElement, IProof iProof) {
        IAnnotations iAnnotations = (IAnnotations)iElement.getPayload().getAnnotations().get(KEY);
        ArrayList<IProof> arrayList = new ArrayList<IProof>();
        if (iAnnotations != null) {
            arrayList.addAll(((ProofAnnotation)iAnnotations).getProofs());
        }
        arrayList.add(iProof);
        ProofAnnotation proofAnnotation = new ProofAnnotation(arrayList);
        iElement.getPayload().getAnnotations().put(KEY, proofAnnotation);
    }

    public static List<IProof> getProofs(IElement iElement) {
        IAnnotations iAnnotations = (IAnnotations)iElement.getPayload().getAnnotations().get(KEY);
        if (iAnnotations == null) {
            return Collections.emptyList();
        }
        return ((ProofAnnotation)iAnnotations).getProofs();
    }

    public static <T> List<T> getProofs(IElement iElement, Class<T> clazz) {
        IAnnotations iAnnotations = (IAnnotations)iElement.getPayload().getAnnotations().get(KEY);
        if (iAnnotations == null) {
            return Collections.emptyList();
        }
        return ((ProofAnnotation)iAnnotations).getProofs().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }
}

