/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.lib.chc.ChcCategoryInfo;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.List;

public class HornAnnot
extends ModernAnnotations {
    private static final long serialVersionUID = -3542578811318106167L;
    private static final String KEY = HornAnnot.class.getName();
    private final ManagedScript mBackendSolverScript;
    private final HcSymbolTable mSymbolTable;
    private final String mFileName;
    private final List<HornClause> mHornClauses;
    private final boolean mHasCheckSat;
    private final ChcCategoryInfo mChcCategoryInfo;

    public HornAnnot(String string, ManagedScript managedScript, HcSymbolTable hcSymbolTable, List<HornClause> list, boolean bl, ChcCategoryInfo chcCategoryInfo) {
        this.mFileName = string;
        this.mHornClauses = list;
        this.mBackendSolverScript = managedScript;
        this.mSymbolTable = hcSymbolTable;
        this.mHasCheckSat = bl;
        this.mChcCategoryInfo = chcCategoryInfo;
    }

    public ManagedScript getScript() {
        return this.mBackendSolverScript;
    }

    public HcSymbolTable getSymbolTable() {
        return this.mSymbolTable;
    }

    public List<HornClause> getHornClauses() {
        return this.mHornClauses;
    }

    public boolean hasCheckSat() {
        return this.mHasCheckSat;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(HornAnnot) List of HornClauses:").append(CoreUtil.getPlatformLineSeparator());
        for (HornClause hornClause : this.mHornClauses) {
            stringBuilder.append(hornClause.toString());
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        }
        return stringBuilder.toString();
    }

    public void annotate(IElement iElement) {
        iElement.getPayload().getAnnotations().put(KEY, this);
    }

    public static HornAnnot getAnnotation(IElement iElement) {
        return (HornAnnot)ModelUtils.getAnnotation((IElement)iElement, (String)KEY, iAnnotations -> (HornAnnot)((Object)iAnnotations));
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        if (iAnnotations instanceof HornAnnot) {
            throw new IAnnotations.UnmergeableAnnotationsException("Not implemented for " + ((Object)((Object)this)).getClass().getName());
        }
        return super.merge(iAnnotations);
    }

    public ChcCategoryInfo getChcCategoryInfo() {
        return this.mChcCategoryInfo;
    }
}

