/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.simplify;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrerBooleanCore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.simplify.SimplifyDDAWithTimeout;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class SimplifyQuick {
    private final IUltimateServiceProvider mServices;
    private final Script mScript;
    private static final int TIMOUT_IN_SECONDS = 10;

    public SimplifyQuick(Script script, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mScript = script;
        this.mServices = iUltimateServiceProvider;
    }

    public Term getSimplifiedTerm(Term term) throws SMTLIBException {
        SolverBuilder.SolverSettings solverSettings = SolverBuilder.constructSolverSettings().setSmtInterpolTimeout(10000L);
        Script script = SolverBuilder.buildScript(this.mServices, solverSettings);
        script.setLogic(Logics.CORE);
        TermTransferrerBooleanCore termTransferrerBooleanCore = new TermTransferrerBooleanCore(this.mScript, script);
        Term term2 = termTransferrerBooleanCore.transform(term);
        script.setOption(":check-type", (Object)"QUICK");
        SimplifyDDAWithTimeout simplifyDDAWithTimeout = new SimplifyDDAWithTimeout(script, false, this.mServices);
        Term term3 = simplifyDDAWithTimeout.getSimplifiedTerm(term2);
        TermTransferrer termTransferrer = new TermTransferrer(script, this.mScript, termTransferrerBooleanCore.getBacktransferMapping(), false);
        Term term4 = termTransferrer.transform(term3);
        script.exit();
        return term4;
    }
}

