/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IGeneralizedNwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public final class GeneralizedBuchiAccepts<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final NestedWord<LETTER> mStem;
    private final NestedWord<LETTER> mLoop;
    private final IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final Boolean mIsAccepted;

    public GeneralizedBuchiAccepts(AutomataLibraryServices automataLibraryServices, IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iGeneralizedNwaOutgoingLetterAndTransitionProvider, NestedLassoWord<LETTER> nestedLassoWord) throws AutomataLibraryException {
        super(automataLibraryServices);
        this.mOperand = iGeneralizedNwaOutgoingLetterAndTransitionProvider;
        this.mStem = nestedLassoWord.getStem();
        this.mLoop = nestedLassoWord.getLoop();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        if (this.mStem.containsPendingReturns()) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)"This implementation of Buchi acceptance rejects lasso words, where the stem contains pending returns.");
            }
            this.mIsAccepted = false;
            return;
        }
        if (this.mLoop.containsPendingReturns()) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)"This implementation of Buchi acceptance rejects lasso words, where the loop contains pending returns.");
            }
            this.mIsAccepted = false;
            return;
        }
        if (this.mLoop.length() == 0) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"LassoWords with empty lasso are rejected by every B\u00fcchi automaton");
            }
            this.mIsAccepted = false;
            return;
        }
        this.mIsAccepted = this.buchiAccepts();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + " Operand " + this.mOperand.sizeInformation() + " Stem has " + this.mStem.length() + " letters. Loop has " + this.mLoop.length() + " letters.";
    }

    private boolean buchiAccepts() throws AutomataLibraryException {
        Ascc ascc = new Ascc();
        return ascc.mIsEmpty == false;
    }

    @Override
    public Boolean getResult() {
        return this.mIsAccepted;
    }

    @Override
    protected IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    private int getNextState(int n) {
        if (n < this.mStem.length() + this.mLoop.length()) {
            return n + 1;
        }
        assert (n == this.mStem.length() + this.mLoop.length());
        return this.mStem.length() + 1;
    }

    private LETTER getNextLetter(int n) {
        assert (n <= this.mStem.length() + this.mLoop.length());
        if (n < this.mStem.length()) {
            return this.mStem.getSymbol(n);
        }
        if (n < this.mStem.length() + this.mLoop.length()) {
            return this.mLoop.getSymbol(n - this.mStem.length());
        }
        assert (n == this.mStem.length() + this.mLoop.length());
        return this.mLoop.getSymbol(0);
    }

    private boolean isFinalState(int n) {
        return n > this.mStem.length();
    }

    private Set<Integer> getAcceptanceLabels(StackElement<LETTER, STATE> stackElement) {
        HashSet<Integer> hashSet = new HashSet<Integer>(this.mOperand.getAcceptanceLabels(stackElement.mState));
        if (this.isFinalState(stackElement.mIndex)) {
            hashSet.add(this.mOperand.getAcceptanceSize());
        }
        return hashSet;
    }

    private class Ascc {
        private int mDepth;
        private final Stack<AsccPair> mRootsStack = new Stack();
        private final Stack<StackElement<LETTER, STATE>> mActiveStack = new Stack();
        private final TObjectIntMap<StackElement<LETTER, STATE>> mDfsNum = new TObjectIntHashMap();
        private final Set<StackElement<LETTER, STATE>> mCurrent = new HashSet();
        private Boolean mIsEmpty = null;

        public Ascc() throws AutomataOperationCanceledException {
            for (Object STATE : GeneralizedBuchiAccepts.this.mOperand.getInitialStates()) {
                StackElement stackElement = new StackElement(STATE, 0);
                if (this.mDfsNum.containsKey(stackElement)) continue;
                this.strongConnect(stackElement);
            }
            if (this.mIsEmpty == null) {
                this.mIsEmpty = true;
            }
        }

        void strongConnect(StackElement<LETTER, STATE> stackElement) throws AutomataOperationCanceledException {
            ++this.mDepth;
            this.mDfsNum.put(stackElement, this.mDepth);
            this.mRootsStack.push(new AsccPair(stackElement, GeneralizedBuchiAccepts.this.getAcceptanceLabels(stackElement)));
            this.mActiveStack.push(stackElement);
            this.mCurrent.add(stackElement);
            for (OutgoingInternalTransition object : GeneralizedBuchiAccepts.this.mOperand.internalSuccessors(stackElement.mState, GeneralizedBuchiAccepts.this.getNextLetter(stackElement.mIndex))) {
                StackElement stackElement2;
                if (GeneralizedBuchiAccepts.this.mServices.getProgressAwareTimer() != null && !GeneralizedBuchiAccepts.this.mServices.getProgressAwareTimer().continueProcessing()) {
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                StackElement stackElement3 = new StackElement(object.getSucc(), GeneralizedBuchiAccepts.this.getNextState(stackElement.mIndex));
                if (!this.mDfsNum.containsKey(stackElement3)) {
                    this.strongConnect(stackElement3);
                    continue;
                }
                if (!this.mCurrent.contains(stackElement3)) continue;
                HashSet<Integer> hashSet = new HashSet<Integer>();
                do {
                    AsccPair asccPair = this.mRootsStack.pop();
                    stackElement2 = asccPair.mElem;
                    hashSet.addAll(asccPair.mLabels);
                    if (hashSet.size() != GeneralizedBuchiAccepts.this.mOperand.getAcceptanceSize() + 1) continue;
                    this.mIsEmpty = false;
                } while (this.mDfsNum.get(stackElement2) > this.mDfsNum.get(stackElement3));
                this.mRootsStack.push(new AsccPair(stackElement2, hashSet));
            }
            if (this.mRootsStack.peek().mElem.equals(stackElement)) {
                StackElement stackElement4;
                this.mRootsStack.pop();
                do {
                    stackElement4 = this.mActiveStack.pop();
                    this.mCurrent.remove(stackElement4);
                } while (!stackElement4.equals(stackElement));
            }
        }
    }

    private class AsccPair {
        StackElement<LETTER, STATE> mElem;
        Set<Integer> mLabels;

        AsccPair(StackElement<LETTER, STATE> stackElement, Set<Integer> set) {
            this.mElem = stackElement;
            this.mLabels = set;
        }
    }

    private static class StackElement<LETTER, STATE> {
        final STATE mState;
        final int mIndex;
        private boolean hasCode = false;
        int hashCode;

        StackElement(STATE STATE, int n) {
            this.mState = STATE;
            this.mIndex = n;
        }

        public String toString() {
            return "[" + String.valueOf(this.mState) + ", " + this.mIndex + "]";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StackElement stackElement = (StackElement)object;
            return this.mState.equals(stackElement.mState) && this.mIndex == stackElement.mIndex;
        }

        public int hashCode() {
            if (this.hasCode) {
                return this.hashCode;
            }
            this.hasCode = true;
            this.hashCode = 1;
            this.hashCode = this.hashCode * 31 + this.mState.hashCode();
            this.hashCode = this.hashCode * 31 + this.mIndex;
            return this.hashCode;
        }
    }
}

