/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;

public class ConstantTerm
extends Term {
    private final Object mValue;
    private final Sort mSort;

    ConstantTerm(Object object, Sort sort, int n) {
        super(n);
        this.mValue = object;
        this.mSort = sort;
    }

    public Object getValue() {
        return this.mValue;
    }

    @Override
    public Sort getSort() {
        return this.mSort;
    }

    @Override
    public String toString() {
        if (this.mSort.isBitVecSort() && this.mValue instanceof BigInteger) {
            return "(_ bv" + this.mValue.toString() + " " + this.mSort.getIndices()[0] + ")";
        }
        if (this.mValue instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)this.mValue;
            Object object = bigInteger.abs().toString();
            if (bigInteger.signum() < 0) {
                object = "(- " + (String)object + ")";
            }
            return object;
        }
        if (this.mValue instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)this.mValue;
            Object object = bigDecimal.abs().toPlainString();
            if (bigDecimal.signum() < 0) {
                object = "(- " + (String)object + ")";
            }
            return object;
        }
        if (this.mValue instanceof Rational) {
            Rational rational = (Rational)this.mValue;
            Object object = rational.numerator().abs().toString();
            if (this.getSort().getName() == "Real") {
                object = (String)object + ".0";
            }
            if (rational.isNegative()) {
                object = "(- " + (String)object + ")";
            }
            if (!rational.isIntegral()) {
                assert (this.getSort().getName() == "Real");
                object = "(/ " + (String)object + " " + String.valueOf(rational.denominator()) + ".0)";
            }
            return object;
        }
        return this.mValue.toString();
    }

    @Override
    public String toStringDirect() {
        return this.toString();
    }

    public static final int hashConstant(Object object, Sort sort) {
        return object.hashCode() ^ sort.hashCode();
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> arrayDeque) {
        arrayDeque.add(this.toString());
    }
}

