/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.counting.ConjunctGuards;
import de.uni_freiburg.informatik.ultimate.automata.counting.Counter;
import de.uni_freiburg.informatik.ultimate.automata.counting.CountingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.FinalCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.Guard;
import de.uni_freiburg.informatik.ultimate.automata.counting.InitialCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.Transition;
import de.uni_freiburg.informatik.ultimate.automata.counting.Update;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Intersect<LETTER, STATE, CRSF extends IStateFactory<STATE>>
implements IOperation<LETTER, STATE, CRSF> {
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final CountingAutomaton<LETTER, STATE> mFstOperand;
    private final CountingAutomaton<LETTER, STATE> mSndOperand;
    private final CountingAutomaton<LETTER, STATE> mResult;
    private final IIntersectionStateFactory<STATE> mStateFactory;

    public Intersect(AutomataLibraryServices automataLibraryServices, IIntersectionStateFactory<STATE> iIntersectionStateFactory, CountingAutomaton<LETTER, STATE> countingAutomaton, CountingAutomaton<LETTER, STATE> countingAutomaton2) throws AutomataLibraryException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(this.getClass());
        this.mFstOperand = countingAutomaton;
        this.mSndOperand = countingAutomaton2;
        this.mStateFactory = iIntersectionStateFactory;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.computeResult();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private CountingAutomaton<LETTER, STATE> computeResult() {
        ArrayList<Object> arrayList;
        Object object;
        Object object22;
        Set<LETTER> set = this.mFstOperand.getAlphabet();
        ArrayList<Counter> arrayList2 = new ArrayList<Counter>();
        for (Counter object32 : this.mFstOperand.getCounter()) {
            arrayList2.add(object32.copyCounter());
        }
        for (Counter counter : this.mSndOperand.getCounter()) {
            arrayList2.add(counter.copyCounter());
        }
        HashSet<STATE> hashSet = new HashSet<STATE>();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        for (Object object22 : this.mFstOperand.getStates()) {
            for (STATE STATE : this.mSndOperand.getStates()) {
                object = this.mStateFactory.intersection(object22, STATE);
                hashSet.add(object);
                arrayList = new ArrayList<STATE>();
                arrayList.add(object22);
                arrayList.add(STATE);
                hashMap4.put(arrayList, object);
            }
        }
        for (Object object22 : this.mFstOperand.getStates()) {
            for (STATE STATE : this.mSndOperand.getStates()) {
                object = new ArrayList();
                ((ArrayList)object).add(object22);
                ((ArrayList)object).add(STATE);
                arrayList = hashMap4.get(object);
                ConjunctGuards conjunctGuards = new ConjunctGuards(this.mFstOperand.getInitialConditions().get(object22).copyInitialCondition().getCondition(), this.mSndOperand.getInitialConditions().get(STATE).copyInitialCondition().getCondition());
                ArrayList<ArrayList<Guard>> arrayList3 = conjunctGuards.getResult();
                hashMap.put(arrayList, new InitialCondition(arrayList3));
                ConjunctGuards conjunctGuards2 = new ConjunctGuards(this.mFstOperand.getFinalConditions().get(object22).copyFinalCondition().getCondition(), this.mSndOperand.getFinalConditions().get(STATE).copyFinalCondition().getCondition());
                ArrayList<ArrayList<Guard>> arrayList4 = conjunctGuards2.getResult();
                hashMap2.put(arrayList, new FinalCondition(arrayList4));
                ArrayList arrayList5 = new ArrayList();
                for (Transition<LETTER, STATE> transition : this.mFstOperand.getTransitions().get(object22)) {
                    for (Transition<LETTER, STATE> transition2 : this.mSndOperand.getTransitions().get(STATE)) {
                        if (!transition.getLetter().equals(transition2.getLetter())) continue;
                        Transition<LETTER, STATE> transition3 = transition.copyTransition();
                        Transition<LETTER, STATE> transition4 = transition2.copyTransition();
                        ConjunctGuards conjunctGuards3 = new ConjunctGuards(transition3.getGuards(), transition4.getGuards());
                        ArrayList<ArrayList<Guard>> arrayList6 = conjunctGuards3.getResult();
                        ArrayList<Update> arrayList7 = new ArrayList<Update>(transition3.getUpdates());
                        arrayList7.addAll(transition4.getUpdates());
                        ArrayList<STATE> arrayList8 = new ArrayList<STATE>();
                        arrayList8.add(transition3.getSucState());
                        arrayList8.add(transition4.getSucState());
                        Object v = hashMap4.get(arrayList8);
                        arrayList5.add(new Transition(transition3.getLetter(), arrayList, v, arrayList6, arrayList7));
                    }
                }
                hashMap3.put(arrayList, arrayList5);
            }
        }
        object22 = new CountingAutomaton(this.mServices, set, hashSet, arrayList2, hashMap, hashMap2, hashMap3);
        return object22;
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + ". First operand " + this.getFirstOperand().sizeInformation() + " Second operand " + this.getSecondOperand().sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult.sizeInformation();
    }

    public CountingAutomaton<LETTER, STATE> getFirstOperand() {
        return this.mFstOperand;
    }

    public CountingAutomaton<LETTER, STATE> getSecondOperand() {
        return this.mSndOperand;
    }

    @Override
    public CountingAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        return true;
    }
}

