/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.models;

import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class ProcedureContract<E, V> {
    @Visualizable
    private final String mProcedure;
    @Visualizable
    private final E mRequires;
    @Visualizable
    private final E mEnsures;
    @Visualizable
    private final Set<V> mModifies;

    public ProcedureContract(String string, E e, E e2) {
        this.mProcedure = Objects.requireNonNull(string);
        this.mRequires = e;
        this.mEnsures = e2;
        this.mModifies = null;
    }

    public ProcedureContract(String string, E e, E e2, Set<V> set) {
        this.mProcedure = Objects.requireNonNull(string);
        this.mRequires = e;
        this.mEnsures = e2;
        this.mModifies = Objects.requireNonNull(set);
    }

    public boolean hasModifies() {
        return this.mModifies != null;
    }

    public String getProcedure() {
        return this.mProcedure;
    }

    public E getRequires() {
        return this.mRequires;
    }

    public E getEnsures() {
        return this.mEnsures;
    }

    public Set<V> getModifies() {
        return Collections.unmodifiableSet(this.mModifies);
    }

    public boolean hasOnlyTrivialClauses() {
        return this.mRequires == null && this.mEnsures == null && !this.hasModifies();
    }
}

