/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Analyze<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private static final int THREE = 3;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private boolean mNumberOfStatesComputed;
    private int mNumberOfStates;
    private boolean mNumberOfSymbolsComputed;
    private int mNumberOfInternalSymbols;
    private int mNumberOfCallSymbols;
    private int mNumberOfReturnSymbols;
    private boolean mNumberOfTransitionsComputed;
    private int mNumberOfInternalTransitions;
    private int mNumberOfCallTransitions;
    private int mNumberOfReturnTransitions;
    private boolean mTransitionDensityComputed;
    private double mInternalTransitionDensity;
    private double mCallTransitionDensity;
    private double mReturnTransitionDensity;
    private boolean mNumberOfNondeterministicStatesComputed;
    private int mNumberOfNondeterministicStates;

    public Analyze(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        this(automataLibraryServices, iNestedWordAutomaton, false);
    }

    public Analyze(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, boolean bl) {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton;
        if (bl) {
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)this.startMessage());
            }
            this.getNumberOfStates();
            this.getNumberOfSymbols(SymbolType.TOTAL);
            this.getNumberOfTransitions(SymbolType.TOTAL);
            this.getTransitionDensity(SymbolType.TOTAL);
            this.getNumberOfNondeterministicStates();
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)this.exitMessage());
            }
        }
    }

    public final int getNumberOfStates() {
        if (!this.mNumberOfStatesComputed) {
            this.computeNumberOfStates();
        }
        return this.mNumberOfStates;
    }

    public final int getNumberOfSymbols(SymbolType symbolType) {
        if (!this.mNumberOfSymbolsComputed) {
            this.computeNumberOfSymbols();
        }
        return switch (symbolType) {
            case SymbolType.INTERNAL -> this.mNumberOfInternalSymbols;
            case SymbolType.CALL -> this.mNumberOfCallSymbols;
            case SymbolType.RETURN -> this.mNumberOfReturnSymbols;
            case SymbolType.TOTAL -> this.mNumberOfInternalSymbols + this.mNumberOfCallSymbols + this.mNumberOfReturnSymbols;
            default -> throw new MatchException(null, null);
        };
    }

    public final int getNumberOfTransitions(SymbolType symbolType) {
        if (!this.mNumberOfTransitionsComputed) {
            this.computeNumberOfTransitions();
        }
        return switch (symbolType) {
            case SymbolType.INTERNAL -> this.mNumberOfInternalTransitions;
            case SymbolType.CALL -> this.mNumberOfCallTransitions;
            case SymbolType.RETURN -> this.mNumberOfReturnTransitions;
            case SymbolType.TOTAL -> this.mNumberOfInternalTransitions + this.mNumberOfCallTransitions + this.mNumberOfReturnTransitions;
            default -> throw new MatchException(null, null);
        };
    }

    public final double getTransitionDensity(SymbolType symbolType) {
        if (!this.mTransitionDensityComputed) {
            this.computeTransitionDensity();
        }
        return switch (symbolType) {
            case SymbolType.INTERNAL -> this.mInternalTransitionDensity;
            case SymbolType.CALL -> this.mCallTransitionDensity;
            case SymbolType.RETURN -> this.mReturnTransitionDensity;
            case SymbolType.TOTAL -> (this.mInternalTransitionDensity + this.mCallTransitionDensity + this.mReturnTransitionDensity) / 3.0;
            default -> throw new MatchException(null, null);
        };
    }

    public final int getNumberOfNondeterministicStates() {
        if (!this.mNumberOfNondeterministicStatesComputed) {
            this.computeDegreeOfNondeterminism();
        }
        return this.mNumberOfNondeterministicStates;
    }

    @Override
    public final String startMessage() {
        return "Started automaton analysis";
    }

    @Override
    public final String exitMessage() {
        return "Finished automaton analysis";
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Object getResult() {
        return "NWA analysis result";
    }

    private final void computeNumberOfStates() {
        this.mNumberOfStates = this.mOperand.size();
        this.mNumberOfStatesComputed = true;
    }

    private final void computeNumberOfSymbols() {
        this.mNumberOfInternalSymbols = this.mOperand.getVpAlphabet().getInternalAlphabet().size();
        this.mNumberOfCallSymbols = this.mOperand.getVpAlphabet().getCallAlphabet().size();
        this.mNumberOfReturnSymbols = this.mOperand.getVpAlphabet().getReturnAlphabet().size();
        this.mNumberOfSymbolsComputed = true;
    }

    private final void computeNumberOfTransitions() {
        this.mNumberOfInternalTransitions = 0;
        this.mNumberOfCallTransitions = 0;
        this.mNumberOfReturnTransitions = 0;
        for (STATE STATE : this.mOperand.getStates()) {
            Iterator iterator = this.mOperand.internalSuccessors(STATE).iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++this.mNumberOfInternalTransitions;
            }
            Iterator iterator2 = this.mOperand.callSuccessors(STATE).iterator();
            while (iterator2.hasNext()) {
                iterator2.next();
                ++this.mNumberOfCallTransitions;
            }
            Iterator<OutgoingReturnTransition<LETTER, STATE>> iterator3 = this.mOperand.returnSuccessors(STATE).iterator();
            while (iterator3.hasNext()) {
                iterator3.next();
                ++this.mNumberOfReturnTransitions;
            }
        }
        this.mNumberOfTransitionsComputed = true;
    }

    private void computeTransitionDensity() {
        this.getNumberOfStates();
        this.getNumberOfSymbols(SymbolType.TOTAL);
        this.getNumberOfTransitions(SymbolType.TOTAL);
        double d = this.mNumberOfStates * this.mNumberOfInternalSymbols;
        this.mInternalTransitionDensity = d == 0.0 ? 0.0 : (double)this.mNumberOfInternalTransitions / d;
        d = this.mNumberOfStates * this.mNumberOfCallSymbols;
        this.mCallTransitionDensity = d == 0.0 ? 0.0 : (double)this.mNumberOfCallTransitions / d;
        d = this.mNumberOfStates * this.mNumberOfStates * this.mNumberOfReturnSymbols;
        this.mReturnTransitionDensity = d == 0.0 ? 0.0 : (double)this.mNumberOfReturnTransitions / d;
        this.mTransitionDensityComputed = true;
    }

    private final void computeDegreeOfNondeterminism() {
        this.mNumberOfNondeterministicStates = 0;
        Set set = Collections.emptySet();
        for (STATE STATE : this.mOperand.getStates()) {
            this.computeDegreeOfNondeterminismInternal(set, STATE);
            this.computeDegreeOfNondeterminismCall(set, STATE);
            this.computeDegreeOfNondeterminismReturn(STATE);
        }
        this.mNumberOfNondeterministicStatesComputed = true;
    }

    private void computeDegreeOfNondeterminismInternal(Set<STATE> set, STATE STATE) {
        HashMap hashMap = new HashMap();
        for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE)) {
            if (hashMap.put(outgoingInternalTransition.getLetter(), set) == null) continue;
            ++this.mNumberOfNondeterministicStates;
            return;
        }
    }

    private void computeDegreeOfNondeterminismCall(Set<STATE> set, STATE STATE) {
        HashMap hashMap = new HashMap();
        for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(STATE)) {
            if (hashMap.put(outgoingCallTransition.getLetter(), set) == null) continue;
            ++this.mNumberOfNondeterministicStates;
            return;
        }
    }

    private void computeDegreeOfNondeterminismReturn(STATE STATE) {
        HashMap<LETTER, HashSet<STATE>> hashMap = new HashMap<LETTER, HashSet<STATE>>();
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mOperand.returnSuccessors(STATE)) {
            LETTER LETTER = outgoingReturnTransition.getLetter();
            HashSet<STATE> hashSet = (HashSet<STATE>)hashMap.get(LETTER);
            if (hashSet == null) {
                hashSet = new HashSet<STATE>();
                hashMap.put(LETTER, hashSet);
            }
            if (hashSet.add(outgoingReturnTransition.getHierPred())) continue;
            ++this.mNumberOfNondeterministicStates;
            return;
        }
    }

    public static enum SymbolType {
        INTERNAL,
        CALL,
        RETURN,
        TOTAL;

    }
}

