/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.models;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IVisualizable;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public interface IDirectedGraph<T extends IDirectedGraph<T, E>, E extends IVisualizable<E>>
extends IElement,
IWalkable,
IVisualizable<E> {
    public List<T> getIncomingNodes();

    public List<T> getOutgoingNodes();

    default public Set<T> transitiveNodes(Function<T, Collection<T>> function) {
        return IDirectedGraph.transitiveNodes(Collections.singleton(this), function);
    }

    public static <N extends IDirectedGraph<N, ?>> Set<N> transitiveNodes(Collection<N> collection, Function<N, Collection<N>> function) {
        HashSet<IDirectedGraph> hashSet = new HashSet<IDirectedGraph>();
        ArrayDeque<N> arrayDeque = new ArrayDeque<N>(collection);
        while (!arrayDeque.isEmpty()) {
            for (IDirectedGraph iDirectedGraph : function.apply((IDirectedGraph)arrayDeque.remove())) {
                if (!hashSet.add(iDirectedGraph)) continue;
                arrayDeque.add(iDirectedGraph);
            }
        }
        return hashSet;
    }
}

