/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.SubArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayCellAccess;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SelectInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreLocationBlock;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PartitionProjectionTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class PartitionProjectionTransitionTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements ITransformulaTransformer {
    private final SubArrayManager mSubArrayManager;
    private final HashRelation3<ArrayGroup, Integer, StoreLocationBlock> mArrayGroupToDimensionToLocationBlocks;
    private final ComputeStoreInfosAndArrayGroups<?> mCsiag;
    private final NestedMap3<EdgeInfo, ArrayCellAccess, Integer, StoreLocationBlock> mEdgeInfoToArrayCellAccessToDimensionToLocationBlock;
    private final List<IProgramVarOrConst> mHeapArrays;
    private final HeapSeparatorBenchmark mStatistics;
    ManagedScript mMgdScript;
    DefaultIcfgSymbolTable mNewSymbolTable;
    private final ILogger mLogger;
    private final CfgSmtToolkit mOldCsToolkit;
    private final HashRelation<String, IProgramNonOldVar> mNewModifiableGlobals;

    public PartitionProjectionTransitionTransformer(ILogger iLogger, NestedMap2<SelectInfo, Integer, StoreLocationBlock> nestedMap2, ComputeStoreInfosAndArrayGroups<?> computeStoreInfosAndArrayGroups, List<IProgramVarOrConst> list, HeapSeparatorBenchmark heapSeparatorBenchmark, CfgSmtToolkit cfgSmtToolkit) {
        this.mMgdScript = cfgSmtToolkit.getManagedScript();
        this.mOldCsToolkit = cfgSmtToolkit;
        iLogger.info((Object)"executing heap partitioning transformation");
        this.mLogger = iLogger;
        this.mHeapArrays = list;
        this.mStatistics = heapSeparatorBenchmark;
        this.mEdgeInfoToArrayCellAccessToDimensionToLocationBlock = new NestedMap3();
        this.mArrayGroupToDimensionToLocationBlocks = new HashRelation3();
        for (Triple triple : nestedMap2.entrySet()) {
            this.mEdgeInfoToArrayCellAccessToDimensionToLocationBlock.put((Object)((SelectInfo)triple.getFirst()).getEdgeInfo(), (Object)((SelectInfo)triple.getFirst()).getArrayCellAccess(), (Object)((Integer)triple.getSecond()), (Object)((StoreLocationBlock)triple.getThird()));
            Integer n = (Integer)triple.getSecond();
            assert (n.intValue() == ((StoreLocationBlock)triple.getThird()).getDimension());
            this.mArrayGroupToDimensionToLocationBlocks.addTriple((Object)((SelectInfo)triple.getFirst()).getArrayGroup(), (Object)n, (Object)((StoreLocationBlock)triple.getThird()));
        }
        this.mSubArrayManager = new SubArrayManager(cfgSmtToolkit, this.mStatistics, computeStoreInfosAndArrayGroups);
        this.mCsiag = computeStoreInfosAndArrayGroups;
        this.mNewSymbolTable = new DefaultIcfgSymbolTable();
        this.mNewModifiableGlobals = new HashRelation((AbstractRelation)this.mOldCsToolkit.getModifiableGlobalsTable().getProcToGlobals());
    }

    @Override
    public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> iIcfgTransition, UnmodifiableTransFormula unmodifiableTransFormula) {
        EdgeInfo edgeInfo = new EdgeInfo((IcfgEdge)iIcfgTransition);
        NestedMap2 nestedMap2 = this.mEdgeInfoToArrayCellAccessToDimensionToLocationBlock.get((Object)edgeInfo);
        PartitionProjectionTermTransformer object3 = new PartitionProjectionTermTransformer(this.mLogger, this.mMgdScript, this.mSubArrayManager, (NestedMap2<ArrayCellAccess, Integer, StoreLocationBlock>)nestedMap2, edgeInfo, this.mArrayGroupToDimensionToLocationBlocks, this.mCsiag, this.mHeapArrays);
        Object object = object3.transform(unmodifiableTransFormula.getFormula());
        object3.finish();
        IdentityHashMap<Term, Term> identityHashMap = new IdentityHashMap<Term, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : object3.getNewOutVars().entrySet()) {
            if (!this.mSubArrayManager.isSubArray(entry.getKey()) || object3.getUpdatedSubarrays().contains(entry.getKey())) continue;
            TermVariable termVariable = object3.getNewInVars().get(entry.getKey());
            TermVariable termVariable2 = entry.getValue();
            assert (termVariable2 != null);
            if (termVariable == null || termVariable.equals(termVariable2)) continue;
            Term term = this.mMgdScript.getScript().term("=", new Term[]{termVariable, termVariable2});
            identityHashMap.put(term, this.mMgdScript.getScript().term("true", new Term[0]));
            Term term2 = this.mMgdScript.getScript().term("=", new Term[]{termVariable2, termVariable});
            identityHashMap.put(term2, this.mMgdScript.getScript().term("true", new Term[0]));
        }
        Term term = Substitution.apply((ManagedScript)this.mMgdScript, identityHashMap, (Term)object);
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>(object3.getNewInVars());
        for (Map.Entry<IProgramVar, TermVariable> entry : object3.getNewInVars().entrySet()) {
            if (!this.mSubArrayManager.isSubArray(entry.getKey()) || Arrays.asList(term.getFreeVars()).contains(entry.getValue())) continue;
            hashMap.remove(entry.getKey());
        }
        HashMap<IProgramVar, TermVariable> hashMap2 = new HashMap<IProgramVar, TermVariable>(object3.getNewOutVars());
        for (Map.Entry<IProgramVar, TermVariable> entry : object3.getNewOutVars().entrySet()) {
            if (!this.mSubArrayManager.isSubArray(entry.getKey()) || Arrays.asList(term.getFreeVars()).contains(entry.getValue())) continue;
            hashMap2.remove(entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : hashMap.entrySet()) {
            if (!this.mSubArrayManager.isSubArray((IProgramVar)entry.getKey()) || hashMap2.containsKey(entry.getKey())) continue;
            hashMap2.put((IProgramVar)entry.getKey(), (TermVariable)entry.getValue());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (entry.getKey() instanceof IProgramOldVar) continue;
            this.mNewSymbolTable.add((IProgramVarOrConst)entry.getKey());
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            if (entry.getKey() instanceof IProgramOldVar) continue;
            this.mNewSymbolTable.add((IProgramVarOrConst)entry.getKey());
            if (!iIcfgTransition.getPrecedingProcedure().equals(iIcfgTransition.getSucceedingProcedure()) || !(entry.getKey() instanceof IProgramNonOldVar) || ((TermVariable)entry.getValue()).equals(hashMap.get(entry.getKey()))) continue;
            this.mNewModifiableGlobals.addPair((Object)iIcfgTransition.getPrecedingProcedure(), (Object)((IProgramNonOldVar)entry.getKey()));
        }
        for (IProgramConst iProgramConst : unmodifiableTransFormula.getNonTheoryConsts()) {
            this.mNewSymbolTable.add((IProgramVarOrConst)iProgramConst);
        }
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(hashMap, hashMap2, unmodifiableTransFormula.getNonTheoryConsts().isEmpty(), unmodifiableTransFormula.getNonTheoryConsts(), unmodifiableTransFormula.getBranchEncoders().isEmpty(), (Collection)unmodifiableTransFormula.getBranchEncoders(), unmodifiableTransFormula.getAuxVars().isEmpty());
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(unmodifiableTransFormula.isInfeasible());
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(unmodifiableTransFormula.getAuxVars(), this.mMgdScript);
        object = transFormulaBuilder.finishConstruction(this.mMgdScript);
        assert (iIcfgTransition.getPrecedingProcedure().equals(iIcfgTransition.getSucceedingProcedure()) || object.getAssignedVars().stream().allMatch(iProgramVar -> iProgramVar instanceof ILocalProgramVar)) : "how to deal with a call or return transition that modifies a global variable??";
        this.log(unmodifiableTransFormula, (UnmodifiableTransFormula)object);
        return new ITransformulaTransformer.TransformulaTransformationResult((UnmodifiableTransFormula)object);
    }

    @Override
    public void preprocessIcfg(IIcfg<?> iIcfg) {
    }

    @Override
    public String getName() {
        return "HeapPartitionedCfg";
    }

    @Override
    public IIcfgSymbolTable getNewIcfgSymbolTable() {
        return this.mNewSymbolTable;
    }

    private void log(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) {
        if (!this.mLogger.isDebugEnabled()) {
            return;
        }
        boolean bl = !unmodifiableTransFormula.getFormula().equals(unmodifiableTransFormula2.getFormula());
        boolean bl2 = !unmodifiableTransFormula.getInVars().equals(unmodifiableTransFormula2.getInVars());
        boolean bl3 = !unmodifiableTransFormula.getOutVars().equals(unmodifiableTransFormula2.getOutVars());
        this.mLogger.debug((Object)"transformed transition");
        this.mLogger.debug((Object)("\t " + String.valueOf(unmodifiableTransFormula2)));
        if (!(bl || bl2 || bl3)) {
            this.mLogger.debug((Object)"\t transformula unchanged");
        }
        if (bl) {
            this.mLogger.debug((Object)"\t formula has changed");
            this.mLogger.debug((Object)"\t old formula:");
            this.mLogger.debug((Object)unmodifiableTransFormula.getFormula());
            this.mLogger.debug((Object)"\t new formula:");
            this.mLogger.debug((Object)unmodifiableTransFormula2.getFormula());
        }
        if (bl2) {
            this.mLogger.debug((Object)"\t invars have changed");
            this.mLogger.debug((Object)"\t old invars:");
            this.mLogger.debug((Object)unmodifiableTransFormula.getInVars());
            this.mLogger.debug((Object)"\t new invars:");
            this.mLogger.debug((Object)unmodifiableTransFormula2.getInVars());
        }
        if (bl3) {
            this.mLogger.debug((Object)"\t outvars have changed");
            this.mLogger.debug((Object)"\t old outvars:");
            this.mLogger.debug((Object)unmodifiableTransFormula.getOutVars());
            this.mLogger.debug((Object)"\t new outvars:");
            this.mLogger.debug((Object)unmodifiableTransFormula2.getOutVars());
        }
        this.mLogger.debug((Object)"");
    }

    @Override
    public HashRelation<String, IProgramNonOldVar> getNewModifiedGlobals() {
        return this.mNewModifiableGlobals;
    }
}

