/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.preferences;

import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.Activator;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.preferences.EnableWhen;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.preferences.UserListType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.PreferenceType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum PreferenceItem {
    LABEL_ENABLE_INLINING_FOR("\u2500\u2500\u2500  I n l i n e  \u2500\u2500\u2500"),
    INLINE_UNIMPLEMENTED("Inline calls to unimplemented procedures", "Inline calls to unimplemented procedures.", Boolean.FALSE, PreferenceType.Boolean),
    INLINE_IMPLEMENTED("Inline calls to implemented procedures", "When to inline calls to implemented procedures.", (Object)((Object)EnableWhen.ALWAYS), PreferenceType.Combo, (Object[])EnableWhen.values()),
    LABEL_IGNORE_CALLS("\u2500\u2500\u2500  I g n o r e  \u2500\u2500\u2500"),
    IGNORE_CALL_FORALL("Ignore calls with 'forall' modifier", "Do not inline calls with forall-star modifier (attempting to inline these can cause exceptions).", Boolean.TRUE, PreferenceType.Boolean),
    IGNORE_WITH_FREE_REQUIRES("Ignore calls to procedures with 'free requires' specifications", "Do not inline calls to procedures with free-requires specification (attempting to inline these can cause exceptions).", Boolean.TRUE, PreferenceType.Boolean),
    IGNORE_POLYMORPHIC("Ignore calls to and inside polymorphic procedures", "Do not inline calls to and inside polymorphic procedures (attempting to inline these can cause exceptions).", Boolean.TRUE, PreferenceType.Boolean),
    IGNORE_RECURSIVE("Ignore calls to recursive procedures", "Do not inline calls to recursive procedures (attempting to inline these can cause exceptions).", Boolean.TRUE, PreferenceType.Boolean),
    IGNORE_MULTIPLE_CALLED("Ignore calls to procedures called more than once", "When to ignore calls to procedures called more than once.", (Object)((Object)EnableWhen.NEVER), PreferenceType.Combo, (Object[])EnableWhen.values()),
    LABEL_USER_LIST("\u2500\u2500\u2500  U s e r   L i s t  \u2500\u2500\u2500"),
    USER_LIST_TYPE("User list type", UserListType.description(), (Object)((Object)UserListType.BLACKLIST_RESTRICT), PreferenceType.Combo, (Object[])UserListType.values()),
    USER_LIST("User list", "Procedure IDs/names separated by whitespace", "", PreferenceType.MultilineString),
    LABEL_ENTRY_PROCEDURE_HANDLING("\u2500\u2500\u2500  E n t r y   P o i n t s  \u2500\u2500\u2500"),
    PROCESS_ONLY_ENTRY_AND_RE_ENTRY_PROCEDURES("Process only entry and re-entry procedures", null, Boolean.TRUE, PreferenceType.Boolean),
    ENTRY_PROCEDURES("Entry procedures", "Procedure IDs/names separated by whitespace.", "ULTIMATE.start", PreferenceType.String),
    ENTRY_PROCEDURE_FALLBACK("Fallback to processing everything", "If no entry procedure can be found, just treat every procedure as potential entry procedure.", Boolean.TRUE, PreferenceType.Boolean),
    ELIMINATE_DEAD_CODE("Remove dead code", "Eliminate dead code after inlining.", Boolean.TRUE, PreferenceType.Boolean);

    private final String mName;
    private final Object mDefaultValue;
    private final PreferenceType mType;
    private final Object[] mChoices;
    private final String mDescription;

    private PreferenceItem(String string2) {
        this(string2, null, null, PreferenceType.Label, null);
    }

    private PreferenceItem(String string2, String string3, Object object, PreferenceType preferenceType) {
        this(string2, string3, object, preferenceType, null);
    }

    private PreferenceItem(String string2, String string3, Object object, PreferenceType preferenceType, Object[] objectArray) {
        this.mName = string2;
        this.mDefaultValue = object;
        this.mType = preferenceType;
        this.mChoices = objectArray;
        this.mDescription = string3;
    }

    public String getName() {
        return this.mName;
    }

    public PreferenceType getType() {
        return this.mType;
    }

    public Object getDefaultValue() {
        return this.mDefaultValue;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public List<String> getStringValueTokens(IUltimateServiceProvider iUltimateServiceProvider) {
        String string = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID).getString(this.mName).trim();
        if (string.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(string.split("\\s+"));
    }

    public UltimatePreferenceItem<?> newUltimatePreferenceItem() {
        return new UltimatePreferenceItem(this.mName, this.mDefaultValue, this.mType, this.mDescription, this.mChoices, null);
    }
}

