/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DownStateConsistencyCheck;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomatonFilteredStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import java.util.Set;
import java.util.function.Consumer;

public class DoubleDeckerAutomatonFilteredStates<LETTER, STATE>
extends NestedWordAutomatonFilteredStates<LETTER, STATE>
implements IDoubleDeckerAutomaton<LETTER, STATE> {
    public DoubleDeckerAutomatonFilteredStates(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, Set<STATE> set, Set<STATE> set2, Set<STATE> set3) throws AutomataOperationCanceledException {
        super(automataLibraryServices, nestedWordAutomatonReachableStates, set, set2, set3);
        assert (new DownStateConsistencyCheck(automataLibraryServices, this).getResult().booleanValue()) : "down states inconsistent";
    }

    public DoubleDeckerAutomatonFilteredStates(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, NestedWordAutomatonReachableStates.AncestorComputation ancestorComputation) throws AutomataOperationCanceledException {
        super(automataLibraryServices, nestedWordAutomatonReachableStates, ancestorComputation);
        assert (new DownStateConsistencyCheck(this.mServices, this).getResult().booleanValue()) : "down states inconsistent";
    }

    private boolean successorOfRemovedStatesAreRemoved() {
        WasStateRemovedChecker wasStateRemovedChecker = new WasStateRemovedChecker();
        for (Object STATE : this.mNwa.getStates()) {
            if (this.mRemainingStates.contains(STATE)) continue;
            NestedWordAutomataUtils.applyToReachableSuccessors(this.mNwa, STATE, wasStateRemovedChecker);
        }
        return wasStateRemovedChecker.doesPropertyHold();
    }

    @Override
    @Deprecated
    public Set<STATE> getDownStates(STATE STATE) {
        if (this.mAncestorComputation != null) {
            return this.mAncestorComputation.getDownStates(STATE, NestedWordAutomatonReachableStates.DoubleDeckerReachability.REACHABLE_AFTER_REMOVAL_OF_PRECIOUS_NOT_REACHERS);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDoubleDecker(STATE STATE, STATE STATE2) {
        return this.mAncestorComputation.isDownState(STATE, STATE2, NestedWordAutomatonReachableStates.DoubleDeckerReachability.REACHABLE_AFTER_REMOVAL_OF_PRECIOUS_NOT_REACHERS);
    }

    private class WasStateRemovedChecker
    implements Consumer<STATE> {
        private boolean mPropertyHolds = true;

        @Override
        public void accept(STATE STATE) {
            boolean bl;
            boolean bl2 = bl = !DoubleDeckerAutomatonFilteredStates.this.mRemainingStates.contains(STATE);
            assert (bl) : "state " + String.valueOf(STATE) + " was not removed but some predecessor was";
            this.mPropertyHolds &= bl;
        }

        public boolean doesPropertyHold() {
            return this.mPropertyHolds;
        }
    }
}

