/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.TypeErrorReporter;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.TypeCheckHelper;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.util.ArithmeticUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExpressionFactory {
    public static final String DUMMY_VOID = "#dummy~void~value";

    public static Expression constructUnaryExpression(ILocation iLocation, UnaryExpression.Operator operator, Expression expression) {
        BoogieType boogieType = TypeCheckHelper.typeCheckUnaryExpression(operator, (BoogieType)expression.getType(), new TypeErrorReporter(iLocation));
        if (ExpressionFactory.isLiteral(expression)) {
            return switch (operator) {
                case UnaryExpression.Operator.ARITHNEGATIVE -> {
                    if (expression instanceof IntegerLiteral) {
                        IntegerLiteral var4_4 = (IntegerLiteral)expression;
                        BigInteger var5_5 = new BigInteger(var4_4.getValue());
                        yield ExpressionFactory.createIntegerLiteral(iLocation, var5_5.negate().toString());
                    }
                    if (expression instanceof RealLiteral) {
                        RealLiteral var5_6 = (RealLiteral)expression;
                        BigDecimal var6_7 = new BigDecimal(var5_6.getValue());
                        yield ExpressionFactory.createRealLiteral(iLocation, var6_7.negate().toString());
                    }
                    throw new IllegalArgumentException("type error: unable to apply " + String.valueOf((Object)operator));
                }
                case UnaryExpression.Operator.LOGICNEG -> {
                    if (expression instanceof BooleanLiteral) {
                        BooleanLiteral var6_8 = (BooleanLiteral)expression;
                        boolean var7_9 = var6_8.getValue();
                        yield ExpressionFactory.createBooleanLiteral(iLocation, !var7_9);
                    }
                    throw new IllegalArgumentException("type error: unable to apply " + String.valueOf((Object)operator));
                }
                case UnaryExpression.Operator.OLD -> expression;
                default -> throw new MatchException(null, null);
            };
        }
        return new UnaryExpression(iLocation, boogieType, operator, expression);
    }

    public static Expression not(ILocation iLocation, Expression expression) {
        return ExpressionFactory.constructUnaryExpression(iLocation, UnaryExpression.Operator.LOGICNEG, expression);
    }

    public static Expression newBinaryExpression(ILocation iLocation, BinaryExpression.Operator operator, Expression expression, Expression expression2) {
        BinaryExpression binaryExpression;
        boolean bl = ExpressionFactory.isLiteral(expression);
        boolean bl2 = ExpressionFactory.isLiteral(expression2);
        if (!bl && !bl2) {
            return ExpressionFactory.constructBinaryExpression(iLocation, operator, expression, expression2);
        }
        if (!bl && bl2 && ExpressionFactory.isCommutative(operator)) {
            return ExpressionFactory.newBinaryExpression(iLocation, operator, expression2, expression);
        }
        if (bl) {
            if (ExpressionFactory.isNeutralLeft(operator, expression)) {
                return expression2;
            }
            if (ExpressionFactory.isAnnihilatingLeft(operator, expression)) {
                return expression;
            }
        }
        if (bl2) {
            if (ExpressionFactory.isNeutralRight(operator, expression2)) {
                return expression;
            }
            if (ExpressionFactory.isAnnihilatingRight(operator, expression2)) {
                return expression2;
            }
        }
        if (bl && bl2) {
            return ExpressionFactory.computeBinaryExpression(iLocation, operator, expression, expression2);
        }
        if (bl && ExpressionFactory.isCommutative(operator) && expression2 instanceof BinaryExpression && (binaryExpression = (BinaryExpression)expression2).getOperator() == operator && ExpressionFactory.isLiteral(binaryExpression.getLeft())) {
            return ExpressionFactory.newBinaryExpression(iLocation, operator, ExpressionFactory.computeBinaryExpression(iLocation, operator, expression, binaryExpression.getLeft()), binaryExpression.getRight());
        }
        return ExpressionFactory.constructBinaryExpression(iLocation, operator, expression, expression2);
    }

    private static Expression computeBinaryExpression(ILocation iLocation, BinaryExpression.Operator operator, Expression expression, Expression expression2) {
        if (expression instanceof BooleanLiteral) {
            return ExpressionFactory.constructBinExprWithLiteralOpsBool(iLocation, operator, (BooleanLiteral)expression, (BooleanLiteral)expression2);
        }
        if (expression instanceof IntegerLiteral) {
            return ExpressionFactory.constructBinExprWithLiteralOpsInteger(iLocation, operator, (IntegerLiteral)expression, (IntegerLiteral)expression2);
        }
        if (expression instanceof RealLiteral) {
            return ExpressionFactory.constructBinExprWithLiteralOpsReal(iLocation, operator, (RealLiteral)expression, (RealLiteral)expression2);
        }
        if (expression instanceof BitvecLiteral) {
            return ExpressionFactory.constructBinExprWithLiteralOpsBitvector(iLocation, operator, (BitvecLiteral)expression, (BitvecLiteral)expression2);
        }
        throw new UnsupportedOperationException("Unknown literal: " + String.valueOf(((Object)((Object)expression)).getClass()));
    }

    private static BooleanLiteral constructBinExprWithLiteralOpsBool(ILocation iLocation, BinaryExpression.Operator operator, BooleanLiteral booleanLiteral, BooleanLiteral booleanLiteral2) {
        boolean bl = booleanLiteral.getValue();
        boolean bl2 = booleanLiteral2.getValue();
        boolean bl3 = switch (operator) {
            case BinaryExpression.Operator.COMPLT, BinaryExpression.Operator.COMPGT, BinaryExpression.Operator.COMPLEQ, BinaryExpression.Operator.COMPGEQ, BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT, BinaryExpression.Operator.ARITHPLUS, BinaryExpression.Operator.ARITHMINUS, BinaryExpression.Operator.ARITHMUL, BinaryExpression.Operator.ARITHDIV, BinaryExpression.Operator.ARITHMOD -> throw new IllegalArgumentException("type error: unable to apply " + String.valueOf((Object)operator) + " to bool");
            case BinaryExpression.Operator.COMPEQ -> {
                if (bl == bl2) {
                    yield true;
                }
                yield false;
            }
            case BinaryExpression.Operator.COMPNEQ -> bl ^ bl2;
            case BinaryExpression.Operator.LOGICAND -> {
                if (bl && bl2) {
                    yield true;
                }
                yield false;
            }
            case BinaryExpression.Operator.LOGICIFF -> {
                if (bl == bl2) {
                    yield true;
                }
                yield false;
            }
            case BinaryExpression.Operator.LOGICIMPLIES -> {
                if (bl && !bl2) {
                    yield false;
                }
                yield true;
            }
            case BinaryExpression.Operator.LOGICOR -> {
                if (!bl && !bl2) {
                    yield false;
                }
                yield true;
            }
            default -> throw new MatchException(null, null);
        };
        return ExpressionFactory.createBooleanLiteral(iLocation, bl3);
    }

    private static Expression constructBinExprWithLiteralOpsInteger(ILocation iLocation, BinaryExpression.Operator operator, IntegerLiteral integerLiteral, IntegerLiteral integerLiteral2) {
        BigInteger bigInteger = new BigInteger(integerLiteral.getValue());
        BigInteger bigInteger2 = new BigInteger(integerLiteral2.getValue());
        return switch (operator) {
            case BinaryExpression.Operator.ARITHDIV -> {
                BigInteger var6_6 = ArithmeticUtils.euclideanDiv((BigInteger)bigInteger, (BigInteger)bigInteger2);
                yield ExpressionFactory.createIntegerLiteral(iLocation, var6_6.toString());
            }
            case BinaryExpression.Operator.ARITHMINUS -> {
                BigInteger var6_7 = bigInteger.subtract(bigInteger2);
                yield ExpressionFactory.createIntegerLiteral(iLocation, var6_7.toString());
            }
            case BinaryExpression.Operator.ARITHMOD -> {
                BigInteger var6_8 = ArithmeticUtils.euclideanMod((BigInteger)bigInteger, (BigInteger)bigInteger2);
                yield ExpressionFactory.createIntegerLiteral(iLocation, var6_8.toString());
            }
            case BinaryExpression.Operator.ARITHMUL -> {
                BigInteger var6_9 = bigInteger.multiply(bigInteger2);
                yield ExpressionFactory.createIntegerLiteral(iLocation, var6_9.toString());
            }
            case BinaryExpression.Operator.ARITHPLUS -> {
                BigInteger var6_10 = bigInteger.add(bigInteger2);
                yield ExpressionFactory.createIntegerLiteral(iLocation, var6_10.toString());
            }
            case BinaryExpression.Operator.COMPEQ -> {
                boolean var6_11 = bigInteger.compareTo(bigInteger2) == 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_11);
            }
            case BinaryExpression.Operator.COMPGEQ -> {
                boolean var6_12 = bigInteger.compareTo(bigInteger2) >= 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_12);
            }
            case BinaryExpression.Operator.COMPGT -> {
                boolean var6_13 = bigInteger.compareTo(bigInteger2) > 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_13);
            }
            case BinaryExpression.Operator.COMPLEQ -> {
                boolean var6_14 = bigInteger.compareTo(bigInteger2) <= 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_14);
            }
            case BinaryExpression.Operator.COMPLT -> {
                boolean var6_15 = bigInteger.compareTo(bigInteger2) < 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_15);
            }
            case BinaryExpression.Operator.COMPNEQ -> {
                boolean var6_16 = bigInteger.compareTo(bigInteger2) != 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_16);
            }
            case BinaryExpression.Operator.LOGICIFF, BinaryExpression.Operator.LOGICIMPLIES, BinaryExpression.Operator.LOGICAND, BinaryExpression.Operator.LOGICOR, BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT -> throw new IllegalArgumentException("type error: unable to apply " + String.valueOf((Object)operator) + " to bool");
            default -> throw new MatchException(null, null);
        };
    }

    private static Expression constructBinExprWithLiteralOpsReal(ILocation iLocation, BinaryExpression.Operator operator, RealLiteral realLiteral, RealLiteral realLiteral2) {
        Rational rational = ExpressionFactory.toRational(realLiteral.getValue());
        Rational rational2 = ExpressionFactory.toRational(realLiteral2.getValue());
        return switch (operator) {
            case BinaryExpression.Operator.ARITHDIV -> {
                Rational var6_6 = rational.div(rational2);
                yield new RealLiteral(iLocation, BoogieType.TYPE_REAL, var6_6.toString());
            }
            case BinaryExpression.Operator.ARITHMINUS -> {
                Rational var6_7 = rational.sub(rational2);
                yield new RealLiteral(iLocation, BoogieType.TYPE_REAL, var6_7.toString());
            }
            case BinaryExpression.Operator.ARITHMUL -> {
                Rational var6_8 = rational.mul(rational2);
                yield new RealLiteral(iLocation, BoogieType.TYPE_REAL, var6_8.toString());
            }
            case BinaryExpression.Operator.ARITHPLUS -> {
                Rational var6_9 = rational.add(rational2);
                yield new RealLiteral(iLocation, BoogieType.TYPE_REAL, var6_9.toString());
            }
            case BinaryExpression.Operator.COMPEQ -> {
                boolean var6_10 = rational.compareTo(rational2) >= 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_10);
            }
            case BinaryExpression.Operator.COMPGEQ -> {
                boolean var6_11 = rational.compareTo(rational2) >= 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_11);
            }
            case BinaryExpression.Operator.COMPGT -> {
                boolean var6_12 = rational.compareTo(rational2) >= 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_12);
            }
            case BinaryExpression.Operator.COMPLEQ -> {
                boolean var6_13 = rational.compareTo(rational2) >= 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_13);
            }
            case BinaryExpression.Operator.COMPLT -> {
                boolean var6_14 = rational.compareTo(rational2) >= 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_14);
            }
            case BinaryExpression.Operator.COMPNEQ -> {
                boolean var6_15 = rational.compareTo(rational2) >= 0;
                yield ExpressionFactory.createBooleanLiteral(iLocation, var6_15);
            }
            case BinaryExpression.Operator.LOGICIFF, BinaryExpression.Operator.LOGICIMPLIES, BinaryExpression.Operator.LOGICAND, BinaryExpression.Operator.LOGICOR, BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT, BinaryExpression.Operator.ARITHMOD -> throw new IllegalArgumentException("type error: unable to apply " + String.valueOf((Object)operator) + " to bool");
            default -> throw new MatchException(null, null);
        };
    }

    private static Expression constructBinExprWithLiteralOpsBitvector(ILocation iLocation, BinaryExpression.Operator operator, BitvecLiteral bitvecLiteral, BitvecLiteral bitvecLiteral2) {
        BigInteger bigInteger = new BigInteger(bitvecLiteral.getValue());
        BigInteger bigInteger2 = new BigInteger(bitvecLiteral2.getValue());
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("assumed non-negative number here!");
        }
        if (bigInteger2.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("assumed non-negativenumber here!");
        }
        int n = bitvecLiteral.getLength();
        int n2 = bitvecLiteral2.getLength();
        return switch (operator) {
            case BinaryExpression.Operator.COMPEQ -> {
                if (n != n2) {
                    throw new IllegalArgumentException("type error: cannot compare bitvectors of differnt lengths");
                }
                boolean var8_8 = bigInteger.equals(bigInteger2);
                yield ExpressionFactory.createBooleanLiteral(iLocation, var8_8);
            }
            case BinaryExpression.Operator.COMPNEQ -> {
                if (n != n2) {
                    throw new IllegalArgumentException("type error: cannot compare bitvectors of differnt lengths");
                }
                boolean var8_9 = !bigInteger.equals(bigInteger2);
                yield ExpressionFactory.createBooleanLiteral(iLocation, var8_9);
            }
            case BinaryExpression.Operator.BITVECCONCAT -> throw new UnsupportedOperationException("not yet implemented " + String.valueOf((Object)operator));
            case BinaryExpression.Operator.LOGICIFF, BinaryExpression.Operator.LOGICIMPLIES, BinaryExpression.Operator.LOGICAND, BinaryExpression.Operator.LOGICOR, BinaryExpression.Operator.COMPLT, BinaryExpression.Operator.COMPGT, BinaryExpression.Operator.COMPLEQ, BinaryExpression.Operator.COMPGEQ, BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.ARITHPLUS, BinaryExpression.Operator.ARITHMINUS, BinaryExpression.Operator.ARITHMUL, BinaryExpression.Operator.ARITHDIV, BinaryExpression.Operator.ARITHMOD -> throw new IllegalArgumentException("type error: unable to apply " + String.valueOf((Object)operator) + " to bool");
            default -> throw new MatchException(null, null);
        };
    }

    public static Expression constructIfThenElseExpression(ILocation iLocation, Expression expression, Expression expression2, Expression expression3) {
        if (expression instanceof BooleanLiteral) {
            boolean bl = ((BooleanLiteral)expression).getValue();
            if (bl) {
                return expression2;
            }
            return expression3;
        }
        BoogieType boogieType = TypeCheckHelper.typeCheckIfThenElseExpression((BoogieType)expression.getType(), (BoogieType)expression2.getType(), (BoogieType)expression3.getType(), new TypeErrorReporter(iLocation));
        return new IfThenElseExpression(iLocation, boogieType, expression, expression2, expression3);
    }

    private static boolean isLiteral(Expression expression) {
        return expression instanceof IntegerLiteral || expression instanceof BooleanLiteral || expression instanceof BitvecLiteral || expression instanceof RealLiteral;
    }

    public static boolean isTrueLiteral(Expression expression) {
        return ExpressionFactory.isBooleanLiteral(expression, true);
    }

    public static boolean isFalseLiteral(Expression expression) {
        return ExpressionFactory.isBooleanLiteral(expression, false);
    }

    public static boolean isBooleanLiteral(Expression expression, boolean bl) {
        if (expression instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)expression;
            return booleanLiteral.getValue() == bl;
        }
        return false;
    }

    public static Expression constructBitvectorAccessExpression(ILocation iLocation, Expression expression, int n, int n2) {
        BoogieType boogieType = TypeCheckHelper.typeCheckBitVectorAccessExpression(TypeCheckHelper.getBitVecLength((BoogieType)expression.getType()), n, n2, (BoogieType)expression.getType(), new TypeErrorReporter(iLocation));
        if (expression instanceof BitvecLiteral) {
            return ExpressionFactory.constructBitvectorAccessExpressionResult(iLocation, (BitvecLiteral)expression, n, n2, boogieType);
        }
        return new BitVectorAccessExpression(iLocation, boogieType, expression, n, n2);
    }

    public static Expression constructBitvectorAccessExpressionResult(ILocation iLocation, BitvecLiteral bitvecLiteral, int n, int n2, BoogieType boogieType) {
        BigInteger bigInteger = ExpressionFactory.constructBitvectorAccessExpressionResult(new BigInteger(bitvecLiteral.getValue()), n, n2);
        return new BitvecLiteral(iLocation, boogieType, bigInteger.toString(), n - n2);
    }

    public static BigInteger constructBitvectorAccessExpressionResult(BigInteger bigInteger, int n, int n2) {
        BigInteger bigInteger2 = BigInteger.valueOf(2L);
        BigInteger bigInteger3 = bigInteger.divide(bigInteger2.pow(n2));
        return bigInteger3.mod(bigInteger2.pow(n));
    }

    public static Expression and(ILocation iLocation, List<Expression> list) {
        return ExpressionFactory.bin(iLocation, list, true, BinaryExpression.Operator.LOGICAND);
    }

    public static Expression or(ILocation iLocation, List<Expression> list) {
        return ExpressionFactory.bin(iLocation, list, false, BinaryExpression.Operator.LOGICOR);
    }

    public static Expression or(ILocation iLocation, Expression ... expressionArray) {
        return ExpressionFactory.or(iLocation, Arrays.asList(expressionArray));
    }

    private static Expression bin(ILocation iLocation, List<Expression> list, boolean bl, BinaryExpression.Operator operator) {
        if (list == null || list.isEmpty()) {
            return ExpressionFactory.createBooleanLiteral(iLocation, bl);
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        Iterator<Expression> iterator = list.iterator();
        Expression expression = iterator.next();
        while (iterator.hasNext()) {
            expression = ExpressionFactory.newBinaryExpression(iLocation, operator, expression, iterator.next());
        }
        return expression;
    }

    public static StructConstructor constructStructConstructor(ILocation iLocation, String[] stringArray, Expression[] expressionArray) {
        assert (stringArray.length == expressionArray.length);
        BoogieType[] boogieTypeArray = new BoogieType[stringArray.length];
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            boogieTypeArray[n] = (BoogieType)expressionArray[n].getType();
            bl |= expressionArray[n].getType().equals(BoogieType.TYPE_ERROR);
            ++n;
        }
        BoogiePrimitiveType boogiePrimitiveType = bl ? BoogieType.TYPE_ERROR : BoogieType.createStructType(stringArray, boogieTypeArray);
        return new StructConstructor(iLocation, boogiePrimitiveType, stringArray, expressionArray);
    }

    public static StructLHS constructStructAccessLhs(ILocation iLocation, LeftHandSide leftHandSide, String string) {
        BoogieType boogieType = TypeCheckHelper.typeCheckStructAccessExpressionOrLhs((BoogieType)leftHandSide.getType(), string, new TypeErrorReporter(iLocation));
        return new StructLHS(iLocation, boogieType, leftHandSide, string);
    }

    public static ArrayAccessExpression constructNestedArrayAccessExpression(ILocation iLocation, Expression expression2, Expression[] expressionArray) {
        if (expressionArray.length == 0) {
            throw new AssertionError((Object)"attempting to build array access without indices");
        }
        if (expressionArray.length == 1) {
            BoogieArrayType boogieArrayType = (BoogieArrayType)expression2.getType();
            List<BoogieType> list = Arrays.stream(expressionArray).map(expression -> (BoogieType)expression.getType()).collect(Collectors.toList());
            BoogieType boogieType = TypeCheckHelper.typeCheckArrayAccessExpressionOrLhs(boogieArrayType, list, new TypeErrorReporter(iLocation));
            return new ArrayAccessExpression(iLocation, boogieType, expression2, expressionArray);
        }
        Expression[] expressionArray2 = Arrays.copyOfRange(expressionArray, 0, expressionArray.length - 1);
        ArrayAccessExpression arrayAccessExpression = ExpressionFactory.constructNestedArrayAccessExpression(iLocation, expression2, expressionArray2);
        Expression expression3 = expressionArray[expressionArray.length - 1];
        Expression[] expressionArray3 = new Expression[]{expression3};
        BoogieArrayType boogieArrayType = (BoogieArrayType)arrayAccessExpression.getType();
        BoogieType boogieType = TypeCheckHelper.typeCheckArrayAccessExpressionOrLhs(boogieArrayType, Arrays.asList((BoogieType)expression3.getType()), new TypeErrorReporter(iLocation));
        return new ArrayAccessExpression(iLocation, boogieType, arrayAccessExpression, expressionArray3);
    }

    public static ArrayLHS constructNestedArrayLHS(ILocation iLocation, LeftHandSide leftHandSide, Expression[] expressionArray) {
        if (expressionArray.length == 0) {
            throw new AssertionError((Object)"attempting to build array access without indices");
        }
        assert (expressionArray[0].getType() != null);
        assert (leftHandSide.getType() != null);
        if (expressionArray.length == 1) {
            BoogieArrayType boogieArrayType = (BoogieArrayType)leftHandSide.getType();
            List<BoogieType> list = Arrays.stream(expressionArray).map(expression -> (BoogieType)expression.getType()).collect(Collectors.toList());
            BoogieType boogieType = TypeCheckHelper.typeCheckArrayAccessExpressionOrLhs(boogieArrayType, list, new TypeErrorReporter(iLocation));
            return new ArrayLHS(iLocation, boogieType, leftHandSide, expressionArray);
        }
        Expression[] expressionArray2 = Arrays.copyOfRange(expressionArray, 0, expressionArray.length - 1);
        ArrayLHS arrayLHS = ExpressionFactory.constructNestedArrayLHS(iLocation, leftHandSide, expressionArray2);
        Expression expression2 = expressionArray[expressionArray.length - 1];
        Expression[] expressionArray3 = new Expression[]{expression2};
        BoogieArrayType boogieArrayType = (BoogieArrayType)arrayLHS.getType();
        BoogieType boogieType = TypeCheckHelper.typeCheckArrayAccessExpressionOrLhs(boogieArrayType, Arrays.asList((BoogieType)expression2.getType()), new TypeErrorReporter(iLocation));
        return new ArrayLHS(iLocation, boogieType, arrayLHS, expressionArray3);
    }

    public static IdentifierExpression constructIdentifierExpression(ILocation iLocation, BoogieType boogieType, String string, DeclarationInformation declarationInformation) {
        assert (iLocation != null && boogieType != null && string != null && declarationInformation != null);
        return new IdentifierExpression(iLocation, boogieType, string, declarationInformation);
    }

    public static VariableLHS constructVariableLHS(ILocation iLocation, BoogieType boogieType, String string, DeclarationInformation declarationInformation) {
        assert (iLocation != null && boogieType != null && string != null && declarationInformation != null);
        return new VariableLHS(iLocation, boogieType, string, declarationInformation);
    }

    public static ArrayStoreExpression constructArrayStoreExpression(ILocation iLocation, Expression expression, Expression[] expressionArray, Expression expression2) {
        Object object;
        ArrayList<BoogieType> arrayList = new ArrayList<BoogieType>();
        Expression[] expressionArray2 = expressionArray;
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = expressionArray2[n2];
            arrayList.add((BoogieType)object.getType());
            ++n2;
        }
        object = TypeCheckHelper.typeCheckArrayStoreExpression((BoogieType)expression.getType(), arrayList, (BoogieType)expression2.getType(), new TypeErrorReporter(iLocation));
        return new ArrayStoreExpression(iLocation, (IBoogieType)object, expression, expressionArray, expression2);
    }

    private static BinaryExpression constructBinaryExpression(ILocation iLocation, BinaryExpression.Operator operator, Expression expression, Expression expression2) {
        BoogieType boogieType = TypeCheckHelper.typeCheckBinaryExpression(operator, (BoogieType)expression.getType(), (BoogieType)expression2.getType(), new TypeErrorReporter(iLocation));
        return new BinaryExpression(iLocation, boogieType, operator, expression, expression2);
    }

    public static Expression constructFunctionApplication(ILocation iLocation, String string, Expression[] expressionArray, BoogieType boogieType) {
        return new FunctionApplication(iLocation, boogieType, string, expressionArray);
    }

    public static StructAccessExpression constructStructAccessExpression(ILocation iLocation, Expression expression, String string) {
        BoogieType boogieType = TypeCheckHelper.typeCheckStructAccessExpressionOrLhs((BoogieType)expression.getType(), string, new TypeErrorReporter(iLocation));
        return new StructAccessExpression(iLocation, boogieType, expression, string);
    }

    public static BooleanLiteral createBooleanLiteral(ILocation iLocation, boolean bl) {
        return new BooleanLiteral(iLocation, BoogieType.TYPE_BOOL, bl);
    }

    public static IntegerLiteral createIntegerLiteral(ILocation iLocation, String string) {
        return new IntegerLiteral(iLocation, BoogieType.TYPE_INT, string);
    }

    public static BitvecLiteral createBitvecLiteral(ILocation iLocation, String string, int n) {
        return new BitvecLiteral(iLocation, BoogieType.createBitvectorType(n), string, n);
    }

    public static Expression createBitvecLiteral(ILocation iLocation, BigInteger bigInteger, int n) {
        BigInteger bigInteger2;
        if (bigInteger.signum() == -1) {
            bigInteger2 = BigInteger.valueOf(2L).pow(n);
            bigInteger = bigInteger.add(bigInteger2);
        }
        bigInteger2 = ExpressionFactory.constructBitvectorInRange(bigInteger, n);
        return ExpressionFactory.createBitvecLiteral(iLocation, bigInteger2.toString(), n);
    }

    private static BigInteger constructBitvectorInRange(BigInteger bigInteger, int n) {
        return bigInteger.mod(BigInteger.TWO.pow(n));
    }

    public static RealLiteral createRealLiteral(ILocation iLocation, String string) {
        return new RealLiteral(iLocation, BoogieType.TYPE_REAL, string);
    }

    public static StringLiteral createStringLiteral(ILocation iLocation, String string) {
        return new StringLiteral(iLocation, string);
    }

    public static IdentifierExpression createVoidDummyExpression(ILocation iLocation) {
        return ExpressionFactory.constructIdentifierExpression(iLocation, BoogieType.TYPE_ERROR, DUMMY_VOID, DeclarationInformation.DECLARATIONINFO_GLOBAL);
    }

    public static Expression replaceBoogieType(Expression expression, BoogieType boogieType) {
        return ExpressionFactory.modifyExpression(expression, iLocation -> iLocation, boogieType2 -> boogieType);
    }

    public static Expression modifyExpression(Expression expression, Function<ILocation, ILocation> function, Function<BoogieType, BoogieType> function2) {
        ILocation iLocation = function.apply(expression.getLoc());
        BoogieType boogieType = function2.apply((BoogieType)expression.getType());
        assert (boogieType != null);
        assert (iLocation != null);
        if (expression instanceof ArrayAccessExpression) {
            return new ArrayAccessExpression(iLocation, boogieType, ((ArrayAccessExpression)expression).getArray(), ((ArrayAccessExpression)expression).getIndices());
        }
        if (expression instanceof ArrayStoreExpression) {
            return new ArrayStoreExpression(iLocation, boogieType, ((ArrayStoreExpression)expression).getArray(), ((ArrayStoreExpression)expression).getIndices(), ((ArrayStoreExpression)expression).getValue());
        }
        if (expression instanceof BinaryExpression) {
            return new BinaryExpression(iLocation, boogieType, ((BinaryExpression)expression).getOperator(), ((BinaryExpression)expression).getLeft(), ((BinaryExpression)expression).getRight());
        }
        if (expression instanceof BitvecLiteral) {
            return new BitvecLiteral(iLocation, boogieType, ((BitvecLiteral)expression).getValue(), ((BitvecLiteral)expression).getLength());
        }
        if (expression instanceof BitVectorAccessExpression) {
            return new BitVectorAccessExpression(iLocation, boogieType, ((BitVectorAccessExpression)expression).getBitvec(), ((BitVectorAccessExpression)expression).getStart(), ((BitVectorAccessExpression)expression).getEnd());
        }
        if (expression instanceof FunctionApplication) {
            return new FunctionApplication(iLocation, boogieType, ((FunctionApplication)expression).getIdentifier(), ((FunctionApplication)expression).getArguments());
        }
        if (expression instanceof IdentifierExpression) {
            return new IdentifierExpression(iLocation, boogieType, ((IdentifierExpression)expression).getIdentifier(), ((IdentifierExpression)expression).getDeclarationInformation());
        }
        if (expression instanceof StructConstructor) {
            return new StructConstructor(iLocation, boogieType, ((StructConstructor)expression).getFieldIdentifiers(), ((StructConstructor)expression).getFieldValues());
        }
        if (expression instanceof StructAccessExpression) {
            return new StructAccessExpression(iLocation, boogieType, ((StructAccessExpression)expression).getStruct(), ((StructAccessExpression)expression).getField());
        }
        throw new AssertionError((Object)("unexpected expression type: " + String.valueOf(((Object)((Object)expression)).getClass())));
    }

    public static Expression constructBooleanWildCardExpression(ILocation iLocation) {
        return new WildcardExpression(iLocation, BoogieType.TYPE_BOOL);
    }

    private static boolean isNeutralLeft(BinaryExpression.Operator operator, Expression expression) {
        return switch (operator) {
            case BinaryExpression.Operator.ARITHMUL -> {
                if (expression instanceof IntegerLiteral) {
                    IntegerLiteral var2_2 = (IntegerLiteral)expression;
                    yield new BigInteger(var2_2.getValue()).equals(BigInteger.ONE);
                }
                if (expression instanceof RealLiteral) {
                    RealLiteral var3_3 = (RealLiteral)expression;
                    yield ExpressionFactory.toRational(var3_3.getValue()).equals((Object)Rational.ONE);
                }
                yield false;
            }
            case BinaryExpression.Operator.ARITHPLUS -> {
                if (expression instanceof IntegerLiteral) {
                    IntegerLiteral var4_4 = (IntegerLiteral)expression;
                    if (new BigInteger(var4_4.getValue()).signum() == 0) {
                        yield true;
                    }
                    yield false;
                }
                if (expression instanceof RealLiteral) {
                    RealLiteral var5_5 = (RealLiteral)expression;
                    if (ExpressionFactory.toRational(var5_5.getValue()).signum() == 0) {
                        yield true;
                    }
                    yield false;
                }
                yield false;
            }
            case BinaryExpression.Operator.LOGICIMPLIES, BinaryExpression.Operator.LOGICAND -> {
                BooleanLiteral var6_6;
                if (expression instanceof BooleanLiteral && (var6_6 = (BooleanLiteral)expression).getValue()) {
                    yield true;
                }
                yield false;
            }
            case BinaryExpression.Operator.LOGICOR -> {
                BooleanLiteral var7_7;
                if (expression instanceof BooleanLiteral && !(var7_7 = (BooleanLiteral)expression).getValue()) {
                    yield true;
                }
                yield false;
            }
            case BinaryExpression.Operator.LOGICIFF, BinaryExpression.Operator.COMPLT, BinaryExpression.Operator.COMPGT, BinaryExpression.Operator.COMPLEQ, BinaryExpression.Operator.COMPGEQ, BinaryExpression.Operator.COMPEQ, BinaryExpression.Operator.COMPNEQ, BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT, BinaryExpression.Operator.ARITHMINUS, BinaryExpression.Operator.ARITHDIV, BinaryExpression.Operator.ARITHMOD -> false;
            default -> throw new MatchException(null, null);
        };
    }

    private static boolean isNeutralRight(BinaryExpression.Operator operator, Expression expression) {
        return switch (operator) {
            case BinaryExpression.Operator.LOGICIFF, BinaryExpression.Operator.LOGICAND, BinaryExpression.Operator.LOGICOR, BinaryExpression.Operator.COMPEQ, BinaryExpression.Operator.COMPNEQ, BinaryExpression.Operator.ARITHPLUS, BinaryExpression.Operator.ARITHMUL -> ExpressionFactory.isNeutralLeft(operator, expression);
            case BinaryExpression.Operator.ARITHDIV -> ExpressionFactory.isNeutralLeft(BinaryExpression.Operator.ARITHMUL, expression);
            case BinaryExpression.Operator.ARITHMINUS -> ExpressionFactory.isNeutralLeft(BinaryExpression.Operator.ARITHPLUS, expression);
            case BinaryExpression.Operator.LOGICIMPLIES, BinaryExpression.Operator.COMPLT, BinaryExpression.Operator.COMPGT, BinaryExpression.Operator.COMPLEQ, BinaryExpression.Operator.COMPGEQ, BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT, BinaryExpression.Operator.ARITHMOD -> false;
            default -> throw new MatchException(null, null);
        };
    }

    private static boolean isCommutative(BinaryExpression.Operator operator) {
        return switch (operator) {
            case BinaryExpression.Operator.LOGICIFF, BinaryExpression.Operator.LOGICAND, BinaryExpression.Operator.LOGICOR, BinaryExpression.Operator.COMPEQ, BinaryExpression.Operator.COMPNEQ, BinaryExpression.Operator.ARITHPLUS, BinaryExpression.Operator.ARITHMUL -> true;
            case BinaryExpression.Operator.LOGICIMPLIES, BinaryExpression.Operator.COMPLT, BinaryExpression.Operator.COMPGT, BinaryExpression.Operator.COMPLEQ, BinaryExpression.Operator.COMPGEQ, BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT, BinaryExpression.Operator.ARITHMINUS, BinaryExpression.Operator.ARITHDIV, BinaryExpression.Operator.ARITHMOD -> false;
            default -> throw new MatchException(null, null);
        };
    }

    private static boolean isAnnihilatingLeft(BinaryExpression.Operator operator, Expression expression) {
        return switch (operator) {
            case BinaryExpression.Operator.ARITHMUL -> {
                if (expression instanceof IntegerLiteral) {
                    IntegerLiteral var2_2 = (IntegerLiteral)expression;
                    if (new BigInteger(var2_2.getValue()).signum() == 0) {
                        yield true;
                    }
                    yield false;
                }
                if (expression instanceof RealLiteral) {
                    RealLiteral var3_3 = (RealLiteral)expression;
                    if (ExpressionFactory.toRational(var3_3.getValue()).signum() == 0) {
                        yield true;
                    }
                    yield false;
                }
                yield false;
            }
            case BinaryExpression.Operator.LOGICAND -> {
                BooleanLiteral var4_4;
                if (expression instanceof BooleanLiteral && !(var4_4 = (BooleanLiteral)expression).getValue()) {
                    yield true;
                }
                yield false;
            }
            case BinaryExpression.Operator.LOGICOR -> {
                BooleanLiteral var5_5;
                if (expression instanceof BooleanLiteral && (var5_5 = (BooleanLiteral)expression).getValue()) {
                    yield true;
                }
                yield false;
            }
            case BinaryExpression.Operator.LOGICIFF, BinaryExpression.Operator.LOGICIMPLIES, BinaryExpression.Operator.COMPLT, BinaryExpression.Operator.COMPGT, BinaryExpression.Operator.COMPLEQ, BinaryExpression.Operator.COMPGEQ, BinaryExpression.Operator.COMPEQ, BinaryExpression.Operator.COMPNEQ, BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT, BinaryExpression.Operator.ARITHPLUS, BinaryExpression.Operator.ARITHMINUS, BinaryExpression.Operator.ARITHDIV, BinaryExpression.Operator.ARITHMOD -> false;
            default -> throw new MatchException(null, null);
        };
    }

    private static boolean isAnnihilatingRight(BinaryExpression.Operator operator, Expression expression) {
        return switch (operator) {
            case BinaryExpression.Operator.LOGICIFF, BinaryExpression.Operator.LOGICAND, BinaryExpression.Operator.LOGICOR, BinaryExpression.Operator.COMPEQ, BinaryExpression.Operator.COMPNEQ, BinaryExpression.Operator.ARITHPLUS, BinaryExpression.Operator.ARITHMUL -> ExpressionFactory.isAnnihilatingLeft(operator, expression);
            case BinaryExpression.Operator.LOGICIMPLIES, BinaryExpression.Operator.COMPLT, BinaryExpression.Operator.COMPGT, BinaryExpression.Operator.COMPLEQ, BinaryExpression.Operator.COMPGEQ, BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT, BinaryExpression.Operator.ARITHMINUS, BinaryExpression.Operator.ARITHDIV, BinaryExpression.Operator.ARITHMOD -> false;
            default -> throw new MatchException(null, null);
        };
    }

    private static Rational toRational(String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length == 2) {
            return Rational.valueOf((BigInteger)new BigInteger(stringArray[0]), (BigInteger)new BigInteger(stringArray[1]));
        }
        if (stringArray.length == 1) {
            return ExpressionFactory.toRational(new BigDecimal(string));
        }
        throw new IllegalArgumentException("Not a valid real literal value: " + string);
    }

    private static Rational toRational(BigDecimal bigDecimal) {
        Rational rational;
        if (bigDecimal.scale() <= 0) {
            BigInteger bigInteger = bigDecimal.toBigInteger();
            rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
        } else {
            BigInteger bigInteger = bigDecimal.unscaledValue();
            BigInteger bigInteger2 = BigInteger.TEN.pow(bigDecimal.scale());
            rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)bigInteger2);
        }
        return rational;
    }

    public static QuantifierExpression quantifier(ILocation iLocation, boolean bl, List<VarList> list, Expression expression) {
        return new QuantifierExpression(iLocation, BoogieType.TYPE_BOOL, bl, new String[0], (VarList[])list.toArray(VarList[]::new), new Attribute[0], expression);
    }
}

