/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.type;

import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieConstructedType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePlaceholderType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieTypeConstructor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import java.util.ArrayList;
import java.util.Map;

public class StructExpanderUtil {
    public static final String ATTRIBUTE_EXPAND_STRUCT = "expand_struct";
    public static final String ATTRIBUTE_BUILTIN = "builtin";
    public static final String ATTRIBUTE_CONST_ARRAY = "const_array";
    public static final String ATTRIBUTE_STRUCTPOS = "structpos";
    public static final String DOT = ".";

    private StructExpanderUtil() {
    }

    public static BoogieType createStructWrapperType(BoogieStructType boogieStructType, Map<String, BoogieTypeConstructor> map) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("struct");
        String[] stringArray = boogieStructType.getFieldIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            stringBuilder.append('~').append(string);
            ++n2;
        }
        string = stringBuilder.toString();
        BoogieTypeConstructor boogieTypeConstructor = map.get(string);
        if (boogieTypeConstructor == null) {
            int[] nArray = new int[boogieStructType.getFieldCount()];
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = n3;
                ++n3;
            }
            boogieTypeConstructor = new BoogieTypeConstructor(string, false, boogieStructType.getFieldCount(), nArray);
            map.put(string, boogieTypeConstructor);
        }
        BoogieType[] boogieTypeArray = new BoogieType[boogieStructType.getFieldCount()];
        int n4 = 0;
        while (n4 < boogieTypeArray.length) {
            boogieTypeArray[n4] = boogieStructType.getFieldType(n4);
            ++n4;
        }
        return BoogieType.createConstructedType(boogieTypeConstructor, boogieTypeArray);
    }

    public static BoogieType flattenType(IBoogieType iBoogieType, Map<BoogieType, BoogieType> map, Map<String, BoogieTypeConstructor> map2) {
        BoogieType boogieType;
        BoogieType boogieType2 = ((BoogieType)iBoogieType).getUnderlyingType();
        if (map.containsKey(boogieType2)) {
            return map.get(boogieType2);
        }
        if (boogieType2 instanceof BoogiePrimitiveType) {
            boogieType = boogieType2;
        } else if (boogieType2 instanceof BoogieConstructedType) {
            BoogieConstructedType boogieConstructedType = (BoogieConstructedType)boogieType2;
            int n = boogieConstructedType.getParameterCount();
            BoogieType[] boogieTypeArray = new BoogieType[n];
            int n2 = 0;
            while (n2 < boogieTypeArray.length) {
                boogieTypeArray[n2] = StructExpanderUtil.flattenType(boogieConstructedType.getParameter(n2), map, map2);
                if (boogieTypeArray[n2] instanceof BoogieStructType) {
                    BoogieStructType boogieStructType = (BoogieStructType)boogieTypeArray[n2];
                    boogieTypeArray[n2] = StructExpanderUtil.createStructWrapperType(boogieStructType, map2);
                }
                ++n2;
            }
            boogieType = BoogieType.createConstructedType(boogieConstructedType.getConstr(), boogieTypeArray);
        } else if (boogieType2 instanceof BoogieArrayType) {
            BoogieStructType boogieStructType;
            BoogieType boogieType3;
            BoogieArrayType boogieArrayType = (BoogieArrayType)boogieType2;
            ArrayList<BoogieType> arrayList = new ArrayList<BoogieType>();
            int n = 0;
            while (n < boogieArrayType.getIndexCount()) {
                boogieType3 = StructExpanderUtil.flattenType(boogieArrayType.getIndexType(n), map, map2);
                if (boogieType3 instanceof BoogieStructType) {
                    boogieStructType = (BoogieStructType)boogieType3;
                    int n3 = 0;
                    while (n3 < boogieStructType.getFieldCount()) {
                        arrayList.add(boogieStructType.getFieldType(n3));
                        ++n3;
                    }
                } else {
                    arrayList.add(boogieType3);
                }
                ++n;
            }
            BoogieType[] boogieTypeArray = arrayList.toArray(new BoogieType[arrayList.size()]);
            boogieType3 = StructExpanderUtil.flattenType(boogieArrayType.getValueType(), map, map2);
            if (boogieType3 instanceof BoogieStructType) {
                boogieStructType = (BoogieStructType)boogieType3;
                String[] stringArray = boogieStructType.getFieldIds();
                BoogieType[] boogieTypeArray2 = new BoogieType[stringArray.length];
                int n4 = 0;
                while (n4 < stringArray.length) {
                    boogieTypeArray2[n4] = BoogieType.createArrayType(boogieArrayType.getNumPlaceholders(), boogieTypeArray, boogieStructType.getFieldType(n4));
                    ++n4;
                }
                boogieType = BoogieType.createStructType(stringArray, boogieTypeArray2);
            } else {
                boogieType = BoogieType.createArrayType(boogieArrayType.getNumPlaceholders(), boogieTypeArray, boogieType3);
            }
        } else if (boogieType2 instanceof BoogieStructType) {
            BoogieType[] boogieTypeArray;
            BoogieStructType boogieStructType = (BoogieStructType)boogieType2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<BoogieType> arrayList2 = new ArrayList<BoogieType>();
            int n = 0;
            while (n < boogieStructType.getFieldCount()) {
                boogieTypeArray = boogieStructType.getFieldIds()[n];
                BoogieType boogieType4 = StructExpanderUtil.flattenType(boogieStructType.getFieldType(n), map, map2);
                if (boogieType4 instanceof BoogieStructType) {
                    BoogieStructType boogieStructType2 = (BoogieStructType)boogieType4;
                    int n5 = 0;
                    while (n5 < boogieStructType2.getFieldCount()) {
                        arrayList.add((String)boogieTypeArray + DOT + boogieStructType2.getFieldIds()[n5]);
                        arrayList2.add(boogieStructType2.getFieldType(n5));
                        ++n5;
                    }
                } else {
                    arrayList.add(boogieTypeArray);
                    arrayList2.add(boogieType4);
                }
                ++n;
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            boogieTypeArray = arrayList2.toArray(new BoogieType[arrayList2.size()]);
            boogieType = BoogieType.createStructType(stringArray, boogieTypeArray);
        } else if (boogieType2 instanceof BoogiePlaceholderType) {
            boogieType = boogieType2;
        } else {
            throw new AssertionError((Object)("Unknown ASTType " + String.valueOf(boogieType2)));
        }
        map.put(boogieType2, boogieType);
        return boogieType;
    }
}

