/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.FindBindingReferences;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.SymbolTableValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;

public class ThreadIdManager {
    private static final boolean UNAMBIGUOUS_THREAD_ID_OPTIMIZATION = true;
    private static final boolean SYMBOL_TABLE_BASED_REFERENCE_SEARCH = true;
    private final Collection<IASTTranslationUnit> mTranslationUnits;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final ExpressionResultTransformer mExpressionResultTransformer;
    private final ExpressionTranslation mExpressionTranslation;
    private final MemoryHandler mMemoryHandler;
    private final ITypeHandler mTypeHandler;
    private final TypeSizes mTypeSizes;
    private final FlatSymbolTable mSymbolTable;
    private final Map<IBinding, Integer> mUnambiguousThreadIds = new HashMap<IBinding, Integer>();

    public ThreadIdManager(AuxVarInfoBuilder auxVarInfoBuilder, ExpressionResultTransformer expressionResultTransformer, ExpressionTranslation expressionTranslation, MemoryHandler memoryHandler, ITypeHandler iTypeHandler, TypeSizes typeSizes, Collection<IASTTranslationUnit> collection, FlatSymbolTable flatSymbolTable) {
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mExpressionResultTransformer = expressionResultTransformer;
        this.mExpressionTranslation = expressionTranslation;
        this.mTranslationUnits = collection;
        this.mMemoryHandler = memoryHandler;
        this.mTypeHandler = iTypeHandler;
        this.mTypeSizes = typeSizes;
        this.mSymbolTable = flatSymbolTable;
    }

    public Expression[] updateForkedThreadId(IASTInitializerClause iASTInitializerClause, IDispatcher iDispatcher, ILocation iLocation, IASTNode iASTNode, ExpressionResultBuilder expressionResultBuilder) {
        this.mMemoryHandler.requireMemoryModelFeature(MemoryModelDeclarations.ULTIMATE_PTHREADS_FORK_COUNT);
        Expression expression = this.getOldForkCounterAsTemp(iLocation, expressionResultBuilder);
        this.incrementForkCounter(iLocation, expressionResultBuilder);
        ExpressionResult expressionResult = this.mExpressionResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClause);
        expressionResultBuilder.addAllExceptLrValue(expressionResult, this.mExpressionResultTransformer.makePointerAssignment(iLocation, expressionResult.getLrValue(), expression));
        Integer n = this.getUnambiguousThreadIdCounter(iASTInitializerClause);
        if (n != null) {
            return this.createUnambiguousThreadId(n, iLocation, expression);
        }
        return new Expression[]{expression};
    }

    public Expression[] getJoinedThreadId(IASTInitializerClause iASTInitializerClause, IDispatcher iDispatcher, ILocation iLocation, ExpressionResultBuilder expressionResultBuilder) {
        CPrimitive cPrimitive = this.mTypeHandler.getThreadIdType();
        ExpressionResult expressionResult = this.mExpressionResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClause);
        ExpressionResult expressionResult2 = this.mExpressionResultTransformer.performImplicitConversion(expressionResult, cPrimitive, iLocation);
        expressionResultBuilder.addAllExceptLrValue(expressionResult2);
        Expression expression = expressionResult2.getLrValue().getValue();
        Integer n = this.getUnambiguousThreadIdCounter(iASTInitializerClause);
        if (n != null) {
            return this.createUnambiguousThreadId(n, iLocation, expression);
        }
        return new Expression[]{expression};
    }

    private Expression getOldForkCounterAsTemp(ILocation iLocation, ExpressionResultBuilder expressionResultBuilder) {
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, this.mTypeHandler.getThreadIdType(), SFO.AUXVAR.PRE_MOD);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        IdentifierExpression identifierExpression = this.mMemoryHandler.getPthreadForkCount(iLocation);
        AssignmentStatement assignmentStatement = new AssignmentStatement(iLocation, new LeftHandSide[]{auxVarInfo.getLhs()}, new Expression[]{identifierExpression});
        expressionResultBuilder.addStatement((Statement)assignmentStatement);
        return auxVarInfo.getExp();
    }

    private void incrementForkCounter(ILocation iLocation, ExpressionResultBuilder expressionResultBuilder) {
        IdentifierExpression identifierExpression = this.mMemoryHandler.getPthreadForkCount(iLocation);
        CPrimitive cPrimitive = this.mTypeHandler.getThreadIdType();
        VariableLHS variableLHS = new VariableLHS(iLocation, identifierExpression.getType(), identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation());
        Expression expression = this.mExpressionTranslation.constructArithmeticExpression(iLocation, 4, (Expression)identifierExpression, cPrimitive, this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.valueOf(1L)), cPrimitive);
        AssignmentStatement assignmentStatement = new AssignmentStatement(iLocation, (LeftHandSide[])new VariableLHS[]{variableLHS}, new Expression[]{expression});
        expressionResultBuilder.addStatement((Statement)assignmentStatement);
    }

    private Integer getUnambiguousThreadIdCounter(IASTInitializerClause iASTInitializerClause) {
        IASTName iASTName = ThreadIdManager.getDirectReference(iASTInitializerClause);
        if (iASTName == null) {
            return null;
        }
        IBinding iBinding = iASTName.resolveBinding();
        if (iBinding == null) {
            return null;
        }
        Integer n = this.mUnambiguousThreadIds.get(iBinding);
        if (n != null) {
            return n;
        }
        Set<IASTName> set = this.findAllReferences(iBinding, (IASTNode)iASTName);
        if (set != null && ThreadIdManager.onlyForkJoinReferences(set)) {
            int n2 = this.mUnambiguousThreadIds.size() + 1;
            this.mUnambiguousThreadIds.put(iBinding, n2);
            return n2;
        }
        return null;
    }

    private Set<IASTName> findAllReferences(IBinding iBinding, IASTNode iASTNode) {
        FindBindingReferences findBindingReferences = new FindBindingReferences(iBinding);
        SymbolTableValue symbolTableValue = this.mSymbolTable.findCSymbol(iASTNode, iBinding.getName());
        if (symbolTableValue == null) {
            assert (false) : "Cannot find binding in symbol table";
            return null;
        }
        IASTNode iASTNode2 = this.mSymbolTable.tableFindCursor(iASTNode, iBinding.getName(), symbolTableValue);
        if (iASTNode2 == null) {
            assert (false) : "Cannot find symbol table value in the same symbol table";
            return null;
        }
        iASTNode2.accept((ASTVisitor)findBindingReferences);
        return findBindingReferences.getReferences();
    }

    private static IASTName getDirectReference(IASTInitializerClause iASTInitializerClause) {
        if (iASTInitializerClause instanceof IASTIdExpression) {
            return ((IASTIdExpression)iASTInitializerClause).getName();
        }
        if (!(iASTInitializerClause instanceof IASTUnaryExpression)) {
            return null;
        }
        IASTUnaryExpression iASTUnaryExpression = (IASTUnaryExpression)iASTInitializerClause;
        if (iASTUnaryExpression.getOperator() != 5 || !(iASTUnaryExpression.getOperand() instanceof IASTIdExpression)) {
            return null;
        }
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTUnaryExpression.getOperand();
        return iASTIdExpression.getName();
    }

    private static boolean onlyForkJoinReferences(Set<IASTName> set) {
        return set.stream().allMatch(iASTName -> ThreadIdManager.isPthreadCreateReference(iASTName) || ThreadIdManager.isPthreadJoinReference(iASTName));
    }

    private static boolean isPthreadCreateReference(IASTName iASTName) {
        IASTNode iASTNode = iASTName.getParent();
        if (!(iASTNode instanceof IASTIdExpression)) {
            return false;
        }
        IASTNode iASTNode2 = iASTNode.getParent();
        if (!(iASTNode2 instanceof IASTUnaryExpression)) {
            return false;
        }
        IASTUnaryExpression iASTUnaryExpression = (IASTUnaryExpression)iASTNode2;
        if (iASTUnaryExpression.getOperator() != 5) {
            return false;
        }
        return ThreadIdManager.isFirstArgumentOfFunCall((IASTNode)iASTUnaryExpression, "pthread_create");
    }

    private static boolean isPthreadJoinReference(IASTName iASTName) {
        IASTNode iASTNode = iASTName.getParent();
        if (!(iASTNode instanceof IASTIdExpression)) {
            return false;
        }
        return ThreadIdManager.isFirstArgumentOfFunCall(iASTNode, "pthread_join");
    }

    private static boolean isFirstArgumentOfFunCall(IASTNode iASTNode, String string) {
        IASTNode iASTNode2 = iASTNode.getParent();
        if (!(iASTNode2 instanceof IASTFunctionCallExpression)) {
            return false;
        }
        IASTFunctionCallExpression iASTFunctionCallExpression = (IASTFunctionCallExpression)iASTNode2;
        if (iASTFunctionCallExpression.getArguments().length == 0 || iASTFunctionCallExpression.getArguments()[0] != iASTNode) {
            return false;
        }
        IASTExpression iASTExpression = iASTFunctionCallExpression.getFunctionNameExpression();
        if (!(iASTExpression instanceof IASTIdExpression)) {
            return false;
        }
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTExpression;
        String string2 = iASTIdExpression.getName().toString();
        return string.equals(string2);
    }

    private Expression[] createUnambiguousThreadId(int n, ILocation iLocation, Expression expression) {
        Expression[] expressionArray = new Expression[n + 1];
        expressionArray[0] = expression;
        int n2 = 0;
        while (n2 < n) {
            expressionArray[n2 + 1] = this.mExpressionTranslation.constructZero(iLocation, new CPrimitive(CPrimitive.CPrimitives.INT));
            ++n2;
        }
        return expressionArray;
    }
}

