/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MultiDimensionalSelectOverNestedStore
implements ITermProvider {
    private final ArrayIndex mSelectIndex;
    private final MultiDimensionalNestedStore mNestedStore;

    public MultiDimensionalSelectOverNestedStore(ArrayIndex arrayIndex, MultiDimensionalNestedStore multiDimensionalNestedStore) {
        if (arrayIndex.size() != multiDimensionalNestedStore.getDimension()) {
            throw new IllegalArgumentException("Incompatible dimensions");
        }
        this.mSelectIndex = arrayIndex;
        this.mNestedStore = multiDimensionalNestedStore;
    }

    public ArrayIndex getSelectIndex() {
        return this.mSelectIndex;
    }

    public MultiDimensionalNestedStore getNestedStore() {
        return this.mNestedStore;
    }

    @Override
    public Term toTerm(Script script) {
        return new MultiDimensionalSelect(this.mNestedStore.toTerm(script), this.mSelectIndex).toTerm(script);
    }

    public static MultiDimensionalSelectOverNestedStore of(Term term) {
        MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of(term);
        if (multiDimensionalSelect == null) {
            return null;
        }
        MultiDimensionalNestedStore multiDimensionalNestedStore = MultiDimensionalNestedStore.of(multiDimensionalSelect.getArray());
        if (multiDimensionalNestedStore == null) {
            return null;
        }
        if (multiDimensionalSelect.getDimension() != multiDimensionalNestedStore.getDimension()) {
            return null;
        }
        return new MultiDimensionalSelectOverNestedStore(multiDimensionalSelect.getIndex(), multiDimensionalNestedStore);
    }

    public Term constructNotEqualsReplacement(Script script) {
        MultiDimensionalSelect multiDimensionalSelect = new MultiDimensionalSelect(this.getNestedStore().getArray(), this.getSelectIndex());
        return multiDimensionalSelect.toTerm(script);
    }

    public static List<MultiDimensionalSelectOverNestedStore> extractMultiDimensionalSelectOverNestedStore(Term term, boolean bl) {
        ArrayList<MultiDimensionalSelectOverNestedStore> arrayList = new ArrayList<MultiDimensionalSelectOverNestedStore>();
        List<MultiDimensionalSelect> list = MultiDimensionalSelect.extractSelectShallow(term);
        for (MultiDimensionalSelect multiDimensionalSelect : list) {
            MultiDimensionalNestedStore multiDimensionalNestedStore = MultiDimensionalNestedStore.of(multiDimensionalSelect.getArray());
            if (multiDimensionalNestedStore != null && multiDimensionalNestedStore.getDimension() == multiDimensionalSelect.getDimension()) {
                arrayList.add(new MultiDimensionalSelectOverNestedStore(multiDimensionalSelect.getIndex(), multiDimensionalNestedStore));
                if (bl) continue;
                arrayList.addAll(MultiDimensionalSelectOverNestedStore.extractMultiDimensionalSelectOverNestedStore(multiDimensionalNestedStore.getArray(), bl));
                int n = 0;
                while (n < multiDimensionalNestedStore.getIndices().size()) {
                    arrayList.addAll(MultiDimensionalSelectOverNestedStore.extractMultiDimensionalSelectOverNestedStore(multiDimensionalNestedStore.getValues().get(n), bl));
                    int n2 = 0;
                    while (n2 < multiDimensionalNestedStore.getDimension()) {
                        Term term2 = multiDimensionalNestedStore.getIndices().get(n).get(n2);
                        arrayList.addAll(MultiDimensionalSelectOverNestedStore.extractMultiDimensionalSelectOverNestedStore(term2, bl));
                        ++n2;
                    }
                    ++n;
                }
                continue;
            }
            arrayList.addAll(MultiDimensionalSelectOverNestedStore.extractMultiDimensionalSelectOverNestedStore(multiDimensionalSelect.getArray(), bl));
            for (Term term3 : multiDimensionalSelect.getIndex()) {
                arrayList.addAll(MultiDimensionalSelectOverNestedStore.extractMultiDimensionalSelectOverNestedStore(term3, bl));
            }
        }
        return arrayList;
    }

    public int hashCode() {
        return Objects.hash(this.mNestedStore, this.mSelectIndex);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalSelectOverNestedStore multiDimensionalSelectOverNestedStore = (MultiDimensionalSelectOverNestedStore)object;
        if (this.mNestedStore == null ? multiDimensionalSelectOverNestedStore.mNestedStore != null : !this.mNestedStore.equals(multiDimensionalSelectOverNestedStore.mNestedStore)) {
            return false;
        }
        return !(this.mSelectIndex == null ? multiDimensionalSelectOverNestedStore.mSelectIndex != null : !this.mSelectIndex.equals(multiDimensionalSelectOverNestedStore.mSelectIndex));
    }
}

