/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.Ordinal;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ParallelRankingFunction
extends RankingFunction {
    private static final long serialVersionUID = -8148235363885204843L;
    private final AffineFunction[] mranking;
    public final int size;

    public ParallelRankingFunction(AffineFunction[] affineFunctionArray) {
        this.mranking = affineFunctionArray;
        this.size = affineFunctionArray.length;
        assert (this.size > 0);
    }

    @Override
    public String getName() {
        return this.mranking.length + "-parallel";
    }

    @Override
    public Set<IProgramVar> getVariables() {
        LinkedHashSet<IProgramVar> linkedHashSet = new LinkedHashSet<IProgramVar>();
        AffineFunction[] affineFunctionArray = this.mranking;
        int n = this.mranking.length;
        int n2 = 0;
        while (n2 < n) {
            AffineFunction affineFunction = affineFunctionArray[n2];
            linkedHashSet.addAll(affineFunction.getVariables());
            ++n2;
        }
        return linkedHashSet;
    }

    public AffineFunction[] getComponents() {
        return this.mranking;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mranking.length);
        stringBuilder.append("-parallel ranking function:\n");
        stringBuilder.append("f = ");
        int n = 0;
        while (n < this.size) {
            if (n > 0) {
                stringBuilder.append(" + ");
            }
            stringBuilder.append("max{0, ");
            stringBuilder.append(this.mranking[n]);
            stringBuilder.append("}");
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public Term[] asLexTerm(Script script) throws SMTLIBException {
        Term term = SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO);
        Term[] termArray = new Term[this.size];
        int n = 0;
        while (n < this.size) {
            Term term2 = this.mranking[n].asTerm(script);
            Term term3 = script.term(">", new Term[]{term2, term});
            termArray[n] = script.term("ite", new Term[]{term3, term2, term});
            ++n;
        }
        return new Term[]{script.term("+", termArray)};
    }

    @Override
    public Ordinal evaluate(Map<IProgramVar, Rational> map) {
        Ordinal ordinal = Ordinal.ZERO;
        int n = 0;
        while (n < this.size) {
            Rational rational = this.mranking[n].evaluate(map);
            if (rational.compareTo(Rational.ZERO) > 0) {
                ordinal = ordinal.add(Ordinal.fromInteger(rational.ceil().numerator()));
            }
            ++n;
        }
        return ordinal;
    }

    @Override
    public Ordinal codomain() {
        return Ordinal.OMEGA;
    }
}

