/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayUpdate {
    private final TermVariable mNewArray;
    private final MultiDimensionalStore mMultiDimensionalStore;
    private final Term mStoreAsTerm;
    private final Term mArrayUpdateTerm;
    private final boolean mIsNegatedEquality;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayUpdate(Term term, boolean bl, boolean bl2) throws ArrayUpdateException {
        ApplicationTerm applicationTerm;
        BinaryEqualityRelation binaryEqualityRelation = BinaryEqualityRelation.convert(term);
        if (binaryEqualityRelation == null) {
            throw new ArrayUpdateException("not a binary equality relation");
        }
        if (bl && binaryEqualityRelation.getRelationSymbol() != RelationSymbol.DISTINCT) {
            throw new ArrayUpdateException("no negated array update");
        }
        if (!bl && binaryEqualityRelation.getRelationSymbol() != RelationSymbol.EQ) {
            throw new ArrayUpdateException("no not negated array update");
        }
        this.mArrayUpdateTerm = term;
        this.mIsNegatedEquality = bl;
        Term term2 = binaryEqualityRelation.getLhs();
        Term term3 = binaryEqualityRelation.getRhs();
        if (this.isArrayTermVariable(term2)) {
            if (!this.isStoreTerm(term3)) throw new ArrayUpdateException("no array update");
            this.mNewArray = (TermVariable)term2;
            applicationTerm = (ApplicationTerm)term3;
        } else {
            if (!this.isArrayTermVariable(term3)) throw new ArrayUpdateException("no array update");
            if (!this.isStoreTerm(term2)) throw new ArrayUpdateException("no array update");
            this.mNewArray = (TermVariable)term3;
            applicationTerm = (ApplicationTerm)term2;
        }
        assert (applicationTerm.getFunction().getName().equals("store"));
        assert (applicationTerm.getParameters().length == 3);
        assert (this.mNewArray.getSort() == applicationTerm.getSort());
        this.mMultiDimensionalStore = MultiDimensionalStore.of((Term)applicationTerm);
        if (this.mMultiDimensionalStore.getIndex().isEmpty()) {
            throw new ArrayUpdateException("no multidimensional array");
        }
        if (!this.mMultiDimensionalStore.getArray().getSort().equals(this.mNewArray.getSort())) {
            throw new AssertionError((Object)"sort mismatch");
        }
        if (bl2 && !(this.mMultiDimensionalStore.getArray() instanceof TermVariable)) {
            throw new ArrayUpdateException("old array is no term variable");
        }
        this.mStoreAsTerm = applicationTerm;
    }

    private boolean isArrayTermVariable(Term term) {
        return term instanceof TermVariable && term.getSort().isArraySort();
    }

    private boolean isStoreTerm(Term term) {
        ApplicationTerm applicationTerm;
        return term instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term).getFunction().getName().equals("store");
    }

    TermVariable isArrayWithSort(Term term, Sort sort) {
        if (term instanceof TermVariable) {
            if (term.getSort().equals(sort)) {
                return (TermVariable)term;
            }
            return null;
        }
        return null;
    }

    public Term getOldArray() {
        return this.mMultiDimensionalStore.getArray();
    }

    public TermVariable getNewArray() {
        return this.mNewArray;
    }

    public ArrayIndex getIndex() {
        return this.mMultiDimensionalStore.getIndex();
    }

    public Term getValue() {
        return this.mMultiDimensionalStore.getValue();
    }

    public Term getArrayUpdateTerm() {
        return this.mArrayUpdateTerm;
    }

    public MultiDimensionalStore getMultiDimensionalStore() {
        return this.mMultiDimensionalStore;
    }

    public boolean isNegatedEquality() {
        return this.mIsNegatedEquality;
    }

    public Term getStoreAsTerm() {
        return this.mStoreAsTerm;
    }

    public String toString() {
        return this.mArrayUpdateTerm.toString();
    }

    public static List<ArrayUpdate> extractArrayUpdates(Term term) {
        return ArrayUpdate.extractArrayUpdates(term, true);
    }

    public static List<ArrayUpdate> extractArrayUpdates(Term term, boolean bl) {
        Set<String> set = Set.of("=", "distinct", "not");
        ArrayList<ArrayUpdate> arrayList = new ArrayList<ArrayUpdate>();
        for (ApplicationTerm applicationTerm : SmtUtils.extractApplicationTerms(set, term, false)) {
            ArrayUpdate arrayUpdate = null;
            boolean bl2 = applicationTerm.getFunction().getName().equals("not") || applicationTerm.getFunction().getName().equals("distinct");
            try {
                arrayUpdate = new ArrayUpdate((Term)applicationTerm, bl2, bl);
            }
            catch (ArrayUpdateException arrayUpdateException) {
                continue;
            }
            arrayList.add(arrayUpdate);
        }
        return arrayList;
    }

    public static class ArrayUpdateException
    extends Exception {
        private static final long serialVersionUID = -5344050289008681972L;

        public ArrayUpdateException(String string) {
            super(string);
        }
    }

    public static class ArrayUpdateExtractor {
        private final Map<Term, Term> mStore2TermVariable = new HashMap<Term, Term>();
        private final List<ArrayUpdate> mArrayUpdates = new ArrayList<ArrayUpdate>();
        private final List<Term> remainingTerms = new ArrayList<Term>();

        public ArrayUpdateExtractor(boolean bl, boolean bl2, Term ... termArray) {
            Term[] termArray2 = termArray;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayUpdate arrayUpdate;
                Term term = termArray2[n2];
                try {
                    arrayUpdate = new ArrayUpdate(term, bl, bl2);
                }
                catch (ArrayUpdateException arrayUpdateException) {
                    arrayUpdate = null;
                }
                if (arrayUpdate == null) {
                    this.remainingTerms.add(term);
                } else {
                    this.mArrayUpdates.add(arrayUpdate);
                    this.mStore2TermVariable.put(arrayUpdate.getStoreAsTerm(), (Term)arrayUpdate.getNewArray());
                }
                ++n2;
            }
        }

        public Map<Term, Term> getStore2TermVariable() {
            return this.mStore2TermVariable;
        }

        public List<ArrayUpdate> getArrayUpdates() {
            return this.mArrayUpdates;
        }

        public List<Term> getRemainingTerms() {
            return this.remainingTerms;
        }
    }
}

